/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceGroup;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.internal.registry.CategorizedPageRegistryReader;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PreferencePageRegistryReader
extends CategorizedPageRegistryReader {
    private static final String ATT_GROUP = "group";
    private static final String ATT_CLASS = "class";
    private static final String ATT_NAME = "name";
    private static final String ATT_ID = "id";
    private static final String TAG_PAGE = "page";
    private static final String ATT_ICON = "icon";
    private static final String ATT_GROUP_DEFAULT = "default";
    private static final String TRUE_STRING = "true";
    private static final String TAG_GROUP = "group";
    private List nodes;
    private List groups;
    private IWorkbench workbench;

    public PreferencePageRegistryReader(IWorkbench newWorkbench) {
        this.workbench = newWorkbench;
    }

    Object findNode(String id) {
        int i = 0;
        while (i < this.nodes.size()) {
            WorkbenchPreferenceNode node = (WorkbenchPreferenceNode)this.nodes.get(i);
            if (node.getId().equals(id)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    Object findNode(Object parent, String currentToken) {
        IPreferenceNode[] subNodes = ((WorkbenchPreferenceNode)parent).getSubNodes();
        int i = 0;
        while (i < subNodes.length) {
            WorkbenchPreferenceNode node = (WorkbenchPreferenceNode)subNodes[i];
            if (node.getId().equals(currentToken)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    void add(Object parent, Object node) {
        ((IPreferenceNode)parent).add((IPreferenceNode)node);
    }

    CategorizedPageRegistryReader.CategoryNode createCategoryNode(CategorizedPageRegistryReader reader, Object object) {
        return new PreferencesCategoryNode(reader, (WorkbenchPreferenceNode)object);
    }

    String getCategory(Object node) {
        return ((WorkbenchPreferenceNode)node).getCategory();
    }

    Collection getNodes() {
        return this.nodes;
    }

    public void loadFromRegistry(IExtensionRegistry registry) {
        this.nodes = new ArrayList();
        this.groups = new ArrayList();
        this.readRegistry(registry, "org.eclipse.ui", "preferencePages");
        this.processNodes();
        this.processGroups();
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals("group")) {
            return this.readGroupElement(element);
        }
        if (!element.getName().equals(TAG_PAGE)) {
            return false;
        }
        WorkbenchPreferenceNode node = PreferencePageRegistryReader.createNode(this.workbench, element);
        if (node != null) {
            this.nodes.add(node);
        }
        this.readElementChildren(element);
        return true;
    }

    private boolean readGroupElement(IConfigurationElement element) {
        String name = element.getAttribute(ATT_NAME);
        String id = element.getAttribute(ATT_ID);
        String icon = element.getAttribute(ATT_ICON);
        boolean defaultValue = TRUE_STRING.equals(element.getAttribute(ATT_GROUP_DEFAULT));
        Collection pageIds = this.readPages(element);
        ImageDescriptor descriptor = null;
        if (icon != null) {
            String contributingPluginId = element.getDeclaringExtension().getNamespace();
            descriptor = AbstractUIPlugin.imageDescriptorFromPlugin(contributingPluginId, icon);
        }
        this.groups.add(new WorkbenchPreferenceGroup(id, name, pageIds, descriptor, defaultValue));
        return true;
    }

    public static WorkbenchPreferenceNode createNode(IWorkbench workbench, IConfigurationElement element) {
        String name = element.getAttribute(ATT_NAME);
        String id = element.getAttribute(ATT_ID);
        String category = element.getAttribute("category");
        String imageName = element.getAttribute(ATT_ICON);
        String className = element.getAttribute(ATT_CLASS);
        if (name == null) {
            RegistryReader.logMissingAttribute(element, ATT_NAME);
        }
        if (id == null) {
            RegistryReader.logMissingAttribute(element, ATT_ID);
        }
        if (className == null) {
            RegistryReader.logMissingAttribute(element, ATT_CLASS);
        }
        if (name == null || id == null || className == null) {
            return null;
        }
        ImageDescriptor image = null;
        if (imageName != null) {
            String contributingPluginId = element.getDeclaringExtension().getNamespace();
            image = AbstractUIPlugin.imageDescriptorFromPlugin(contributingPluginId, imageName);
        }
        WorkbenchPreferenceNode node = new WorkbenchPreferenceNode(id, name, category, image, element, workbench);
        return node;
    }

    private Collection readPages(IConfigurationElement element) {
        IConfigurationElement[] pages = element.getChildren(TAG_PAGE);
        HashSet<String> list = new HashSet<String>();
        int i = 0;
        while (i < pages.length) {
            IConfigurationElement page = pages[i];
            String id = page.getAttribute(ATT_ID);
            if (id != null) {
                list.add(id);
            }
            ++i;
        }
        return list;
    }

    private void processGroups() {
        Hashtable nodeToGroupMapping = new Hashtable();
        WorkbenchPreferenceGroup defaultGroup = null;
        Iterator groupIterator = this.groups.iterator();
        while (groupIterator.hasNext()) {
            WorkbenchPreferenceGroup nextGroup = (WorkbenchPreferenceGroup)groupIterator.next();
            Iterator pages = nextGroup.getPageIds().iterator();
            while (pages.hasNext()) {
                nodeToGroupMapping.put(pages.next(), nextGroup);
            }
            if (!nextGroup.isDefault()) continue;
            defaultGroup = nextGroup;
        }
        Iterator nodeIterator = this.nodes.iterator();
        while (nodeIterator.hasNext()) {
            WorkbenchPreferenceNode node = (WorkbenchPreferenceNode)nodeIterator.next();
            if (nodeToGroupMapping.containsKey(node.getId())) {
                ((WorkbenchPreferenceGroup)nodeToGroupMapping.get(node.getId())).addNode(node);
                continue;
            }
            if (!this.topLevelNodes.contains(node) || defaultGroup == null) continue;
            defaultGroup.addNode(node);
        }
    }

    public Collection getTopLevelNodes() {
        return this.topLevelNodes;
    }

    String getFavoriteNodeId() {
        return ((Workbench)this.workbench).getMainPreferencePageId();
    }

    public Collection getGroups() {
        return this.groups;
    }

    class PreferencesCategoryNode
    extends CategorizedPageRegistryReader.CategoryNode {
        WorkbenchPreferenceNode node;

        public PreferencesCategoryNode(CategorizedPageRegistryReader reader, WorkbenchPreferenceNode nodeToCategorize) {
            super(reader);
            this.node = nodeToCategorize;
        }

        String getLabelText() {
            return this.node.getLabelText();
        }

        String getLabelText(Object element) {
            return ((WorkbenchPreferenceNode)element).getLabelText();
        }

        Object getNode() {
            return this.node;
        }
    }
}

