/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;
import org.eclipse.ui.internal.registry.CategorizedPageRegistryReader;
import org.eclipse.ui.internal.registry.RegistryReader;

public class PropertyPagesRegistryReader
extends CategorizedPageRegistryReader {
    public static final String ATT_NAME_FILTER = "nameFilter";
    public static final String ATT_FILTER_NAME = "name";
    public static final String ATT_FILTER_VALUE = "value";
    public static final String ATT_CLASS = "class";
    private static final String TAG_PAGE = "page";
    public static final String TAG_FILTER = "filter";
    public static final String ATT_NAME = "name";
    private static final String ATT_ID = "id";
    public static final String ATT_ICON = "icon";
    public static final String ATT_OBJECTCLASS = "objectClass";
    public static final String ATT_ADAPTABLE = "adaptable";
    private static final String P_TRUE = "true";
    private HashMap filterProperties;
    private Collection pages = new ArrayList();
    private PropertyPageContributorManager manager;

    public PropertyPagesRegistryReader(PropertyPageContributorManager manager) {
        this.manager = manager;
    }

    private void processPageElement(IConfigurationElement element) {
        String pageId = element.getAttribute(ATT_ID);
        String pageClassName = element.getAttribute(ATT_CLASS);
        String objectClassName = element.getAttribute(ATT_OBJECTCLASS);
        if (pageId == null) {
            RegistryReader.logMissingAttribute(element, ATT_ID);
            return;
        }
        if (objectClassName == null) {
            RegistryReader.logMissingAttribute(element, ATT_OBJECTCLASS);
            return;
        }
        if (pageClassName == null) {
            RegistryReader.logMissingAttribute(element, ATT_CLASS);
            return;
        }
        RegistryPageContributor contributor = new RegistryPageContributor(pageId, element);
        this.registerContributor(contributor, objectClassName);
    }

    public boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_PAGE)) {
            this.processPageElement(element);
            this.readElementChildren(element);
            return true;
        }
        return element.getName().equals(TAG_FILTER);
    }

    private void registerContributor(RegistryPageContributor contributor, String objectClassName) {
        this.manager.registerContributor(contributor, objectClassName);
        this.pages.add(contributor);
    }

    public void registerPropertyPages(IExtensionRegistry registry) {
        this.readRegistry(registry, "org.eclipse.ui", "propertyPages");
        this.processNodes();
    }

    void add(Object parent, Object node) {
        ((RegistryPageContributor)parent).addSubPage((RegistryPageContributor)node);
    }

    CategorizedPageRegistryReader.CategoryNode createCategoryNode(CategorizedPageRegistryReader reader, Object object) {
        return new PropertyCategoryNode(reader, (RegistryPageContributor)object);
    }

    Object findNode(Object parent, String currentToken) {
        return ((RegistryPageContributor)parent).getChild(currentToken);
    }

    Object findNode(String id) {
        Iterator iterator = this.pages.iterator();
        while (iterator.hasNext()) {
            RegistryPageContributor next = (RegistryPageContributor)iterator.next();
            if (!next.getPageId().equals(id)) continue;
            return next;
        }
        return null;
    }

    String getCategory(Object node) {
        return ((RegistryPageContributor)node).getCategory();
    }

    String getFavoriteNodeId() {
        return null;
    }

    Collection getNodes() {
        return this.pages;
    }

    class PropertyCategoryNode
    extends CategorizedPageRegistryReader.CategoryNode {
        RegistryPageContributor page;

        PropertyCategoryNode(CategorizedPageRegistryReader reader, RegistryPageContributor propertyPage) {
            super(reader);
            this.page = propertyPage;
        }

        String getLabelText() {
            return this.page.getPageName();
        }

        String getLabelText(Object element) {
            return ((RegistryPageContributor)element).getPageName();
        }

        Object getNode() {
            return this.page;
        }
    }
}

