/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.internal.registry.ShowViewHandler;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ViewDescriptor
implements IViewDescriptor,
IPluginContribution {
    private String id;
    private ImageDescriptor imageDescriptor;
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ACCELERATOR = "accelerator";
    private static final String ATT_ICON = "icon";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_CLASS = "class";
    private static final String ATT_RATIO = "fastViewWidthRatio";
    private static final String ATT_MULTIPLE = "allowMultiple";
    private static final String TAG_DESCRIPTION = "description";
    private IConfigurationElement configElement;
    private String[] categoryPath;
    private float fastViewWidthRatio;

    public ViewDescriptor(IConfigurationElement e) throws CoreException {
        this.configElement = e;
        this.loadFromExtension();
        this.registerShowViewHandler();
    }

    private void registerShowViewHandler() {
        ShowViewHandler showViewHandler = new ShowViewHandler(this.getId());
        HandlerSubmission showViewSubmission = new HandlerSubmission(null, null, null, this.getId(), showViewHandler, Priority.MEDIUM);
        PlatformUI.getWorkbench().getCommandSupport().addHandlerSubmission(showViewSubmission);
    }

    public IViewPart createView() throws CoreException {
        Object obj = WorkbenchPlugin.createExtension(this.configElement, ATT_CLASS);
        return (IViewPart)obj;
    }

    public String[] getCategoryPath() {
        return this.categoryPath;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    public String getDescription() {
        return RegistryReader.getDescription(this.configElement);
    }

    public String getID() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        String iconName = this.configElement.getAttribute(ATT_ICON);
        if (iconName == null) {
            return null;
        }
        IExtension extension = this.configElement.getDeclaringExtension();
        String extendingPluginId = extension.getNamespace();
        this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(extendingPluginId, iconName);
        return this.imageDescriptor;
    }

    public String getLabel() {
        return this.configElement.getAttribute(ATT_NAME);
    }

    public String getAccelerator() {
        return this.configElement.getAttribute(ATT_ACCELERATOR);
    }

    public float getFastViewWidthRatio() {
        this.configElement.getAttribute(ATT_RATIO);
        return this.fastViewWidthRatio;
    }

    private void loadFromExtension() throws CoreException {
        String ratio;
        this.id = this.configElement.getAttribute(ATT_ID);
        String category = this.configElement.getAttribute(ATT_CATEGORY);
        if (this.configElement.getAttribute(ATT_NAME) == null || this.configElement.getAttribute(ATT_CLASS) == null) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getDeclaringExtension().getNamespace(), 0, "Invalid extension (missing label or class name): " + this.id, null));
        }
        if (category != null) {
            StringTokenizer stok = new StringTokenizer(category, "/");
            this.categoryPath = new String[stok.countTokens()];
            int i = 0;
            while (stok.hasMoreTokens()) {
                this.categoryPath[i] = stok.nextToken();
                ++i;
            }
        }
        if ((ratio = this.configElement.getAttribute(ATT_RATIO)) != null) {
            try {
                this.fastViewWidthRatio = new Float(ratio).floatValue();
                if (this.fastViewWidthRatio > 0.95f) {
                    this.fastViewWidthRatio = 0.95f;
                }
                if (this.fastViewWidthRatio < 0.05f) {
                    this.fastViewWidthRatio = 0.05f;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.fastViewWidthRatio = 0.3f;
            }
        } else {
            this.fastViewWidthRatio = 0.3f;
        }
    }

    public String toString() {
        return "View(" + this.getID() + ")";
    }

    public String getPluginId() {
        String pluginId = this.configElement.getNamespace();
        return pluginId == null ? "" : pluginId;
    }

    public String getLocalId() {
        return this.getId() == null ? "" : this.getId();
    }

    public boolean fromPlugin() {
        return true;
    }

    public boolean getAllowMultiple() {
        String string = this.configElement.getAttribute(ATT_MULTIPLE);
        return string == null ? false : Boolean.valueOf(string);
    }
}

