/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.model.AdaptableList;

public class WizardsRegistryReader
extends RegistryReader {
    private AdaptableList wizards;
    private String pluginPoint;
    public static final String TAG_WIZARD = "wizard";
    public static final String ATT_NAME = "name";
    public static final String ATT_CLASS = "class";
    public static final String ATT_ICON = "icon";
    public static final String ATT_ID = "id";
    public static final String trueString = "TRUE";

    public WizardsRegistryReader(String pluginPointId) {
        this.pluginPoint = pluginPointId;
    }

    protected void addNewElementToResult(WorkbenchWizardElement wizard, IConfigurationElement config) {
        this.wizards.add(wizard);
    }

    protected void createEmptyWizardCollection() {
        this.wizards = new AdaptableList();
    }

    protected WorkbenchWizardElement createWizardElement(IConfigurationElement element) {
        if (element.getAttribute(ATT_NAME) == null) {
            RegistryReader.logMissingAttribute(element, ATT_NAME);
            return null;
        }
        if (element.getAttribute(ATT_CLASS) == null && element.getChildren(ATT_CLASS).length == 0) {
            RegistryReader.logMissingAttribute(element, ATT_CLASS);
            return null;
        }
        return new WorkbenchWizardElement(element);
    }

    public WorkbenchWizardElement findWizard(String id) {
        Object[] wizards = this.getWizardCollectionElements();
        int nX = 0;
        while (nX < wizards.length) {
            WizardCollectionElement collection = (WizardCollectionElement)wizards[nX];
            WorkbenchWizardElement element = collection.findWizard(id, true);
            if (element != null) {
                return element;
            }
            ++nX;
        }
        return null;
    }

    public AdaptableList getWizards() {
        if (!this.areWizardsRead()) {
            this.readWizards();
        }
        return this.wizards;
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(TAG_WIZARD)) {
            return false;
        }
        WorkbenchWizardElement wizard = this.createWizardElement(element);
        if (wizard != null) {
            this.addNewElementToResult(wizard, element);
        }
        return true;
    }

    protected void readWizards() {
        if (!this.areWizardsRead()) {
            this.createEmptyWizardCollection();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            this.readRegistry(registry, WorkbenchPlugin.PI_WORKBENCH, this.pluginPoint);
        }
    }

    protected boolean areWizardsRead() {
        return this.wizards != null;
    }

    protected Object[] getWizardCollectionElements() {
        if (!this.areWizardsRead()) {
            this.readWizards();
        }
        return this.wizards.getChildren();
    }
}

