/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistryReader;

public class WorkingSetRegistry {
    private static final String DEFAULT_PAGE_ID = "org.eclipse.ui.resourceWorkingSetPage";
    private HashMap workingSetDescriptors = new HashMap();

    public void addWorkingSetDescriptor(WorkingSetDescriptor descriptor) {
        Assert.isTrue((!this.workingSetDescriptors.containsValue(descriptor) ? 1 : 0) != 0, (String)"working set descriptor already registered");
        this.workingSetDescriptors.put(descriptor.getId(), descriptor);
    }

    public IWorkingSetPage getDefaultWorkingSetPage() {
        WorkingSetDescriptor descriptor = (WorkingSetDescriptor)this.workingSetDescriptors.get(DEFAULT_PAGE_ID);
        if (descriptor != null) {
            return descriptor.createWorkingSetPage();
        }
        return null;
    }

    public WorkingSetDescriptor getWorkingSetDescriptor(String pageId) {
        return (WorkingSetDescriptor)this.workingSetDescriptors.get(pageId);
    }

    public WorkingSetDescriptor[] getWorkingSetDescriptors() {
        return this.workingSetDescriptors.values().toArray(new WorkingSetDescriptor[this.workingSetDescriptors.size()]);
    }

    public WorkingSetDescriptor[] getNewPageWorkingSetDescriptors() {
        Collection descriptors = this.workingSetDescriptors.values();
        ArrayList<WorkingSetDescriptor> result = new ArrayList<WorkingSetDescriptor>(descriptors.size());
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            WorkingSetDescriptor descriptor = (WorkingSetDescriptor)iter.next();
            if (descriptor.getPageClassName() == null) continue;
            result.add(descriptor);
        }
        return result.toArray(new WorkingSetDescriptor[result.size()]);
    }

    public boolean hasNewPageWorkingSetDescriptor() {
        Collection descriptors = this.workingSetDescriptors.values();
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            WorkingSetDescriptor descriptor = (WorkingSetDescriptor)iter.next();
            if (descriptor.getPageClassName() == null) continue;
            return true;
        }
        return false;
    }

    public WorkingSetDescriptor[] getDescriptorsForNamespace(String namespace) {
        Collection descriptors = this.workingSetDescriptors.values();
        ArrayList<WorkingSetDescriptor> result = new ArrayList<WorkingSetDescriptor>();
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            WorkingSetDescriptor descriptor = (WorkingSetDescriptor)iter.next();
            if (!namespace.equals(descriptor.getDeclaringNamespace())) continue;
            result.add(descriptor);
        }
        return result.toArray(new WorkingSetDescriptor[result.size()]);
    }

    public IWorkingSetPage getWorkingSetPage(String pageId) {
        WorkingSetDescriptor descriptor = (WorkingSetDescriptor)this.workingSetDescriptors.get(pageId);
        if (descriptor == null) {
            return null;
        }
        return descriptor.createWorkingSetPage();
    }

    public void load() {
        WorkingSetRegistryReader reader = new WorkingSetRegistryReader();
        reader.readWorkingSets(Platform.getExtensionRegistry(), this);
    }

    public void removeWorkingSetDescriptor(String id) {
        this.workingSetDescriptors.remove(id);
    }
}

