/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.presentations;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.IDynamicPropertyMap;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultMultiTabListener;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultSimpleTabListener;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabFolder;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabPositionListener;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultThemeListener;
import org.eclipse.ui.internal.presentations.defaultpresentation.EmptyTabFolder;
import org.eclipse.ui.internal.presentations.newapi.ISystemMenu;
import org.eclipse.ui.internal.presentations.newapi.PresentablePartFolder;
import org.eclipse.ui.internal.presentations.newapi.StandardEditorSystemMenu;
import org.eclipse.ui.internal.presentations.newapi.StandardViewSystemMenu;
import org.eclipse.ui.internal.presentations.newapi.TabbedStackPresentation;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackPresentation;

public class WorkbenchPresentationFactory
extends AbstractPresentationFactory {
    public StackPresentation createEditorPresentation(Composite parent, IStackPresentationSite site) {
        int minimumCharacters;
        DefaultTabFolder folder = new DefaultTabFolder(parent, 2048, site.supportsState(0), site.supportsState(1));
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        if (store.contains("EDITOR_MINIMUM_CHARACTERS") && (minimumCharacters = store.getInt("EDITOR_MINIMUM_CHARACTERS")) >= 0) {
            folder.setMinimumCharacters(minimumCharacters);
        }
        PresentablePartFolder partFolder = new PresentablePartFolder(folder);
        TabbedStackPresentation result = new TabbedStackPresentation(site, partFolder, (ISystemMenu)new StandardEditorSystemMenu(site));
        DefaultThemeListener themeListener = new DefaultThemeListener(folder, result.getTheme());
        result.getTheme().addListener(themeListener);
        IDynamicPropertyMap workbenchPreferences = result.getPluginPreferences(WorkbenchPlugin.getDefault());
        new DefaultTabPositionListener(workbenchPreferences, "EDITOR_TAB_POSITION", folder);
        new DefaultMultiTabListener(workbenchPreferences, "SHOW_MULTIPLE_EDITOR_TABS", folder);
        new DefaultSimpleTabListener(result.getApiPreferences(), "SHOW_TRADITIONAL_STYLE_TABS", folder);
        return result;
    }

    public StackPresentation createViewPresentation(Composite parent, IStackPresentationSite site) {
        DefaultTabFolder folder = new DefaultTabFolder(parent, 2048, site.supportsState(0), site.supportsState(1));
        PresentablePartFolder partFolder = new PresentablePartFolder(folder);
        folder.setUnselectedCloseVisible(false);
        folder.setUnselectedImageVisible(false);
        TabbedStackPresentation result = new TabbedStackPresentation(site, partFolder, (ISystemMenu)new StandardViewSystemMenu(site));
        DefaultThemeListener themeListener = new DefaultThemeListener(folder, result.getTheme());
        result.getTheme().addListener(themeListener);
        new DefaultTabPositionListener(result.getPluginPreferences(WorkbenchPlugin.getDefault()), "VIEW_TAB_POSITION", folder);
        new DefaultSimpleTabListener(result.getApiPreferences(), "SHOW_TRADITIONAL_STYLE_TABS", folder);
        return result;
    }

    public StackPresentation createStandaloneViewPresentation(Composite parent, IStackPresentationSite site, boolean showTitle) {
        if (showTitle) {
            return this.createViewPresentation(parent, site);
        }
        EmptyTabFolder folder = new EmptyTabFolder(parent);
        TabbedStackPresentation presentation = new TabbedStackPresentation(site, folder, (ISystemMenu)new StandardViewSystemMenu(site));
        return presentation;
    }
}

