/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.structuremergeviewer;

import java.text.MessageFormat;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffContainer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.graphics.Image;

public class DiffNode
extends DiffContainer
implements ITypedElement,
ICompareInput {
    private ITypedElement fAncestor;
    private ITypedElement fLeft;
    private ITypedElement fRight;
    private boolean fDontExpand;
    private ListenerList fListener;
    private boolean fSwapSides;

    public DiffNode(IDiffContainer parent, int kind, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
        this(parent, kind);
        this.fAncestor = ancestor;
        this.fLeft = left;
        this.fRight = right;
    }

    public DiffNode(ITypedElement left, ITypedElement right) {
        this(null, 3, null, left, right);
    }

    public DiffNode(int kind, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
        this(null, kind, ancestor, left, right);
    }

    public DiffNode(int kind) {
        super(null, kind);
    }

    public DiffNode(IDiffContainer parent, int kind) {
        super(parent, kind);
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
        if (this.fListener == null) {
            this.fListener = new ListenerList();
        }
        this.fListener.add((Object)listener);
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
        if (this.fListener != null) {
            this.fListener.remove((Object)listener);
            if (this.fListener.isEmpty()) {
                this.fListener = null;
            }
        }
    }

    protected void fireChange() {
        if (this.fListener != null) {
            Object[] listeners = this.fListener.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ICompareInputChangeListener)listeners[i]).compareInputChanged(this);
                ++i;
            }
        }
    }

    public boolean dontExpand() {
        return this.fDontExpand;
    }

    public void setDontExpand(boolean dontExpand) {
        this.fDontExpand = dontExpand;
    }

    public ITypedElement getId() {
        if (this.fAncestor != null) {
            return this.fAncestor;
        }
        if (this.fRight != null) {
            return this.fRight;
        }
        return this.fLeft;
    }

    public String getName() {
        String s2;
        String s1;
        String right = null;
        if (this.fRight != null) {
            right = this.fRight.getName();
        }
        String left = null;
        if (this.fLeft != null) {
            left = this.fLeft.getName();
        }
        if (right == null && left == null) {
            if (this.fAncestor != null) {
                return this.fAncestor.getName();
            }
            return Utilities.getString("DiffNode.noName");
        }
        if (right == null) {
            return left;
        }
        if (left == null) {
            return right;
        }
        if (right.equals(left)) {
            return right;
        }
        if (this.fSwapSides) {
            s1 = left;
            s2 = right;
        } else {
            s1 = right;
            s2 = left;
        }
        String fmt = Utilities.getString("DiffNode.nameFormat");
        return MessageFormat.format(fmt, s1, s2);
    }

    void swapSides(boolean swap) {
        this.fSwapSides = swap;
    }

    public Image getImage() {
        ITypedElement id = this.getId();
        if (id != null) {
            return id.getImage();
        }
        return null;
    }

    public String getType() {
        ITypedElement id = this.getId();
        if (id != null) {
            return id.getType();
        }
        return "???";
    }

    public void setAncestor(ITypedElement ancestor) {
        this.fAncestor = ancestor;
    }

    public ITypedElement getAncestor() {
        return this.fAncestor;
    }

    public void setLeft(ITypedElement left) {
        this.fLeft = left;
    }

    public ITypedElement getLeft() {
        return this.fLeft;
    }

    public void setRight(ITypedElement right) {
        this.fRight = right;
    }

    public ITypedElement getRight() {
        return this.fRight;
    }

    public void copy(boolean leftToRight) {
        IDiffContainer pa = this.getParent();
        if (pa instanceof ICompareInput) {
            ITypedElement dstParent;
            ICompareInput parent = (ICompareInput)((Object)pa);
            ITypedElement iTypedElement = dstParent = leftToRight ? parent.getRight() : parent.getLeft();
            if (dstParent instanceof IEditableContent) {
                ITypedElement dst = leftToRight ? this.getRight() : this.getLeft();
                ITypedElement src = leftToRight ? this.getLeft() : this.getRight();
                dst = ((IEditableContent)((Object)dstParent)).replace(dst, src);
                if (leftToRight) {
                    this.setRight(dst);
                } else {
                    this.setLeft(dst);
                }
                this.fireChange();
            }
        }
    }

    public int hashCode() {
        String[] path = DiffNode.getPath(this, 0);
        int hashCode = 1;
        int i = 0;
        while (i < path.length) {
            String s = path[i];
            hashCode = 31 * hashCode + (s != null ? s.hashCode() : 0);
            ++i;
        }
        return hashCode;
    }

    public boolean equals(Object other) {
        if (other != null && this.getClass() == other.getClass()) {
            String[] path2;
            String[] path1 = DiffNode.getPath(this, 0);
            if (path1.length != (path2 = DiffNode.getPath((DiffNode)other, 0)).length) {
                return false;
            }
            int i = 0;
            while (i < path1.length) {
                if (!path1[i].equals(path2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equals(other);
    }

    private static String[] getPath(ITypedElement el, int level) {
        IDiffContainer parent;
        String[] path = null;
        if (el instanceof IDiffContainer && (parent = ((IDiffContainer)el).getParent()) != null) {
            path = DiffNode.getPath(parent, level + 1);
        }
        if (path == null) {
            path = new String[level + 1];
        }
        path[path.length - 1 - level] = el.getName();
        return path;
    }
}

