/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;

public class JavaElementChangeListener
implements IElementChangedListener {
    private static final String FILENAME = "clean-cache.properties";
    private Properties fTable = new Properties();

    public JavaElementChangeListener() {
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
        this.load();
    }

    public void elementChanged(ElementChangedEvent event) {
        this.handleDelta(event.getDelta());
    }

    public void shutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this.save();
    }

    private void handleDelta(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (element instanceof IJavaModel) {
            this.handleChildDeltas(delta);
        } else if (element instanceof IJavaProject) {
            if (this.isInterestingProject((IJavaProject)element)) {
                if (delta.getKind() == 4) {
                    this.handleChildDeltas(delta);
                } else if (delta.getKind() == 1) {
                    this.updateTable(element);
                }
            }
        } else if (element instanceof IPackageFragmentRoot) {
            this.handleChildDeltas(delta);
        }
    }

    private void handleChildDeltas(IJavaElementDelta delta) {
        IJavaElementDelta[] deltas = delta.getAffectedChildren();
        int i = 0;
        while (i < deltas.length) {
            if (!this.ignoreDelta(deltas[i])) {
                if (this.isInterestingDelta(deltas[i])) {
                    this.updateTable(deltas[i].getElement());
                    break;
                }
                this.handleDelta(deltas[i]);
            }
            ++i;
        }
    }

    private boolean isInterestingDelta(IJavaElementDelta delta) {
        boolean interestingElement;
        int kind = delta.getKind();
        boolean interestingKind = kind == 1 || kind == 2;
        IJavaElement element = delta.getElement();
        boolean bl = interestingElement = element instanceof IPackageFragment || element instanceof IPackageFragmentRoot;
        return interestingElement && interestingKind;
    }

    private boolean ignoreDelta(IJavaElementDelta delta) {
        try {
            IPackageFragmentRoot root;
            IClasspathEntry entry;
            IJavaElement element = delta.getElement();
            if (element instanceof IPackageFragmentRoot && (entry = (root = (IPackageFragmentRoot)element).getRawClasspathEntry()) != null && entry.getEntryKind() == 5) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private boolean isInterestingProject(IJavaProject jProject) {
        IProject project = jProject.getProject();
        return WorkspaceModelManager.isNonBinaryPluginProject(project) && !WorkspaceModelManager.hasBundleManifest(project);
    }

    private void updateTable(IJavaElement element) {
        IJavaProject jProject = (IJavaProject)element.getAncestor(2);
        if (jProject != null) {
            IProject project = jProject.getProject();
            ModelEntry entry = PDECore.getDefault().getModelManager().findEntry(project);
            if (entry != null) {
                IPluginModelBase model = entry.getActiveModel();
                String id = model.getPluginBase().getId();
                if (id == null) {
                    return;
                }
                this.fTable.put(id, Long.toString(System.currentTimeMillis()));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void save() {
        PluginModelManager mgr = PDECore.getDefault().getModelManager();
        Enumeration<Object> keys = this.fTable.keys();
        while (keys.hasMoreElements()) {
            String id = keys.nextElement().toString();
            IPluginModelBase model = mgr.findModel(id);
            if (model != null && model.getUnderlyingResource() != null) continue;
            this.fTable.remove(id);
        }
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(new File(this.getDirectory(), FILENAME));
                this.fTable.store(stream, "Cached timestamps");
                stream.flush();
            }
            catch (IOException e) {
                PDECore.logException(e);
            }
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (stream == null) return;
        stream.close();
    }

    private File getDirectory() {
        IPath path = PDECore.getDefault().getStateLocation().append(".cache");
        File directory = new File(path.toOSString());
        if (!directory.exists() || !directory.isDirectory()) {
            directory.mkdirs();
        }
        return directory;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load() {
        FileInputStream is = null;
        try {
            try {
                File file = new File(this.getDirectory(), FILENAME);
                if (file.exists() && file.isFile()) {
                    is = new FileInputStream(file);
                    this.fTable.load(is);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (is == null) return;
        is.close();
    }

    public void synchronizeManifests(File cacheDirectory) {
        Enumeration<Object> keys = this.fTable.keys();
        while (keys.hasMoreElements()) {
            File file;
            String id = keys.nextElement().toString();
            IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(id);
            if (model == null || !(file = new File(cacheDirectory, String.valueOf(id) + "_" + model.getPluginBase().getVersion() + ".MF")).exists() || !file.isFile() || file.lastModified() >= Long.parseLong(this.fTable.get(id).toString())) continue;
            file.delete();
        }
    }
}

