/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;

public class JavadocLocationManager {
    private static String JAVADOC_ID = "org.eclipse.pde.core.javadoc";
    private HashMap fLocations;

    public URL getJavadocLocation(IPluginModelBase model) {
        String id;
        URL url = model.getResourceURL("doc");
        if (url == null && (id = model.getPluginBase().getId()) != null) {
            url = (URL)this.getLocations().get(id);
        }
        return url;
    }

    private void processExtensions(ModelEntry entry, boolean useExternal) {
        IPluginModelBase model;
        IPluginModelBase iPluginModelBase = model = useExternal ? entry.getExternalModel() : entry.getActiveModel();
        if (model == null) {
            return;
        }
        IPluginExtension[] extensions = model.getPluginBase().getExtensions();
        int j = 0;
        while (j < extensions.length) {
            IPluginExtension extension = extensions[j];
            if (JAVADOC_ID.equals(extension.getPoint())) {
                int origLength = this.fLocations.size();
                this.processExtension(extension);
                if (this.fLocations.size() == origLength && model.getUnderlyingResource() != null) {
                    this.processExtensions(entry, true);
                }
            }
            ++j;
        }
    }

    private void processExtension(IPluginExtension extension) {
        IPluginObject[] children = extension.getChildren();
        int j = 0;
        while (j < children.length) {
            if (children[j].getName().equals("javadoc")) {
                ISharedPluginModel model;
                URL url;
                IPluginElement element = (IPluginElement)children[j];
                String pluginID = this.getAttribute(element, "plugin");
                String path = this.getAttribute(element, "path");
                if (pluginID != null && path != null && (url = (model = extension.getModel()).getResourceURL(path)) != null) {
                    this.getLocations().put(pluginID, url);
                }
            }
            ++j;
        }
    }

    private String getAttribute(IPluginElement element, String attrName) {
        IPluginAttribute attr = element.getAttribute(attrName);
        return attr == null ? null : attr.getValue();
    }

    public void reset() {
        this.fLocations = null;
    }

    private synchronized Map getLocations() {
        this.initialize();
        return this.fLocations;
    }

    private void initialize() {
        if (this.fLocations == null) {
            return;
        }
        ModelEntry[] entries = PDECore.getDefault().getModelManager().getEntries();
        int i = 0;
        while (i < entries.length) {
            this.processExtensions(entries[i], false);
            ++i;
        }
    }
}

