/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.build.ExternalBuildModel;
import org.eclipse.pde.internal.core.plugin.AbstractPluginModelBase;
import org.eclipse.pde.internal.core.plugin.PluginBase;

public abstract class ExternalPluginModelBase
extends AbstractPluginModelBase {
    private String installLocation;
    private transient IBuildModel buildModel;

    protected NLResourceHelper createNLResourceHelper() {
        return new NLResourceHelper("plugin", this.getNLLookupLocations());
    }

    public URL getNLLookupLocation() {
        try {
            return new URL("file:" + this.getInstallLocation());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public IBuildModel getBuildModel() {
        if (this.buildModel == null) {
            this.buildModel = new ExternalBuildModel(this.getInstallLocation());
            ((ExternalBuildModel)this.buildModel).load();
        }
        return this.buildModel;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public boolean isEditable() {
        return false;
    }

    public void load() {
    }

    public void load(BundleDescription description, PDEState state, boolean ignoreExtensions) {
        Path path = new Path(description.getLocation());
        String device = path.getDevice();
        if (device != null) {
            path = path.setDevice(device.toUpperCase());
        }
        this.setInstallLocation(path.toOSString());
        this.setBundleDescription(description);
        ((PluginBase)this.getPluginBase()).load(description, state, ignoreExtensions);
        this.updateTimeStamp();
        this.loaded = true;
    }

    public boolean isInSync() {
        return this.isInSync(this.getLocalFile());
    }

    private File getLocalFile() {
        File file = new File(this.getInstallLocation());
        if (file.isFile() && new Path(file.getAbsolutePath()).getFileExtension().equals("jar")) {
            return file;
        }
        if (!(file = new File(file, "META-INF/MANIFEST.MF")).exists()) {
            String manifest = this.isFragmentModel() ? "fragment.xml" : "plugin.xml";
            file = new File(this.getInstallLocation(), manifest);
        }
        return file;
    }

    protected void updateTimeStamp() {
        this.updateTimeStamp(this.getLocalFile());
    }

    public void setInstallLocation(String newInstallLocation) {
        this.installLocation = newInstallLocation;
        File file = new File(newInstallLocation);
        if (file.isDirectory()) {
            this.installLocation = String.valueOf(this.installLocation) + File.separator;
        }
    }
}

