/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.Serializable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;

public abstract class SchemaObject
extends PlatformObject
implements ISchemaObject,
Serializable {
    protected String fName;
    private String fDescription;
    private transient ISchemaObject fParent;

    public SchemaObject(ISchemaObject parent, String name) {
        this.fParent = parent;
        this.fName = name;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getName() {
        return this.fName;
    }

    public ISchemaObject getParent() {
        return this.fParent;
    }

    public void setParent(ISchemaObject parent) {
        this.fParent = parent;
    }

    public ISchema getSchema() {
        ISchemaObject object = this;
        while (object.getParent() != null) {
            object = object.getParent();
        }
        return (ISchema)object;
    }

    public String getWritableDescription() {
        return SchemaObject.getWritableDescription(this.getDescription());
    }

    public static String getWritableDescription(String input) {
        if (input == null) {
            return "";
        }
        String result = input.trim();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < result.length()) {
            char c = result.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public void setDescription(String newDescription) {
        String oldValue = this.fDescription;
        this.fDescription = newDescription;
        this.getSchema().fireModelObjectChanged(this, "description", oldValue, this.fDescription);
    }

    public void setName(String newName) {
        String oldValue = this.fName;
        this.fName = newName;
        this.getSchema().fireModelObjectChanged(this, "name", oldValue, this.fName);
    }

    public String toString() {
        if (this.fName != null) {
            return this.fName;
        }
        return super.toString();
    }
}

