/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.schema.IncludedSchemaDescriptor;
import org.eclipse.pde.internal.core.schema.SchemaDescriptor;

public class SchemaRegistry {
    private HashMap fRegistry = new HashMap();

    public ISchema getSchema(String extPointID) {
        IPluginExtensionPoint point = PDECore.getDefault().findExtensionPoint(extPointID);
        if (point == null) {
            if (this.fRegistry.containsKey(extPointID)) {
                this.fRegistry.remove(extPointID);
            }
            return null;
        }
        URL url = SchemaRegistry.getSchemaURL(point);
        if (url == null) {
            return null;
        }
        ISchemaDescriptor desc = this.getExistingDescriptor(extPointID, url);
        if (desc == null) {
            desc = new SchemaDescriptor(extPointID, url);
            this.fRegistry.put(extPointID, desc);
        }
        return desc == null ? null : desc.getSchema(true);
    }

    public ISchema getIncludedSchema(ISchemaDescriptor parent, String schemaLocation) {
        try {
            URL url = IncludedSchemaDescriptor.computeURL(parent, schemaLocation);
            if (url == null) {
                return null;
            }
            ISchemaDescriptor desc = this.getExistingDescriptor(url.toString(), url);
            if (desc == null) {
                desc = new IncludedSchemaDescriptor(url);
                this.fRegistry.put(url.toString(), desc);
            }
            return desc.getSchema(true);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private ISchemaDescriptor getExistingDescriptor(String key, URL url) {
        ISchemaDescriptor desc = null;
        if (this.fRegistry.containsKey(key) && this.hasSchemaChanged(desc = (ISchemaDescriptor)this.fRegistry.get(key), url)) {
            desc = null;
        }
        return desc;
    }

    public static URL getSchemaURL(IPluginExtensionPoint point) {
        String schema = point.getSchema();
        if (schema == null || schema.trim().length() == 0) {
            return null;
        }
        URL url = point.getModel().getResourceURL(schema);
        if (url == null && point.getModel().getUnderlyingResource() != null) {
            IPluginModelBase model;
            String pluginID = point.getPluginBase().getId();
            ModelEntry entry = PDECore.getDefault().getModelManager().findEntry(pluginID);
            if (entry != null && (model = entry.getExternalModel()) != null) {
                url = model.getResourceURL(schema);
            }
        }
        if (url == null) {
            try {
                SourceLocationManager mgr = PDECore.getDefault().getSourceLocationManager();
                File file = mgr.findSourceFile(point.getPluginBase(), (IPath)new Path(schema));
                if (file != null && file.exists()) {
                    url = file.toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return url;
    }

    private boolean hasSchemaChanged(ISchemaDescriptor desc, URL url) {
        if (!desc.getSchemaURL().equals(url)) {
            return true;
        }
        File file = new File(url.getFile());
        return desc.getLastModified() != file.lastModified();
    }

    public void shutdown() {
        this.fRegistry.clear();
    }
}

