/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.packager;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.build.AssembleConfigScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.ant.TarFileSet;
import org.eclipse.pde.internal.build.ant.ZipFileSet;

public class PackagingConfigScriptGenerator
extends AssembleConfigScriptGenerator {
    private Properties packagingProperties;
    private String[] rootFiles;
    private String[] rootDirs;
    private String output;

    public void generate() throws CoreException {
        this.generatePrologue();
        this.generateMainTarget();
        this.generateAssembleTarget();
        this.generateEpilogue();
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration("Package " + this.featureId, "main", null);
        this.script.printProperty("archiveName", this.computeArchiveName());
    }

    private void generateMainTarget() {
        this.script.printTargetDeclaration("main", null, null, null, null);
        if (BundleHelper.getDefault().isDebugging()) {
            this.script.printEchoTask("basedir: " + this.getPropertyFormat("basedir"));
            this.script.printEchoTask("tmpDir: " + this.getPropertyFormat("tempDirectory"));
            this.script.printEchoTask("collectingFolder: " + this.getPropertyFormat("collectingFolder"));
            this.script.printEchoTask("archivePrefix: " + this.getPropertyFormat("archivePrefix"));
            this.script.printEchoTask("eclipse.base: " + this.getPropertyFormat("eclipse.base"));
            this.script.printEchoTask("assemblyTempDir: " + this.getPropertyFormat("assemblyTempDir"));
            this.script.printEchoTask("destination.temp.folder: " + this.getPropertyFormat("destination.temp.folder"));
        }
        this.script.println("<condition property=\"pluginArchivePrefix\" value=\"plugins\">");
        this.script.println("\t<equals arg1=\"" + this.getPropertyFormat("archivePrefix") + "\"  arg2=\"\" trim=\"true\"/>");
        this.script.println("</condition>");
        this.script.printProperty("pluginArchivePrefix", String.valueOf(this.getPropertyFormat("archivePrefix")) + '/' + "plugins");
        this.script.println();
        this.script.println("<condition property=\"featureArchivePrefix\" value=\"features\">");
        this.script.println("\t<equals arg1=\"" + this.getPropertyFormat("archivePrefix") + "\"  arg2=\"\" trim=\"true\"/>");
        this.script.println("</condition>");
        this.script.printProperty("featureArchivePrefix", String.valueOf(this.getPropertyFormat("archivePrefix")) + '/' + "features");
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("assembleScriptName", this.filename);
        this.script.printAntTask(this.getPropertyFormat("customTargets"), null, "assemble." + this.configInfo.toStringReplacingAny(".", "ANY") + ".xml", null, null, parameters);
        this.script.printTargetEnd();
    }

    private void generateAssembleTarget() {
        this.script.printTargetDeclaration("assemble", null, null, null, null);
        if (this.output.equalsIgnoreCase("tarGz")) {
            this.generateAntTarTarget();
        } else if (this.output.equalsIgnoreCase("antZip")) {
            this.generateAntZipTarget();
        } else if (this.output.equalsIgnoreCase("folder")) {
            this.generateFolderTarget();
        } else {
            this.generateZipRootFiles();
            this.generateZip();
            ArrayList<String> args = new ArrayList<String>(2);
            args.add("-R");
            args.add("700");
            args.add(".");
            this.script.printExecTask("chmod", String.valueOf(this.getPropertyFormat("tempDirectory")) + '/' + this.getPropertyFormat("collectingFolder"), args, "Linux");
            this.script.printDeleteTask(String.valueOf(this.getPropertyFormat("tempDirectory")) + '/' + this.getPropertyFormat("collectingFolder"), "**/*", null);
        }
        this.script.printTargetEnd();
    }

    private void generateZipRootFiles() {
        String fileList = this.packagingProperties.getProperty("root", "");
        if (!this.configInfo.equals(Config.genericConfig())) {
            fileList = String.valueOf(fileList) + (fileList.length() == 0 ? "" : ",") + this.packagingProperties.getProperty("root." + this.configInfo.toString("."), "");
        }
        String[] files = Utils.getArrayFromString(fileList, ",");
        ArrayList<String> parameters = new ArrayList<String>(1);
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            if (file.startsWith("file:")) {
                Path target = new Path(file.substring(5));
                file = target.removeLastSegments(1).toOSString();
            }
            parameters.add(String.valueOf(this.getPropertyFormat("archivePrefix")) + '/' + file);
            this.createZipExecCommand(parameters);
            parameters.clear();
            ++i;
        }
    }

    private void generateZip() {
        ArrayList<String> parameters = new ArrayList<String>(16);
        int i = 0;
        while (i < this.plugins.length) {
            parameters.add(String.valueOf(this.getPropertyFormat("pluginArchivePrefix")) + '/' + this.plugins[i].getSymbolicName() + "_" + this.plugins[i].getVersion());
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        i = 0;
        while (i < this.features.length) {
            parameters.add(String.valueOf(this.getPropertyFormat("featureArchivePrefix")) + '/' + this.features[i].getVersionedIdentifier().toString());
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
    }

    private void createZipExecCommand(List parameters) {
        parameters.add(0, "-r -q " + this.getPropertyFormat("zipargs") + " " + this.getPropertyFormat("archiveName"));
        this.script.printExecTask("zip", this.getPropertyFormat("tempDirectory"), parameters, null);
    }

    private void generateEpilogue() {
        this.script.printProjectEnd();
        this.script.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPackagingPropertiesLocation(String packagingPropertiesLocation) throws CoreException {
        this.packagingProperties = new Properties();
        if (packagingPropertiesLocation == null) return;
        if (packagingPropertiesLocation.equals("")) {
            return;
        }
        BufferedInputStream propertyStream = null;
        try {
            propertyStream = new BufferedInputStream(new FileInputStream(packagingPropertiesLocation));
            try {
                this.packagingProperties.load(new BufferedInputStream(propertyStream));
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                ((InputStream)propertyStream).close();
                throw throwable;
            }
            {
                Object var3_7 = null;
                ((InputStream)propertyStream).close();
                return;
            }
        }
        catch (FileNotFoundException e) {
            String message = Policy.bind("exception.readingFile", packagingPropertiesLocation);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
        catch (IOException e) {
            String message = Policy.bind("exception.readingFile", packagingPropertiesLocation);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e));
        }
    }

    private boolean isFolder(Path pluginLocation) {
        return pluginLocation.toFile().isDirectory();
    }

    private void generateAntTarTarget() {
        int index = 0;
        FileSet[] files = new FileSet[this.plugins.length + this.features.length + this.rootFiles.length + this.rootDirs.length];
        if (files.length == 0) {
            return;
        }
        int i = 0;
        while (i < this.plugins.length) {
            Path pluginLocation = new Path(this.plugins[i].getLocation());
            boolean isFolder = this.isFolder(pluginLocation);
            files[index++] = new TarFileSet(pluginLocation.toOSString(), !isFolder, null, null, null, null, null, String.valueOf(this.getPropertyFormat("pluginArchivePrefix")) + '/' + pluginLocation.lastSegment(), null);
            ++i;
        }
        i = 0;
        while (i < this.features.length) {
            Path featureLocation = new Path(this.features[i].getURL().getPath());
            featureLocation = featureLocation.removeLastSegments(1);
            files[index++] = new TarFileSet(featureLocation.toOSString(), false, null, null, null, null, null, String.valueOf(this.getPropertyFormat("featureArchivePrefix")) + '/' + featureLocation.lastSegment(), null);
            ++i;
        }
        if (this.rootFileProviders.size() == 0) {
            FileSet[] filesCorrectSize = new FileSet[this.plugins.length + this.features.length];
            System.arraycopy(files, 0, filesCorrectSize, 0, this.plugins.length + this.features.length);
            this.script.printTarTask(this.getPropertyFormat("archiveFullPath"), null, false, true, files);
            return;
        }
        i = 0;
        while (i < this.rootFiles.length) {
            Path filePath = new Path(this.rootFiles[i]);
            files[index++] = new TarFileSet(filePath.toOSString(), true, null, null, null, null, null, String.valueOf(this.getPropertyFormat("archivePrefix")) + '/' + filePath.lastSegment(), null);
            ++i;
        }
        i = 0;
        while (i < this.rootDirs.length) {
            Path dirPath = new Path(this.rootDirs[i]);
            files[index++] = new TarFileSet(dirPath.toOSString(), false, null, null, null, null, null, String.valueOf(this.getPropertyFormat("archivePrefix")) + '/' + dirPath.lastSegment(), null);
            ++i;
        }
        this.script.printTarTask(this.getPropertyFormat("archiveFullPath"), null, false, true, files);
    }

    private void generateAntZipTarget() {
        int index = 0;
        FileSet[] files = new FileSet[this.plugins.length + this.features.length + this.rootFiles.length + this.rootDirs.length];
        if (files.length == 0) {
            return;
        }
        int i = 0;
        while (i < this.plugins.length) {
            Path pluginLocation = new Path(this.plugins[i].getLocation());
            boolean isFolder = this.isFolder(pluginLocation);
            files[index++] = new ZipFileSet(pluginLocation.toOSString(), !isFolder, null, null, null, null, null, String.valueOf(this.getPropertyFormat("pluginArchivePrefix")) + '/' + pluginLocation.lastSegment(), null);
            ++i;
        }
        i = 0;
        while (i < this.features.length) {
            Path featureLocation = new Path(this.features[i].getURL().getPath());
            featureLocation = featureLocation.removeLastSegments(1);
            files[index++] = new ZipFileSet(featureLocation.toOSString(), false, null, null, null, null, null, String.valueOf(this.getPropertyFormat("featureArchivePrefix")) + '/' + featureLocation.lastSegment(), null);
            ++i;
        }
        if (this.rootFileProviders.size() == 0) {
            FileSet[] filesCorrectSize = new FileSet[this.plugins.length + this.features.length];
            System.arraycopy(files, 0, filesCorrectSize, 0, this.plugins.length + this.features.length);
            this.script.printZipTask(this.getPropertyFormat("archiveFullPath"), null, false, true, files);
            return;
        }
        i = 0;
        while (i < this.rootFiles.length) {
            Path filePath = new Path(this.rootFiles[i]);
            files[index++] = new ZipFileSet(filePath.toOSString(), true, null, null, null, null, null, String.valueOf(this.getPropertyFormat("archivePrefix")) + '/' + filePath.lastSegment(), null);
            ++i;
        }
        i = 0;
        while (i < this.rootDirs.length) {
            Path dirPath = new Path(this.rootDirs[i]);
            files[index++] = new ZipFileSet(dirPath.toOSString(), false, null, null, null, null, null, String.valueOf(this.getPropertyFormat("archivePrefix")) + '/' + dirPath.lastSegment(), null);
            ++i;
        }
        this.script.printZipTask(this.getPropertyFormat("archiveFullPath"), null, false, true, files);
    }

    private void generateFolderTarget() {
        int i = 0;
        while (i < this.plugins.length) {
            Path pluginLocation = new Path(this.plugins[i].getLocation());
            boolean isFolder = this.isFolder(pluginLocation);
            if (isFolder) {
                this.script.printCopyTask(null, String.valueOf(this.getPropertyFormat("assemblyTempDir")) + '/' + this.getPropertyFormat("pluginArchivePrefix") + '/' + pluginLocation.lastSegment(), new FileSet[]{new FileSet(pluginLocation.toOSString(), null, null, null, null, null, null)}, false);
            } else {
                this.script.printCopyTask(pluginLocation.toOSString(), String.valueOf(this.getPropertyFormat("assemblyTempDir")) + '/' + this.getPropertyFormat("pluginArchivePrefix") + '/' + pluginLocation.lastSegment(), null, false);
            }
            ++i;
        }
        i = 0;
        while (i < this.features.length) {
            Path featureLocation = new Path(this.features[i].getURL().getPath());
            featureLocation = featureLocation.removeLastSegments(1);
            this.script.printCopyTask(null, String.valueOf(this.getPropertyFormat("assemblyTempDir")) + '/' + this.getPropertyFormat("featureArchivePrefix") + '/' + featureLocation.lastSegment(), new FileSet[]{new FileSet(featureLocation.toOSString(), null, null, null, null, null, null)}, false);
            ++i;
        }
        i = 0;
        while (i < this.rootFiles.length) {
            Path filePath = new Path(this.rootFiles[i]);
            this.script.printCopyTask(filePath.toOSString(), String.valueOf(this.getPropertyFormat("assemblyTempDir")) + '/' + this.getPropertyFormat("archivePrefix"), null, false);
            ++i;
        }
        i = 0;
        while (i < this.rootDirs.length) {
            Path dirPath = new Path(this.rootDirs[i]);
            this.script.printCopyTask(null, String.valueOf(this.getPropertyFormat("assemblyTempDir")) + '/' + this.getPropertyFormat("archivePrefix") + '/' + dirPath.lastSegment(), new FileSet[]{new FileSet(dirPath.toOSString(), null, null, null, null, null, null)}, false);
            ++i;
        }
    }

    public void rootFiles(String[] root) {
        this.rootFiles = root;
    }

    public void rootDirs(String[] root) {
        this.rootDirs = root;
    }

    public void setOutput(String outputFormat) {
        this.output = outputFormat;
    }
}

