/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class GotoLineAction
extends TextEditorAction {
    private int fLastLine;
    private ResourceBundle fBundle;
    private String fPrefix;

    public GotoLineAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.fBundle = bundle;
        this.fPrefix = prefix;
    }

    private void gotoLine(int line) {
        ITextEditor editor = this.getTextEditor();
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument(editor.getEditorInput());
        try {
            int start = document.getLineOffset(line);
            editor.selectAndReveal(start, 0);
            IWorkbenchPage page = editor.getSite().getPage();
            page.activate((IWorkbenchPart)editor);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void run() {
        try {
            ITextEditor editor = this.getTextEditor();
            if (editor == null) {
                return;
            }
            IDocumentProvider docProvider = editor.getDocumentProvider();
            if (docProvider == null) {
                return;
            }
            IDocument document = docProvider.getDocument(editor.getEditorInput());
            if (document == null) {
                return;
            }
            this.fLastLine = document.getLineOfOffset(document.getLength()) + 1;
            String title = this.fBundle.getString(String.valueOf(this.fPrefix) + "dialog.title");
            String message = MessageFormat.format(this.fBundle.getString(String.valueOf(this.fPrefix) + "dialog.message"), new Integer(this.fLastLine));
            GotoLineDialog d = new GotoLineDialog(editor.getSite().getShell(), title, message, "", new NumberValidator());
            if (d.open() == 0) {
                try {
                    int line = Integer.parseInt(d.getValue());
                    this.gotoLine(line - 1);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    class NumberValidator
    implements IInputValidator {
        NumberValidator() {
        }

        public String isValid(String input) {
            if (input == null || input.length() == 0) {
                return " ";
            }
            try {
                int i = Integer.parseInt(input);
                if (i <= 0 || GotoLineAction.this.fLastLine < i) {
                    return GotoLineAction.this.fBundle.getString(String.valueOf(GotoLineAction.this.fPrefix) + "dialog.invalid_range");
                }
            }
            catch (NumberFormatException numberFormatException) {
                return GotoLineAction.this.fBundle.getString(String.valueOf(GotoLineAction.this.fPrefix) + "dialog.invalid_input");
            }
            return null;
        }
    }

    static class GotoLineDialog
    extends InputDialog {
        public GotoLineDialog(Shell parent, String title, String message, String initialValue, IInputValidator validator) {
            super(parent, title, message, initialValue, validator);
        }

        protected Control createDialogArea(Composite parent) {
            Control result = super.createDialogArea(parent);
            this.getText().setFocus();
            Dialog.applyDialogFont((Control)result);
            return result;
        }
    }
}

