/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import java.util.ArrayList;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.EventThread;
import org.eclipse.osgi.framework.eventmgr.ListElement;

public class ListenerQueue {
    protected final EventManager manager;
    private final ArrayList queue;
    private boolean readOnly;

    public ListenerQueue(EventManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException();
        }
        this.manager = manager;
        this.queue = new ArrayList();
        this.readOnly = false;
    }

    public synchronized void queueListeners(EventListeners listeners, EventDispatcher dispatcher) {
        ListElement[] list;
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (listeners != null && (list = listeners.getListeners()).length > 0) {
            this.queue.add(new ListElement(list, dispatcher));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEventAsynchronous(int eventAction, Object eventObject) {
        EventThread eventThread;
        ListenerQueue listenerQueue = this;
        synchronized (listenerQueue) {
            this.readOnly = true;
        }
        EventThread eventThread2 = eventThread = this.manager.getEventThread();
        synchronized (eventThread2) {
            int size = this.queue.size();
            int i = 0;
            while (i < size) {
                ListElement list = (ListElement)this.queue.get(i);
                eventThread.postEvent((ListElement[])list.primary, (EventDispatcher)list.companion, eventAction, eventObject);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEventSynchronous(int eventAction, Object eventObject) {
        ListenerQueue listenerQueue = this;
        synchronized (listenerQueue) {
            this.readOnly = true;
        }
        int size = this.queue.size();
        int i = 0;
        while (i < size) {
            ListElement list = (ListElement)this.queue.get(i);
            EventManager.dispatchEvent((ListElement[])list.primary, (EventDispatcher)list.companion, eventAction, eventObject);
            ++i;
        }
    }
}

