/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleFragment
extends AbstractBundle {
    protected BundleHost host = null;

    public BundleFragment(BundleData bundledata, Framework framework) throws BundleException {
        super(bundledata, framework);
    }

    protected void load() throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.load called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.framework.isActive()) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                PermissionCollection collection = this.framework.permissionAdmin.createPermissionCollection(this);
                this.domain = new ProtectionDomain(null, collection);
            }
            try {
                this.bundledata.open();
            }
            catch (IOException e) {
                throw new BundleException(Msg.formatter.getString("BUNDLE_READ_EXCEPTION"), (Throwable)e);
            }
        }
    }

    protected boolean unresolve() {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.framework.isActive()) {
            if (this.host != null && this.state == 4) {
                this.state = 2;
                this.host = null;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    protected boolean reload(AbstractBundle newBundle) throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive() && this.host != null && this.state == 4) {
            exporting = this.host.unresolve();
        }
        if (!exporting) {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        this.bundledata = newBundle.bundledata;
        this.bundledata.setBundle(this);
        return exporting;
    }

    protected void refresh() throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.refresh called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 4) {
            this.host = null;
            this.state = 2;
        }
        this.manifestLocalization = null;
    }

    protected boolean unload() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.unload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive()) {
            if (this.host != null) {
                BundleHost resumeHost = this.host;
                if (this.state == 4) {
                    try {
                        exporting = this.host.unresolve();
                    }
                    catch (BundleException be) {
                        this.framework.publishFrameworkEvent(2, this, be);
                    }
                }
                if (!exporting) {
                    this.domain = null;
                    try {
                        this.bundledata.close();
                    }
                    catch (IOException iOException) {}
                }
                this.framework.resumeBundle(resumeHost);
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return exporting;
    }

    protected Class loadClass(String name, boolean checkPermission) throws ClassNotFoundException {
        if (checkPermission) {
            this.framework.checkAdminPermission();
            this.checkValid();
        }
        throw new ClassNotFoundException(Msg.formatter.getString("BUNDLE_FRAGMENT_CNFE", name));
    }

    public URL getResource(String name) {
        this.checkValid();
        return null;
    }

    protected void startWorker(boolean persistent) throws BundleException {
        if (this.framework.active) {
            if ((this.state & 0x28) != 0) {
                return;
            }
            if (this.state == 2) {
                this.framework.packageAdmin.resolveBundles();
                if (this.state != 4) {
                    throw new BundleException(this.getResolutionFailureMessage());
                }
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle: Active sl = " + this.framework.startLevelManager.getStartLevel() + "; Bundle " + this.getBundleId() + " sl = " + this.getStartLevel());
            }
            if (this.getStartLevel() <= this.framework.startLevelManager.getStartLevel()) {
                if (this.state == 1) {
                    throw new BundleException(Msg.formatter.getString("BUNDLE_UNINSTALLED_EXCEPTION"));
                }
                if (this.framework.active) {
                    this.state = 32;
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println("->started " + this);
                    }
                    this.framework.publishBundleEvent(2, this);
                }
            }
        }
        if (persistent) {
            this.setStatus(1, true);
        }
    }

    protected void stopWorker(boolean persistent) throws BundleException {
        if (persistent) {
            this.setStatus(1, false);
        }
        if (this.framework.active) {
            if ((this.state & 0x16) != 0) {
                return;
            }
            this.state = 4;
            if (Debug.DEBUG_GENERAL) {
                Debug.println("->stopped " + this);
            }
            this.framework.publishBundleEvent(4, this);
        }
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkValid();
        return null;
    }

    public ServiceReference[] getServicesInUse() {
        this.checkValid();
        return null;
    }

    public Bundle getHost() {
        return this.host;
    }

    public boolean isFragment() {
        return true;
    }

    protected boolean setHost(BundleHost value) {
        this.host = value;
        if (this.host != null) {
            try {
                this.host.attachFragment(this);
            }
            catch (BundleException be) {
                this.framework.publishFrameworkEvent(2, this.host, be);
                return false;
            }
        }
        return true;
    }

    public BundleLoader getBundleLoader() {
        return null;
    }

    protected BundleContextImpl getContext() {
        return null;
    }
}

