/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.util.SecureAction;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleHost
extends AbstractBundle {
    protected BundleLoader loader = null;
    private BundleLoaderProxy proxy;
    protected BundleContextImpl context = null;
    protected BundleFragment[] fragments = null;

    public BundleHost(BundleData bundledata, Framework framework) throws BundleException {
        super(bundledata, framework);
    }

    protected void load() throws BundleException {
        SecurityManager sm;
        if (Debug.DEBUG_GENERAL) {
            if ((this.state & 2) == 0) {
                Debug.println("Bundle.load called when state != INSTALLED: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            if (this.loader != null) {
                Debug.println("Bundle.load called when loader != null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
        }
        if (this.framework.isActive() && (sm = System.getSecurityManager()) != null) {
            PermissionCollection collection = this.framework.permissionAdmin.createPermissionCollection(this);
            this.domain = new ProtectionDomain(null, collection);
        }
        this.loader = null;
    }

    protected boolean unresolve() throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive()) {
            if (this.state == 4) {
                BundleLoaderProxy curProxy;
                if (this.isActive()) {
                    boolean suspended = this.framework.suspendBundle(this, true);
                    if (!suspended) {
                        throw new BundleException(Msg.formatter.getString("BUNDLE_STATE_CHANGE_EXCEPTION"));
                    }
                } else {
                    this.beginStateChange();
                }
                if (exporting = (curProxy = this.getLoaderProxy()).inUse()) {
                    curProxy.getBundleLoader();
                    this.framework.packageAdmin.addRemovalPending(curProxy);
                } else {
                    this.framework.packageAdmin.unexportResources(curProxy);
                    if (this.loader != null) {
                        this.loader.clear();
                        this.loader.close();
                    }
                    this.framework.bundles.unMarkDependancies(curProxy);
                }
                this.unresolveFragments();
                this.loader = null;
                this.fragments = null;
                this.proxy = null;
                this.state = 2;
                this.framework.publishBundleEvent(64, this);
                this.completeStateChange();
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return exporting;
    }

    protected boolean reload(AbstractBundle newBundle) throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 6) == 0) {
            Debug.println("Bundle.reload called when state != INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive()) {
            if (this.state == 4) {
                BundleLoaderProxy curProxy = this.getLoaderProxy();
                exporting = curProxy.inUse();
                if (exporting) {
                    curProxy.getBundleLoader();
                    this.framework.packageAdmin.addRemovalPending(curProxy);
                } else {
                    this.framework.packageAdmin.unexportResources(curProxy);
                    if (this.loader != null) {
                        this.loader.clear();
                        this.loader.close();
                    }
                    this.framework.bundles.unMarkDependancies(curProxy);
                }
                this.state = 2;
                this.loader = null;
                this.proxy = null;
                this.unresolveFragments();
                this.fragments = null;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        this.bundledata = newBundle.bundledata;
        this.bundledata.setBundle(this);
        return exporting;
    }

    protected void unresolveFragments() {
        if (this.fragments != null) {
            int i = 0;
            while (i < this.fragments.length) {
                this.fragments[i].unresolve();
                ++i;
            }
        }
    }

    protected void refresh() throws BundleException {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.reload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 4) {
            BundleLoaderProxy curProxy = this.getLoaderProxy();
            this.framework.packageAdmin.unexportResources(curProxy);
            if (this.loader != null) {
                this.loader.clear();
                this.loader.close();
            }
            this.framework.bundles.unMarkDependancies(curProxy);
            this.loader = null;
            this.proxy = null;
            this.fragments = null;
            this.state = 2;
        }
        this.manifestLocalization = null;
    }

    protected boolean unload() {
        if (Debug.DEBUG_GENERAL && (this.state & 7) == 0) {
            Debug.println("Bundle.unload called when state != UNINSTALLED | INSTALLED | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        boolean exporting = false;
        if (this.framework.isActive()) {
            if (this.state == 4) {
                BundleLoaderProxy curProxy = this.getLoaderProxy();
                exporting = curProxy.inUse();
                if (exporting) {
                    curProxy.getBundleLoader();
                    this.framework.packageAdmin.addRemovalPending(curProxy);
                } else {
                    this.framework.packageAdmin.unexportResources(curProxy);
                    if (this.loader != null) {
                        this.loader.clear();
                        this.loader.close();
                    }
                    this.framework.bundles.unMarkDependancies(curProxy);
                }
                this.state = 2;
                this.loader = null;
                this.proxy = null;
                this.unresolveFragments();
                this.fragments = null;
                this.domain = null;
            }
        } else {
            try {
                this.bundledata.close();
            }
            catch (IOException iOException) {}
        }
        return exporting;
    }

    protected Class loadClass(String name, boolean checkPermission) throws ClassNotFoundException {
        this.checkValid();
        if (checkPermission) {
            this.framework.checkAdminPermission();
        }
        if (!this.isResolved()) {
            this.framework.packageAdmin.resolveBundles();
            if (!this.isResolved()) {
                throw new ClassNotFoundException(Msg.formatter.getString("BUNDLE_CNFE_NOT_RESOLVED", this.getLocation(), name));
            }
        }
        if (Debug.DEBUG_GENERAL && (this.state & 0x3C) == 0) {
            Debug.println("Bundle.loadClass(" + name + ") called when state != STARTING | ACTIVE | STOPPING | RESOLVED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        this.getBundleLoader();
        if (this.loader == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.loadClass(" + name + ") called when loader == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            throw new ClassNotFoundException(name);
        }
        return this.loader.loadClass(name);
    }

    public URL getResource(String name) {
        this.checkValid();
        this.framework.checkAdminPermission();
        if (!this.isResolved()) {
            this.framework.packageAdmin.resolveBundles();
            if (!this.isResolved()) {
                return null;
            }
        }
        this.getBundleLoader();
        if (this.loader == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle.getResource(" + name + ") called when loader == null: " + this);
                Debug.printStackTrace(new Exception("Stack trace"));
            }
            return null;
        }
        return this.loader.getResource(name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startWorker(boolean persistent) throws BundleException {
        block20: {
            long start = 0L;
            if (!this.framework.active) break block20;
            if ((this.state & 0x28) != 0) {
                return;
            }
            try {
                if (this.state == 2) {
                    this.framework.packageAdmin.resolveBundles();
                    if (this.state != 4) {
                        throw new BundleException(this.getResolutionFailureMessage());
                    }
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Bundle: Active sl = " + this.framework.startLevelManager.getStartLevel() + "; Bundle " + this.getBundleId() + " sl = " + this.getStartLevel());
                }
                if (this.getStartLevel() <= this.framework.startLevelManager.getStartLevel()) {
                    BundleWatcher bundleStats;
                    if (Debug.MONITOR_ACTIVATION && (bundleStats = this.framework.adaptor.getBundleWatcher()) != null) {
                        bundleStats.startActivation(this);
                    }
                    if (Debug.DEBUG_BUNDLE_TIME) {
                        start = System.currentTimeMillis();
                        System.out.println("Starting " + this.getSymbolicName());
                    }
                    this.state = 8;
                    this.context = this.createContext();
                    try {
                        this.context.start();
                        if (this.framework.active) {
                            this.state = 32;
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println("->started " + this);
                            }
                            this.framework.publishBundleEvent(2, this);
                        }
                    }
                    catch (BundleException e) {
                        this.context.close();
                        this.context = null;
                        this.state = 4;
                        throw e;
                    }
                    if (this.state == 1) {
                        this.context.close();
                        this.context = null;
                        throw new BundleException(Msg.formatter.getString("BUNDLE_UNINSTALLED_EXCEPTION", this.getLocation()));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (this.state == 32) {
                    BundleWatcher bundleStats;
                    if (Debug.MONITOR_ACTIVATION && (bundleStats = this.framework.adaptor.getBundleWatcher()) != null) {
                        bundleStats.endActivation(this);
                    }
                    if (Debug.DEBUG_BUNDLE_TIME) {
                        System.out.println("End starting " + this.getSymbolicName() + " " + (System.currentTimeMillis() - start));
                    }
                }
                throw throwable;
            }
            {
                BundleWatcher bundleStats;
                Object var5_7 = null;
                if (this.state != 32) break block20;
                if (Debug.MONITOR_ACTIVATION && (bundleStats = this.framework.adaptor.getBundleWatcher()) != null) {
                    bundleStats.endActivation(this);
                }
                if (!Debug.DEBUG_BUNDLE_TIME) break block20;
                System.out.println("End starting " + this.getSymbolicName() + " " + (System.currentTimeMillis() - start));
            }
        }
        if (persistent) {
            this.setStatus(1, true);
        }
    }

    protected BundleContextImpl createContext() {
        return new BundleContextImpl(this);
    }

    protected BundleContextImpl getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopWorker(boolean persistent) throws BundleException {
        if (persistent) {
            this.setStatus(1, false);
        }
        if (!this.framework.active) return;
        if ((this.state & 0x16) != 0) {
            return;
        }
        this.state = 16;
        try {
            this.context.stop();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.context.close();
            this.context = null;
            this.checkValid();
            this.state = 4;
            if (Debug.DEBUG_GENERAL) {
                Debug.println("->stopped " + this);
            }
            this.framework.publishBundleEvent(4, this);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.context.close();
            this.context = null;
        }
        this.checkValid();
        this.state = 4;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("->stopped " + this);
        }
        this.framework.publishBundleEvent(4, this);
    }

    public ServiceReference[] getRegisteredServices() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getRegisteredServices();
    }

    public ServiceReference[] getServicesInUse() {
        this.checkValid();
        if (this.context == null) {
            return null;
        }
        return this.context.getServicesInUse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getFragments() {
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            if (this.fragments == null) {
                return null;
            }
            Bundle[] result = new Bundle[this.fragments.length];
            System.arraycopy(this.fragments, 0, result, 0, result.length);
            return result;
        }
    }

    protected void attachFragment(BundleFragment fragment) throws BundleException {
        if (this.fragments == null) {
            this.fragments = new BundleFragment[]{fragment};
        } else {
            boolean inserted = false;
            BundleFragment[] newFragments = new BundleFragment[this.fragments.length + 1];
            int i = 0;
            while (i < this.fragments.length) {
                if (!inserted && fragment.getBundleId() < this.fragments[i].getBundleId()) {
                    if (this.loader != null) {
                        throw new BundleException(Msg.formatter.getString("BUNDLE_LOADER_ATTACHMENT_ERROR", this.fragments[i].getSymbolicName(), this.getSymbolicName()));
                    }
                    newFragments[i] = fragment;
                    inserted = true;
                }
                newFragments[inserted ? i + 1 : i] = this.fragments[i];
                ++i;
            }
            if (!inserted) {
                newFragments[newFragments.length - 1] = fragment;
            }
            this.fragments = newFragments;
        }
        if (this.loader != null) {
            this.loader.attachFragment(fragment, SecureAction.getProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleLoader getBundleLoader() {
        if (this.loader == null) {
            BundleHost bundleHost = this;
            synchronized (bundleHost) {
                if (this.loader == null) {
                    try {
                        this.loader = new BundleLoader(this, this.getBundleDescription());
                        this.getLoaderProxy().setBundleLoader(this.loader);
                    }
                    catch (BundleException e) {
                        this.framework.publishFrameworkEvent(2, this, e);
                        return null;
                    }
                }
            }
        }
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BundleLoaderProxy getLoaderProxy() {
        if (this.proxy == null) {
            BundleHost bundleHost = this;
            synchronized (bundleHost) {
                if (this.proxy == null) {
                    this.proxy = new BundleLoaderProxy(this);
                }
            }
        }
        return this.proxy;
    }
}

