/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.SearchMessages;

public class MatchLocator {
    protected static final int fgLF = 10;
    protected static final int fgCR = 13;
    private Matcher fMatcher;
    protected int fPushbackChar;
    protected boolean fPushback;

    public MatchLocator(Pattern pattern) {
        this.fMatcher = pattern.matcher("");
    }

    public MatchLocator(String pattern, boolean isCaseSensitive, boolean isRegexSearch) throws PatternSyntaxException {
        this(PatternConstructor.createPattern(pattern, isCaseSensitive, isRegexSearch));
    }

    public boolean isEmtpy() {
        return this.fMatcher.pattern().pattern().length() == 0;
    }

    public void locateMatches(IProgressMonitor monitor, Reader reader, ITextSearchResultCollector collector, IResourceProxy proxy) throws IOException, CoreException {
        int lineCounter = 1;
        int charCounter = 0;
        boolean eof = false;
        while (!eof) {
            StringBuffer sb = new StringBuffer(200);
            int eolStrLength = this.readLine(reader, sb);
            int lineLength = sb.length();
            int start = 0;
            eof = eolStrLength == -1;
            String line = sb.toString();
            while (start < lineLength) {
                this.fMatcher.reset(line);
                if (this.fMatcher.find(start)) {
                    start = charCounter + this.fMatcher.start();
                    int length = this.fMatcher.end() - this.fMatcher.start();
                    collector.accept(proxy, start, length);
                    start = this.fMatcher.end();
                    continue;
                }
                start = lineLength;
            }
            charCounter += lineLength + eolStrLength;
            ++lineCounter;
            if (!monitor.isCanceled()) continue;
            throw new OperationCanceledException(SearchMessages.getString("TextSearchVisitor.canceled"));
        }
    }

    private int readLine(Reader reader, StringBuffer sb) throws IOException {
        int ch = -1;
        if (this.fPushback) {
            ch = this.fPushbackChar;
            this.fPushback = false;
        } else {
            ch = reader.read();
        }
        while (ch >= 0) {
            if (ch == 10) {
                return 1;
            }
            if (ch == 13) {
                ch = reader.read();
                if (ch == 10) {
                    return 2;
                }
                this.fPushbackChar = ch;
                this.fPushback = true;
                return 1;
            }
            sb.append((char)ch);
            ch = reader.read();
        }
        return -1;
    }

    public void locateMatches(IProgressMonitor progressMonitor, CharSequence searchInput, ITextSearchResultCollector collector, IResourceProxy proxy) throws CoreException {
        this.fMatcher.reset(searchInput);
        int pos = 0;
        int k = 0;
        while (pos < searchInput.length() && this.fMatcher.find(pos)) {
            int start = this.fMatcher.start();
            int end = this.fMatcher.end();
            collector.accept(proxy, start, end - start);
            if (end == start) {
                // empty if block
            }
            pos = ++end;
            if (k++ != 20) continue;
            if (progressMonitor.isCanceled()) {
                throw new OperationCanceledException(SearchMessages.getString("TextSearchVisitor.canceled"));
            }
            k = 0;
        }
    }
}

