/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.search.internal.core.SearchScope;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.ui.IWorkingSet;

public class TextSearchScope
extends SearchScope {
    private Set fExtensions = new HashSet(3);
    static /* synthetic */ Class class$0;

    public static TextSearchScope newWorkspaceScope() {
        return new WorkspaceScope();
    }

    public TextSearchScope(String description) {
        super(description);
    }

    public TextSearchScope(String description, IResource[] resources) {
        super(description, resources);
    }

    public TextSearchScope(String description, IAdaptable[] elements) {
        super(description, TextSearchScope.convertToResources(elements));
    }

    public TextSearchScope(String description, IWorkingSet[] workingSets) {
        super(description, TextSearchScope.convertToResources(TextSearchScope.getElements(workingSets)));
    }

    private static IResource[] convertToResources(IAdaptable[] elements) {
        int length = elements.length;
        HashSet<IResource> resources = new HashSet<IResource>(length);
        int i = 0;
        while (i < length) {
            IResource resource;
            IAdaptable iAdaptable = elements[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                resources.add(resource);
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private static IAdaptable[] getElements(IWorkingSet[] workingSets) {
        int length = workingSets.length;
        HashSet<IAdaptable> elements = new HashSet<IAdaptable>(length);
        int i = 0;
        while (i < length) {
            elements.addAll(Arrays.asList(workingSets[i].getElements()));
            ++i;
        }
        return elements.toArray(new IAdaptable[elements.size()]);
    }

    public void addExtension(String extension) {
        Pattern pattern = PatternConstructor.createPattern(extension, true, false);
        this.fExtensions.add(pattern.matcher(""));
    }

    public void addExtensions(Set extensions) {
        if (extensions == null) {
            return;
        }
        Iterator iter = extensions.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof String)) continue;
            this.addExtension((String)obj);
        }
    }

    public boolean encloses(IResourceProxy proxy) {
        if (proxy.getType() == 1 && this.skipFile(proxy.getName())) {
            return false;
        }
        return super.encloses(proxy);
    }

    protected boolean encloses(IPath elementPath, int elementType) {
        if (elementType == 1 && this.skipFile(elementPath.lastSegment())) {
            return false;
        }
        return super.encloses(elementPath, elementType);
    }

    boolean skipFile(String fileName) {
        if (this.fExtensions.isEmpty()) {
            return false;
        }
        Iterator iter = this.fExtensions.iterator();
        while (iter.hasNext()) {
            if (!((Matcher)iter.next()).reset(fileName).matches()) continue;
            return false;
        }
        return true;
    }

    private static class WorkspaceScope
    extends TextSearchScope {
        WorkspaceScope() {
            super(SearchMessages.getString("WorkspaceScope"));
        }

        public void add(IResource element) {
        }

        public boolean encloses(IResourceProxy proxy) {
            return proxy.getType() != 1 || !this.skipFile(proxy.getName());
        }

        public boolean encloses(IPath elementPath, int elementType) {
            return elementType != 1 || !this.skipFile(elementPath.lastSegment());
        }
    }
}

