/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;

public class ClasspathHelper {
    public static String getDevEntriesProperties(String fileName, boolean checkExcluded) {
        File directory;
        File file = new File(fileName);
        if (!(file.exists() || (directory = file.getParentFile()) == null || directory.exists() && !directory.isFile())) {
            directory.mkdirs();
        }
        Properties properties = new Properties();
        WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        IPluginModelBase[] models = manager.getAllModels();
        int i = 0;
        while (i < models.length) {
            String entry;
            String id = models[i].getPluginBase().getId();
            if (id != null && (entry = ClasspathHelper.writeEntry(ClasspathHelper.getOutputFolders(models[i], checkExcluded))).length() > 0) {
                properties.put(id, entry);
            }
            ++i;
        }
        try {
            FileOutputStream stream = new FileOutputStream(fileName);
            properties.store(stream, "");
            stream.flush();
            stream.close();
            return new URL("file:" + fileName).toString();
        }
        catch (IOException e) {
            PDECore.logException((Throwable)e);
            return ClasspathHelper.getDevEntries(checkExcluded);
        }
    }

    public static String getDevEntries(boolean checkExcluded) {
        WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        IPluginModelBase[] models = manager.getAllModels();
        ArrayList<IPath> list = new ArrayList<IPath>();
        int i = 0;
        while (i < models.length) {
            String id = models[i].getPluginBase().getId();
            if (id != null && id.trim().length() != 0) {
                IPath[] paths = ClasspathHelper.getOutputFolders(models[i], checkExcluded);
                int j = 0;
                while (j < paths.length) {
                    list.add(paths[j]);
                    ++j;
                }
            }
            ++i;
        }
        String entry = ClasspathHelper.writeEntry(list.toArray(new IPath[list.size()]));
        return entry.length() > 0 ? entry : "bin";
    }

    private static String writeEntry(IPath[] paths) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            buffer.append(paths[i].toString());
            if (i < paths.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }

    private static IPath[] getOutputFolders(IPluginModelBase model, boolean checkExcluded) {
        ArrayList result = new ArrayList();
        IProject project = model.getUnderlyingResource().getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jProject = JavaCore.create((IProject)project);
                List excluded = ClasspathHelper.getFoldersToExclude(project, checkExcluded);
                IPath path = jProject.getOutputLocation();
                if (path != null && !excluded.contains(path)) {
                    ClasspathHelper.addPath(result, project, path);
                }
                IClasspathEntry[] entries = jProject.getRawClasspath();
                int i = 0;
                while (i < entries.length) {
                    path = null;
                    if (entries[i].getEntryKind() == 3) {
                        path = entries[i].getOutputLocation();
                    } else if (entries[i].getEntryKind() == 1) {
                        path = entries[i].getPath();
                    }
                    if (path != null && !excluded.contains(path)) {
                        ClasspathHelper.addPath(result, project, path);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        return result.toArray(new IPath[result.size()]);
    }

    private static void addPath(ArrayList result, IProject project, IPath path) {
        if (path.segmentCount() > 0 && path.segment(0).equals(project.getName())) {
            if ((path = path.removeFirstSegments(1)).segmentCount() == 0) {
                path = new Path(".");
            } else {
                IResource resource = project.findMember(path);
                if (resource != null) {
                    if (resource.isLinked()) {
                        path = resource.getLocation();
                    } else if (resource instanceof IFile) {
                        path = null;
                    }
                } else {
                    path = null;
                }
            }
        }
        if (path != null && !result.contains(path)) {
            result.add(path);
        }
    }

    private static List getFoldersToExclude(IProject project, boolean checkExcluded) {
        IEclipsePreferences pref;
        ArrayList<Path> list = new ArrayList<Path>();
        if (checkExcluded && (pref = new ProjectScope(project).getNode("org.eclipse.pde.core")) != null) {
            String binExcludes = pref.get("selfhosting.binExcludes", "");
            StringTokenizer tokenizer = new StringTokenizer(binExcludes, ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(new Path(tokenizer.nextToken().trim()));
            }
        }
        return list;
    }
}

