/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.text.IReconcilingParticipant;
import org.eclipse.pde.internal.ui.model.IEditingModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class SourceOutlinePage
extends ContentOutlinePage
implements IReconcilingParticipant,
ISortableContentOutlinePage {
    private IEditingModel fModel;
    private IBaseLabelProvider fLabelProvider;
    private IContentProvider fContentProvider;
    private ViewerSorter fDefaultSorter;
    private ViewerSorter fViewerSorter;
    private boolean sorted;
    TreeViewer viewer;

    public SourceOutlinePage(IEditingModel model, IBaseLabelProvider lProvider, IContentProvider cProvider, ViewerSorter defaultSorter, ViewerSorter sorter) {
        this.fModel = model;
        this.fLabelProvider = lProvider;
        this.fContentProvider = cProvider;
        this.fDefaultSorter = defaultSorter;
        this.fViewerSorter = sorter;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider(this.fContentProvider);
        this.viewer.setLabelProvider(this.fLabelProvider);
        if (this.sorted) {
            this.viewer.setSorter(this.fViewerSorter);
        } else {
            this.viewer.setSorter(this.fDefaultSorter);
        }
        this.viewer.setInput((Object)this.fModel);
        this.viewer.expandAll();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
    }

    public void reconciled(IDocument document) {
        final Control control = this.getControl();
        if (control == null) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (control.isDisposed()) {
                    return;
                }
                control.setRedraw(false);
                SourceOutlinePage.this.getTreeViewer().refresh();
                SourceOutlinePage.this.getTreeViewer().expandAll();
                control.setRedraw(true);
            }
        });
    }

    public void sort(boolean sorting) {
        this.sorted = sorting;
        if (this.viewer != null) {
            if (sorting) {
                this.viewer.setSorter(this.fViewerSorter);
            } else {
                this.viewer.setSorter(this.fDefaultSorter);
            }
        }
    }
}

