/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.KeyValueSourcePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.model.IDocumentRange;
import org.eclipse.pde.internal.ui.model.build.BuildEntry;
import org.eclipse.swt.graphics.Image;

public class BuildSourcePage
extends KeyValueSourcePage {
    public BuildSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected ILabelProvider createOutlineLabelProvider() {
        return new BuildLabelProvider();
    }

    protected ITreeContentProvider createOutlineContentProvider() {
        return new BuildOutlineContentProvider();
    }

    protected IDocumentRange getRangeElement(ITextSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        IBuildModel model = (IBuildModel)this.getInputContext().getModel();
        return this.findBuildNode(model.getBuild().getBuildEntries(), selection.getOffset());
    }

    private BuildEntry findBuildNode(IBuildEntry[] nodes, int offset) {
        int i = 0;
        while (i < nodes.length) {
            BuildEntry node = (BuildEntry)nodes[i];
            if (offset >= node.getOffset() && offset < node.getOffset() + node.getLength()) {
                return node;
            }
            ++i;
        }
        return null;
    }

    class BuildOutlineContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        BuildOutlineContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            return false;
        }

        public Object getParent(Object child) {
            if (child instanceof IBuildEntry) {
                return ((IBuildEntry)child).getModel();
            }
            return null;
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IBuildModel) {
                IBuildModel model = (IBuildModel)parent;
                IBuild build = model.getBuild();
                return build.getBuildEntries();
            }
            return new Object[0];
        }
    }

    class BuildLabelProvider
    extends LabelProvider {
        BuildLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof IBuildEntry) {
                return ((IBuildEntry)obj).getName();
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof IBuildEntry) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_BUILD_VAR_OBJ);
            }
            return null;
        }
    }
}

