/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PropertiesAction;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureReferencePage;
import org.eclipse.pde.internal.ui.editor.feature.NewFeaturePluginWizardPage;
import org.eclipse.pde.internal.ui.editor.feature.OpenReferenceAction;
import org.eclipse.pde.internal.ui.editor.feature.ReferenceWizard;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PluginSection
extends TableSection
implements IModelProviderListener {
    private static final String PLUGIN_TITLE = "FeatureEditor.PluginSection.pluginTitle";
    private static final String PLUGIN_DESC = "FeatureEditor.PluginSection.pluginDesc";
    private static final String KEY_NEW = "FeatureEditor.PluginSection.new";
    public static final String POPUP_NEW = "Menus.new.label";
    public static final String POPUP_OPEN = "Actions.open.label";
    public static final String POPUP_DELETE = "Actions.delete.label";
    private OpenReferenceAction openAction;
    private PropertiesAction propertiesAction;
    private TableViewer pluginViewer;
    private Action newAction;
    private Action deleteAction;

    public PluginSection(FeatureReferencePage page, Composite parent) {
        super((PDEFormPage)page, parent, 128, new String[]{PDEPlugin.getResourceString(KEY_NEW)});
        this.getSection().setText(PDEPlugin.getResourceString(PLUGIN_TITLE));
        this.getSection().setDescription(PDEPlugin.getResourceString(PLUGIN_DESC));
        this.getTablePart().setEditable(false);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        GridLayout layout = (GridLayout)container.getLayout();
        layout.verticalSpacing = 9;
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.pluginViewer = tablePart.getTableViewer();
        this.pluginViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.pluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.pluginViewer.setSorter(ListUtil.NAME_SORTER);
        toolkit.paintBordersFor(container);
        this.makeActions();
        section.setClient((Control)container);
        this.initialize();
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        this.openAction.run();
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNew();
        }
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        mng.removeModelProviderListener((IModelProviderListener)this);
        super.dispose();
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IFeaturePlugin) {
            this.pluginViewer.setSelection((ISelection)new StructuredSelection(object), true);
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.openAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.newAction);
        manager.add((IAction)this.deleteAction);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.propertiesAction);
    }

    private void handleNew() {
        final IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        BusyIndicator.showWhile((Display)this.pluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                NewFeaturePluginWizardPage page = new NewFeaturePluginWizardPage(model);
                ReferenceWizard wizard = new ReferenceWizard(model, page);
                WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            }
        });
    }

    private void handleSelectAll() {
        IStructuredContentProvider provider = (IStructuredContentProvider)this.pluginViewer.getContentProvider();
        Object[] elements = provider.getElements(this.pluginViewer.getInput());
        StructuredSelection ssel = new StructuredSelection(elements);
        this.pluginViewer.setSelection((ISelection)ssel);
    }

    private void handleDelete() {
        IStructuredSelection ssel = (IStructuredSelection)this.pluginViewer.getSelection();
        if (ssel.isEmpty()) {
            return;
        }
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        try {
            IFeaturePlugin[] removed = new IFeaturePlugin[ssel.size()];
            int i = 0;
            Iterator iter = ssel.iterator();
            while (iter.hasNext()) {
                IFeaturePlugin iobj = (IFeaturePlugin)iter.next();
                removed[i++] = iobj;
            }
            feature.removePlugins(removed);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            BusyIndicator.showWhile((Display)this.pluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    PluginSection.this.handleDelete();
                }
            });
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            BusyIndicator.showWhile((Display)this.pluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    PluginSection.this.handleSelectAll();
                }
            });
            return true;
        }
        return false;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        this.getTablePart().setButtonEnabled(0, model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        mng.addModelProviderListener((IModelProviderListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object obj = e.getChangedObjects()[0];
        if (obj instanceof IFeaturePlugin) {
            if (e.getChangeType() == 3) {
                this.pluginViewer.update(obj, null);
            } else if (e.getChangeType() == 1) {
                this.pluginViewer.add(e.getChangedObjects());
            } else if (e.getChangeType() == 2) {
                this.pluginViewer.remove(e.getChangedObjects());
            }
        }
    }

    private void makeActions() {
        IModel model = (IModel)this.getPage().getModel();
        this.newAction = new Action(){

            public void run() {
                PluginSection.this.handleNew();
            }
        };
        this.newAction.setText(PDEPlugin.getResourceString(POPUP_NEW));
        this.newAction.setEnabled(model.isEditable());
        this.deleteAction = new Action(){

            public void run() {
                BusyIndicator.showWhile((Display)PluginSection.this.pluginViewer.getTable().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        PluginSection.access$0(5.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ PluginSection access$0(5 var0) {
                return var0.PluginSection.this;
            }
        };
        this.deleteAction.setText(PDEPlugin.getResourceString(POPUP_DELETE));
        this.deleteAction.setEnabled(model.isEditable());
        this.openAction = new OpenReferenceAction((ISelectionProvider)this.pluginViewer);
        this.propertiesAction = new PropertiesAction(this.getPage().getPDEEditor());
    }

    public void modelsChanged(IModelProviderEvent event) {
        IModel[] added = event.getAddedModels();
        IModel[] removed = event.getRemovedModels();
        IModel[] changed = event.getChangedModels();
        if (this.hasPluginModels(added) || this.hasPluginModels(removed) || this.hasPluginModels(changed)) {
            this.markStale();
        }
    }

    private boolean hasPluginModels(IModel[] models) {
        if (models == null) {
            return false;
        }
        if (models.length == 0) {
            return false;
        }
        int i = 0;
        while (i < models.length) {
            if (models[i] instanceof IPluginModelBase) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setFocus() {
        if (this.pluginViewer != null) {
            this.pluginViewer.getTable().setFocus();
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.pluginViewer.setInput((Object)feature);
        super.refresh();
    }

    public boolean canPaste(Clipboard clipboard) {
        Object[] objects = (Object[])clipboard.getContents((Transfer)ModelDataTransfer.getInstance());
        if (objects != null && objects.length > 0) {
            return this.canPaste(null, objects);
        }
        return false;
    }

    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (!(objects[i] instanceof FeaturePlugin)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void doPaste() {
        Clipboard clipboard = this.getPage().getPDEEditor().getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)ModelDataTransfer.getInstance());
        if (objects != null && this.canPaste(null, objects)) {
            this.doPaste(null, objects);
        }
    }

    protected void doPaste(Object target, Object[] objects) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        FeaturePlugin[] fPlugins = new FeaturePlugin[objects.length];
        try {
            int i = 0;
            while (i < objects.length) {
                FeaturePlugin fPlugin = (FeaturePlugin)objects[i];
                fPlugin.setModel(model);
                fPlugin.setParent((IFeatureObject)feature);
                fPlugin.hookWithWorkspace();
                fPlugins[i] = fPlugin;
                ++i;
            }
            feature.addPlugins((IFeaturePlugin[])fPlugins);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IFeature) {
                return ((IFeature)parent).getPlugins();
            }
            return new Object[0];
        }
    }
}

