/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.XMLSourcePage;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.model.IDocumentNode;
import org.eclipse.pde.internal.ui.model.IDocumentRange;
import org.eclipse.pde.internal.ui.model.plugin.PluginModelBase;
import org.eclipse.swt.graphics.Image;

public class ManifestSourcePage
extends XMLSourcePage {
    private Object fLibraries = new Object();
    private Object fImports = new Object();
    private Object fExtensionPoints = new Object();
    private Object fExtensions = new Object();

    public ManifestSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected ILabelProvider createOutlineLabelProvider() {
        return new OutlineLabelProvider();
    }

    protected ITreeContentProvider createOutlineContentProvider() {
        return new ContentProvider();
    }

    protected void outlineSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IDocumentNode && !(first instanceof IPluginBase)) {
                this.setHighlightRange((IDocumentNode)first, true);
                this.setSelectedRange((IDocumentNode)first);
            } else {
                this.resetHighlightRange();
            }
        }
    }

    public void setSelectedRange(IDocumentNode node) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        int offset = node.getOffset();
        sourceViewer.setSelectedRange(offset + 1, node.getXMLTagName().length());
    }

    protected ViewerSorter createOutlineSorter() {
        return new OutlineSorter();
    }

    protected IDocumentRange getRangeElement(ITextSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        IPluginModelBase model = (IPluginModelBase)this.getInputContext().getModel();
        int offset = selection.getOffset();
        IDocumentNode node = this.findNode((IPluginObject[])model.getPluginBase().getLibraries(), offset);
        if (node == null) {
            node = this.findNode((IPluginObject[])model.getPluginBase().getImports(), offset);
        }
        if (node == null) {
            node = this.findNode((IPluginObject[])model.getPluginBase().getExtensionPoints(), offset);
        }
        if (node == null) {
            node = this.findNode((IPluginObject[])model.getPluginBase().getExtensions(), offset);
        }
        if (node == null) {
            node = this.findNode(new IPluginObject[]{model.getPluginBase()}, offset);
        }
        return node;
    }

    private IDocumentNode findNode(IPluginObject[] nodes, int offset) {
        int i = 0;
        while (i < nodes.length) {
            IDocumentNode node = (IDocumentNode)nodes[i];
            if (offset >= node.getOffset() && offset < node.getOffset() + node.getLength()) {
                return node;
            }
            ++i;
        }
        return null;
    }

    class OutlineLabelProvider
    extends LabelProvider {
        private PDELabelProvider fProvider = PDEPlugin.getDefault().getLabelProvider();

        public String getText(Object obj) {
            if (obj == ManifestSourcePage.this.fLibraries) {
                return PDEPlugin.getResourceString("ManifestSourcePage.libraries");
            }
            if (obj == ManifestSourcePage.this.fImports) {
                return PDEPlugin.getResourceString("ManifestSourcePage.dependencies");
            }
            if (obj == ManifestSourcePage.this.fExtensionPoints) {
                return PDEPlugin.getResourceString("ManifestSourcePage.extensionPoints");
            }
            if (obj == ManifestSourcePage.this.fExtensions) {
                return PDEPlugin.getResourceString("ManifestSourcePage.extensions");
            }
            return this.fProvider.getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj == ManifestSourcePage.this.fLibraries) {
                return this.fProvider.get(PDEPluginImages.DESC_RUNTIME_OBJ);
            }
            if (obj == ManifestSourcePage.this.fImports) {
                return this.fProvider.get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ);
            }
            if (obj == ManifestSourcePage.this.fExtensionPoints) {
                return this.fProvider.get(PDEPluginImages.DESC_EXT_POINTS_OBJ);
            }
            if (obj == ManifestSourcePage.this.fExtensions) {
                return this.fProvider.get(PDEPluginImages.DESC_EXTENSIONS_OBJ);
            }
            Image image = this.fProvider.getImage(obj);
            int flags = ((IDocumentNode)obj).isErrorNode() ? 1 : 0;
            return flags == 0 ? image : this.fProvider.get(image, flags);
        }
    }

    class ContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            PluginModelBase model = (PluginModelBase)ManifestSourcePage.this.getInputContext().getModel();
            ArrayList<Object> result = new ArrayList<Object>();
            if (parent instanceof IPluginBase) {
                IPluginBase pluginBase = (IPluginBase)parent;
                if (pluginBase.getLibraries().length > 0) {
                    result.add(ManifestSourcePage.this.fLibraries);
                }
                if (pluginBase.getImports().length > 0) {
                    result.add(ManifestSourcePage.this.fImports);
                }
                if (pluginBase.getExtensionPoints().length > 0) {
                    result.add(ManifestSourcePage.this.fExtensionPoints);
                }
                if (pluginBase.getExtensions().length > 0) {
                    result.add(ManifestSourcePage.this.fExtensions);
                }
                return result.toArray();
            }
            if (parent == ManifestSourcePage.this.fLibraries) {
                return model.getPluginBase().getLibraries();
            }
            if (parent == ManifestSourcePage.this.fImports) {
                return model.getPluginBase().getImports();
            }
            if (parent == ManifestSourcePage.this.fExtensionPoints) {
                return model.getPluginBase().getExtensionPoints();
            }
            if (parent == ManifestSourcePage.this.fExtensions) {
                return model.getPluginBase().getExtensions();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IDocumentNode) {
                return ((IDocumentNode)element).getParentNode();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IPluginBase) {
                return ((IDocumentNode)element).getChildNodes().length > 0;
            }
            return element == ManifestSourcePage.this.fLibraries || element == ManifestSourcePage.this.fImports || element == ManifestSourcePage.this.fExtensionPoints || element == ManifestSourcePage.this.fExtensions;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IPluginModelBase) {
                return new Object[]{((IPluginModelBase)inputElement).getPluginBase()};
            }
            return new Object[0];
        }
    }

    class OutlineSorter
    extends ViewerSorter {
        OutlineSorter() {
        }

        public int category(Object element) {
            if (element == ManifestSourcePage.this.fLibraries) {
                return 0;
            }
            if (element == ManifestSourcePage.this.fImports) {
                return 1;
            }
            if (element == ManifestSourcePage.this.fExtensionPoints) {
                return 2;
            }
            if (element == ManifestSourcePage.this.fExtensions) {
                return 3;
            }
            return 4;
        }
    }
}

