/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ConfigurationTab
extends AbstractLauncherTab
implements ILauncherSettings {
    private Button fClearConfig;
    private Image fImage = PDEPluginImages.DESC_PLUGIN_CONFIG_OBJ.createImage();
    private Button fUseDefaultLocationButton;
    private Label fConfigAreaLabel;
    private Text fConfigAreaText;
    private Button fConfigAreaBrowse;
    private Button fGenerateFileButton;
    private Button fUseTemplateButton;
    private Label fTemplateLocationLabel;
    private Text fTemplateLocationText;
    private Button fTemplateLocationBrowse;
    private String fLastEnteredConfigArea = "";
    private String fConfigName;
    private boolean fBlockChanges;

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.createConfigAreaGroup(container);
        this.createStartingSpace(container, 1);
        this.createConfigFileGroup(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.pde.doc.user.launcher_configuration");
    }

    private void createConfigAreaGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEPlugin.getResourceString("ConfigurationTab.configAreaGroup"));
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        this.fUseDefaultLocationButton = new Button((Composite)group, 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fUseDefaultLocationButton.setLayoutData((Object)gd);
        this.fUseDefaultLocationButton.setText(PDEPlugin.getResourceString("ConfigurationTab.useDefaultLoc"));
        this.fUseDefaultLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ConfigurationTab.this.fUseDefaultLocationButton.getSelection();
                ConfigurationTab.this.fConfigAreaLabel.setEnabled(!selected);
                ConfigurationTab.this.fConfigAreaText.setEnabled(!selected);
                ConfigurationTab.this.fConfigAreaBrowse.setEnabled(!selected);
                if (!selected) {
                    ConfigurationTab.this.fConfigAreaText.setText(ConfigurationTab.this.fLastEnteredConfigArea);
                } else {
                    ConfigurationTab.this.fConfigAreaText.setText(PDECore.getDefault().getStateLocation().append(ConfigurationTab.this.fConfigName).toOSString());
                }
                ConfigurationTab.this.updateStatus();
            }
        });
        this.fConfigAreaLabel = new Label((Composite)group, 0);
        this.fConfigAreaLabel.setText(PDEPlugin.getResourceString("ConfigurationTab.configLog"));
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.fConfigAreaLabel.setLayoutData((Object)gd);
        this.fConfigAreaText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        gd.widthHint = 300;
        this.fConfigAreaText.setLayoutData((Object)gd);
        this.fConfigAreaText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ConfigurationTab.this.fBlockChanges) {
                    ConfigurationTab.this.updateStatus();
                }
            }
        });
        this.fConfigAreaBrowse = new Button((Composite)group, 8);
        this.fConfigAreaBrowse.setText(PDEPlugin.getResourceString("ConfigurationTab.configBrowse"));
        this.fConfigAreaBrowse.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fConfigAreaBrowse);
        this.fConfigAreaBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationTab.this.handleBrowseDirectory();
            }
        });
        this.fClearConfig = new Button((Composite)group, 32);
        this.fClearConfig.setText(PDEPlugin.getResourceString("ConfigurationTab.clearArea"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fClearConfig.setLayoutData((Object)gd);
        this.fClearConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void handleBrowseDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(this.getControl().getShell());
        dialog.setFilterPath(this.fConfigAreaText.getText().trim());
        dialog.setText(PDEPlugin.getResourceString("ConfigurationTab.configLocTitle"));
        dialog.setMessage(PDEPlugin.getResourceString("ConfigurationTab.configLocMessage"));
        String res = dialog.open();
        if (res != null) {
            this.fConfigAreaText.setText(res);
        }
    }

    protected void updateStatus() {
        if (!this.fUseDefaultLocationButton.getSelection() && this.fConfigAreaText.getText().trim().length() == 0) {
            this.updateStatus(AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString("ConfigurationTab.noConfigLoc")));
            return;
        }
        if (this.fUseTemplateButton.getSelection()) {
            String location = this.fTemplateLocationText.getText().trim();
            if (location.length() == 0) {
                this.updateStatus(AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString("ConfigurationTab.noTemplateLoc")));
                return;
            }
            File file = new File(location);
            if (!file.exists() || !file.isFile()) {
                this.updateStatus(AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString("ConfigurationTab.templateNotExists")));
                return;
            }
        }
        this.updateStatus(AbstractLauncherTab.createStatus(0, ""));
    }

    private void createConfigFileGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEPlugin.getResourceString("ConfigurationTab.configFileGroup"));
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        this.fGenerateFileButton = new Button((Composite)group, 16);
        this.fGenerateFileButton.setText(PDEPlugin.getResourceString("ConfigurationTab.defaultConfigIni"));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fGenerateFileButton.setLayoutData((Object)gd);
        this.fGenerateFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ConfigurationTab.this.fGenerateFileButton.getSelection();
                ConfigurationTab.this.fTemplateLocationLabel.setEnabled(!selected);
                ConfigurationTab.this.fTemplateLocationText.setEnabled(!selected);
                ConfigurationTab.this.fTemplateLocationBrowse.setEnabled(!selected);
                ConfigurationTab.this.updateStatus();
            }
        });
        this.fUseTemplateButton = new Button((Composite)group, 16);
        this.fUseTemplateButton.setText(PDEPlugin.getResourceString("ConfigurationTab.existingConfigIni"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fUseTemplateButton.setLayoutData((Object)gd);
        this.fTemplateLocationLabel = new Label((Composite)group, 0);
        this.fTemplateLocationLabel.setText(PDEPlugin.getResourceString("ConfigurationTab.templateLoc"));
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.fTemplateLocationLabel.setLayoutData((Object)gd);
        this.fTemplateLocationText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        gd.widthHint = 300;
        this.fTemplateLocationText.setLayoutData((Object)gd);
        this.fTemplateLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ConfigurationTab.this.fBlockChanges) {
                    ConfigurationTab.this.updateStatus();
                }
            }
        });
        this.fTemplateLocationBrowse = new Button((Composite)group, 8);
        this.fTemplateLocationBrowse.setText(PDEPlugin.getResourceString("ConfigurationTab.templateBrowse"));
        this.fTemplateLocationBrowse.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fTemplateLocationBrowse);
        this.fTemplateLocationBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationTab.this.handleBrowseWorkspaceFile();
            }
        });
    }

    protected void handleBrowseWorkspaceFile() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getControl().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        IFile file = PDEPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.fTemplateLocationText.getText()));
        if (file != null) {
            dialog.setInitialSelection((Object)file);
        }
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return ((IFile)element).getName().equals("config.ini");
                }
                return true;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEPlugin.getResourceString("ConfigurationTab.fileSelection"));
        dialog.setMessage(PDEPlugin.getResourceString("ConfigurationTab.fileDialogMessage"));
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] instanceof IFile) {
                    return new Status(0, PDEPlugin.getPluginId(), 0, "", null);
                }
                return new Status(4, PDEPlugin.getPluginId(), 4, "", null);
            }
        });
        if (dialog.open() == 0) {
            file = (IFile)dialog.getFirstResult();
            this.fTemplateLocationText.setText(file.getLocation().toOSString());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("useDefaultConfigArea", true);
        configuration.setAttribute("configLocation", "");
        configuration.setAttribute("clearConfig", false);
        configuration.setAttribute("useDefaultConfig", true);
        configuration.setAttribute("templateConfig", "");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            try {
                this.fBlockChanges = true;
                boolean useDefaultArea = configuration.getAttribute("useDefaultConfigArea", true);
                this.fUseDefaultLocationButton.setSelection(useDefaultArea);
                this.fConfigAreaLabel.setEnabled(!useDefaultArea);
                this.fConfigAreaText.setEnabled(!useDefaultArea);
                this.fConfigAreaBrowse.setEnabled(!useDefaultArea);
                this.fClearConfig.setSelection(configuration.getAttribute("clearConfig", false));
                this.fConfigName = configuration.getName();
                this.fLastEnteredConfigArea = configuration.getAttribute("configLocation", "");
                if (useDefaultArea) {
                    this.fConfigAreaText.setText(PDECore.getDefault().getStateLocation().append(configuration.getName()).toOSString());
                } else {
                    this.fConfigAreaText.setText(this.fLastEnteredConfigArea);
                }
                boolean generateDefault = configuration.getAttribute("useDefaultConfig", true);
                this.fGenerateFileButton.setSelection(generateDefault);
                this.fUseTemplateButton.setSelection(!generateDefault);
                this.fTemplateLocationLabel.setEnabled(!generateDefault);
                this.fTemplateLocationText.setEnabled(!generateDefault);
                this.fTemplateLocationBrowse.setEnabled(!generateDefault);
                this.fTemplateLocationText.setText(configuration.getAttribute("templateConfig", ""));
            }
            catch (CoreException coreException) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.fBlockChanges = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.fBlockChanges = false;
            this.updateStatus();
            return;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("useDefaultConfigArea", this.fUseDefaultLocationButton.getSelection());
        if (!this.fUseDefaultLocationButton.getSelection()) {
            this.fLastEnteredConfigArea = this.fConfigAreaText.getText().trim();
            configuration.setAttribute("configLocation", this.fLastEnteredConfigArea);
        }
        configuration.setAttribute("clearConfig", this.fClearConfig.getSelection());
        configuration.setAttribute("useDefaultConfig", this.fGenerateFileButton.getSelection());
        if (!this.fGenerateFileButton.getSelection()) {
            configuration.setAttribute("templateConfig", this.fTemplateLocationText.getText().trim());
        }
    }

    public String getName() {
        return PDEPlugin.getResourceString("ConfigurationTab.name");
    }

    public Image getImage() {
        return this.fImage;
    }

    public void dispose() {
        if (this.fImage != null) {
            this.fImage.dispose();
        }
    }
}

