/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.launcher.JUnitBaseLaunchConfiguration;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.build.ClasspathHelper;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.update.configurator.ConfiguratorUtils;

public class JUnitLaunchConfiguration
extends JUnitBaseLaunchConfiguration
implements ILauncherSettings {
    protected static final String KEY_NO_STARTUP = "WorkbenchLauncherConfigurationDelegate.noStartup";
    public static final String CORE_APPLICATION = "org.eclipse.pde.junit.runtime.coretestapplication";
    public static final String UI_APPLICATION = "org.eclipse.pde.junit.runtime.uitestapplication";
    public static final String LEGACY_UI_APPLICATION = "org.eclipse.pde.junit.runtime.legacyUItestapplication";
    protected static IPluginModelBase[] registryPlugins;
    protected File fConfigDir = null;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            IType[] testTypes;
            this.fConfigDir = null;
            monitor.beginTask("", 6);
            IJavaProject javaProject = this.getJavaProject(configuration);
            if (javaProject == null || !javaProject.exists()) {
                this.abort(PDEPlugin.getResourceString("JUnitLaunchConfiguration.error.invalidproject"), null, 107);
            }
            if ((testTypes = this.getTestTypes(configuration, javaProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1))).length == 0) {
                this.abort(PDEPlugin.getResourceString("JUnitLaunchConfiguration.error.notests"), null, 101);
            }
            monitor.worked(1);
            String workspace = configuration.getAttribute("location0", this.getDefaultWorkspace(configuration));
            if (!LauncherUtils.clearWorkspace(configuration, workspace, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                monitor.setCanceled(true);
                return;
            }
            if (configuration.getAttribute("clearConfig", false)) {
                LauncherUtils.clearConfigArea(this.getConfigDir(configuration), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            launch.setAttribute("configLocation", this.getConfigDir(configuration).toString());
            IVMInstall launcher = LauncherUtils.createLauncher(configuration);
            monitor.worked(1);
            int port = SocketUtil.findFreePort();
            VMRunnerConfiguration runnerConfig = this.createVMRunner(configuration, testTypes, port, mode);
            if (runnerConfig == null) {
                monitor.setCanceled(true);
                return;
            }
            monitor.worked(1);
            this.setDefaultSourceLocator(launch, configuration);
            LauncherUtils.synchronizeManifests(configuration, this.getConfigDir(configuration));
            launch.setAttribute("org.eclipse.jdt.junit.PORT", Integer.toString(port));
            launch.setAttribute("org.eclipse.jdt.junit.TESTTYPE", testTypes[0].getHandleIdentifier());
            PDEPlugin.getDefault().getLaunchListener().manage(launch);
            launcher.getVMRunner(mode).run(runnerConfig, launch, monitor);
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }

    protected VMRunnerConfiguration createVMRunner(ILaunchConfiguration configuration, IType[] testTypes, int port, String runMode) throws CoreException {
        String[] programArgs;
        String[] classpath = LauncherUtils.constructClasspath(configuration);
        if (classpath == null) {
            this.abort(PDEPlugin.getResourceString(KEY_NO_STARTUP), null, 0);
        }
        if ((programArgs = this.computeProgramArguments(configuration, testTypes, port, runMode)) == null) {
            return null;
        }
        String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        VMRunnerConfiguration runnerConfig = new VMRunnerConfiguration("org.eclipse.core.launcher.Main", classpath);
        runnerConfig.setVMArguments(this.computeVMArguments(configuration));
        runnerConfig.setProgramArguments(programArgs);
        runnerConfig.setEnvironment(envp);
        runnerConfig.setVMSpecificAttributesMap(LauncherUtils.getVMSpecificAttributes(configuration));
        return runnerConfig;
    }

    protected String getTestPluginId(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(javaProject.getProject());
        if (model == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", 4, PDEPlugin.getResourceString("JUnitLaunchConfiguration.error.notaplugin"), null));
        }
        if (model instanceof IFragmentModel) {
            return ((IFragmentModel)model).getFragment().getPluginId();
        }
        return model.getPluginBase().getId();
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", code, message, exception));
    }

    protected String[] computeProgramArguments(ILaunchConfiguration configuration, IType[] testTypes, int port, String runMode) throws CoreException {
        String testName;
        IPluginModelBase bootModel;
        String bootPath;
        ArrayList<String> programArgs = new ArrayList<String>();
        TreeMap pluginMap = LauncherUtils.getPluginsToRun(configuration);
        if (pluginMap == null) {
            return null;
        }
        this.addRequiredPlugins(pluginMap);
        programArgs.add("-version");
        programArgs.add("3");
        programArgs.add("-application");
        programArgs.add(this.getApplicationName(pluginMap, configuration));
        if (configuration.getAttribute("useProduct", false)) {
            programArgs.add("-product");
            programArgs.add(configuration.getAttribute("product", ""));
        } else {
            String testApplication = configuration.getAttribute("testApplication", null);
            if (testApplication != null && testApplication.length() > 0) {
                programArgs.add("-testApplication");
                programArgs.add(testApplication);
            }
        }
        String targetWorkspace = configuration.getAttribute("location0", this.getDefaultWorkspace(configuration));
        programArgs.add("-data");
        programArgs.add(targetWorkspace);
        String brandingPlugin = LauncherUtils.getBrandingPluginID(configuration);
        if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            LauncherUtils.createConfigIniFile(configuration, brandingPlugin, pluginMap, this.getConfigDir(configuration));
        }
        TargetPlatform.createPlatformConfigurationArea((Map)pluginMap, (File)this.getConfigDir(configuration), (String)brandingPlugin);
        programArgs.add("-configuration");
        if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            programArgs.add("file:" + new Path(this.getConfigDir(configuration).getPath()).addTrailingSeparator().toString());
        } else {
            programArgs.add("file:" + new Path(this.getConfigDir(configuration).getPath()).append("platform.cfg").toString());
        }
        if (!PDECore.getDefault().getModelManager().isOSGiRuntime() && (bootPath = LauncherUtils.getBootPath(bootModel = (IPluginModelBase)pluginMap.get("org.eclipse.core.boot"))) != null && !bootPath.endsWith(".jar")) {
            programArgs.add("-boot");
            programArgs.add("file:" + bootPath);
        }
        programArgs.add("-dev");
        if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            programArgs.add(ClasspathHelper.getDevEntriesProperties(String.valueOf(this.getConfigDir(configuration).toString()) + "/dev.properties", true));
        } else {
            programArgs.add(ClasspathHelper.getDevEntries(true));
        }
        programArgs.add("-pdelaunch");
        if (configuration.getAttribute("tracing", false) && !"[NONE]".equals(configuration.getAttribute("checked", null))) {
            programArgs.add("-debug");
            String path = String.valueOf(this.getConfigDir(configuration).getPath()) + '/' + ".options";
            programArgs.add(LauncherUtils.getTracingFileArgument(configuration, path));
        }
        StringTokenizer tokenizer = new StringTokenizer(configuration.getAttribute("progargs", ""));
        while (tokenizer.hasMoreTokens()) {
            programArgs.add(tokenizer.nextToken());
        }
        if (!programArgs.contains("-os")) {
            programArgs.add("-os");
            programArgs.add(TargetPlatform.getOS());
        }
        if (!programArgs.contains("-ws")) {
            programArgs.add("-ws");
            programArgs.add(TargetPlatform.getWS());
        }
        if (!programArgs.contains("-arch")) {
            programArgs.add("-arch");
            programArgs.add(TargetPlatform.getOSArch());
        }
        if (!programArgs.contains("-nl")) {
            programArgs.add("-nl");
            programArgs.add(TargetPlatform.getNL());
        }
        if (this.keepAlive(configuration) && runMode.equals("debug")) {
            programArgs.add("-keepalive");
        }
        programArgs.add("-port");
        programArgs.add(Integer.toString(port));
        programArgs.add("-testpluginname");
        programArgs.add(this.getTestPluginId(configuration));
        String testFailureNames = configuration.getAttribute("org.eclipse.jdt.junit.FAILURENAMES", "");
        if (testFailureNames.length() > 0) {
            programArgs.add("-testfailures");
            programArgs.add(testFailureNames);
        }
        if ((testName = configuration.getAttribute("org.eclipse.jdt.junit.TESTNAME", "")).length() > 0) {
            programArgs.add("-test");
            programArgs.add(String.valueOf(testTypes[0].getFullyQualifiedName()) + ":" + testName);
        } else {
            programArgs.add("-classnames");
            int i = 0;
            while (i < testTypes.length) {
                programArgs.add(testTypes[i].getFullyQualifiedName());
                ++i;
            }
        }
        return programArgs.toArray(new String[programArgs.size()]);
    }

    protected IPluginModelBase[] addRequiredPlugins(TreeMap pluginMap) throws CoreException {
        if (!pluginMap.containsKey("org.eclipse.pde.junit.runtime")) {
            pluginMap.put("org.eclipse.pde.junit.runtime", this.findPlugin("org.eclipse.pde.junit.runtime"));
        }
        if (!pluginMap.containsKey("org.eclipse.jdt.junit.runtime")) {
            pluginMap.put("org.eclipse.jdt.junit.runtime", this.findPlugin("org.eclipse.jdt.junit.runtime"));
        }
        if (!pluginMap.containsKey("org.junit")) {
            pluginMap.put("org.junit", this.findPlugin("org.junit"));
        }
        return pluginMap.values().toArray(new IPluginModelBase[pluginMap.size()]);
    }

    protected IPluginModelBase findPlugin(String id) throws CoreException {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        IPluginModelBase model = manager.findModel(id);
        if (model != null) {
            return model;
        }
        if (registryPlugins == null) {
            URL[] pluginPaths = ConfiguratorUtils.getCurrentPlatformConfiguration().getPluginPath();
            PDEState state = new PDEState(pluginPaths, false, (IProgressMonitor)new NullProgressMonitor());
            registryPlugins = state.getModels();
        }
        int i = 0;
        while (i < registryPlugins.length) {
            if (registryPlugins[i].getPluginBase().getId().equals(id)) {
                return registryPlugins[i];
            }
            ++i;
        }
        this.abort(PDEPlugin.getFormattedMessage("JUnitLaunchConfiguration.error.missingPlugin", id), null, 0);
        return null;
    }

    protected String[] computeVMArguments(ILaunchConfiguration configuration) throws CoreException {
        return new ExecutionArguments(this.getVMArguments(configuration), "").getVMArgumentsArray();
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("progargs", "");
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("vmargs", "");
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        LauncherUtils.setDefaultSourceLocator(configuration, launch);
    }

    protected String getDefaultWorkspace(ILaunchConfiguration config) throws CoreException {
        if (config.getAttribute("application", UI_APPLICATION).equals(UI_APPLICATION)) {
            return LauncherUtils.getDefaultPath().append("junit-workbench-workspace").toOSString();
        }
        return LauncherUtils.getDefaultPath().append("junit-core-workspace").toOSString();
    }

    protected String getApplicationName(TreeMap pluginMap, ILaunchConfiguration configuration) {
        try {
            String application = configuration.getAttribute("application", null);
            if (CORE_APPLICATION.equals(application) || !JUnitLaunchConfiguration.requiresUI(configuration)) {
                return CORE_APPLICATION;
            }
        }
        catch (CoreException coreException) {}
        IPluginModelBase model = (IPluginModelBase)pluginMap.get("org.eclipse.ui");
        if (model != null) {
            IPluginExtension[] extensions = model.getPluginBase().getExtensions();
            int i = 0;
            while (i < extensions.length) {
                String point = extensions[i].getPoint();
                if (point != null && point.equals("org.eclipse.core.runtime.applications") && "workbench".equals(extensions[i].getId())) {
                    return LEGACY_UI_APPLICATION;
                }
                ++i;
            }
        }
        return UI_APPLICATION;
    }

    public static String getPluginID(ILaunchConfiguration configuration) {
        try {
            IPluginModelBase model;
            IResource project;
            String projectID = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            if (projectID.length() > 0 && (project = PDEPlugin.getWorkspace().getRoot().findMember(projectID)) != null && project instanceof IProject && (model = PDECore.getDefault().getModelManager().findModel((IProject)project)) != null) {
                return model.getPluginBase().getId();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static boolean requiresUI(ILaunchConfiguration configuration) {
        String id = JUnitLaunchConfiguration.getPluginID(configuration);
        if (id != null) {
            IPluginModelBase[] models = JUnitLaunchConfiguration.getPluginAndPrereqs(id);
            int i = 0;
            while (i < models.length) {
                if ("org.eclipse.swt".equals(models[i].getPluginBase().getId())) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public static IPluginModelBase[] getPluginAndPrereqs(String id) {
        TreeMap map = new TreeMap();
        JUnitLaunchConfiguration.addPluginAndPrereqs(id, map);
        if (!PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            JUnitLaunchConfiguration.addPluginAndPrereqs("org.eclipse.core.boot", map);
            JUnitLaunchConfiguration.addPluginAndPrereqs("org.eclipse.core.runtime", map);
        }
        return map.values().toArray(new IPluginModelBase[map.size()]);
    }

    protected static void addPluginAndPrereqs(String id, TreeMap map) {
        if (map.containsKey(id)) {
            return;
        }
        ModelEntry entry = PDECore.getDefault().getModelManager().findEntry(id);
        if (entry == null) {
            return;
        }
        IPluginModelBase model = entry.getActiveModel();
        map.put(id, model);
        IPluginImport[] imports = model.getPluginBase().getImports();
        int i = 0;
        while (i < imports.length) {
            JUnitLaunchConfiguration.addPluginAndPrereqs(imports[i].getId(), map);
            ++i;
        }
        if (model instanceof IFragmentModel) {
            JUnitLaunchConfiguration.addPluginAndPrereqs(((IFragmentModel)model).getFragment().getPluginId(), map);
        } else {
            IFragment[] fragments = PDECore.getDefault().findFragmentsFor(id, model.getPluginBase().getVersion());
            int i2 = 0;
            while (i2 < fragments.length) {
                JUnitLaunchConfiguration.addPluginAndPrereqs(fragments[i2].getId(), map);
                ++i2;
            }
        }
    }

    protected File getConfigDir(ILaunchConfiguration config) {
        if (this.fConfigDir == null) {
            this.fConfigDir = LauncherUtils.createConfigArea(config);
        }
        if (!this.fConfigDir.exists()) {
            this.fConfigDir.mkdirs();
        }
        return this.fConfigDir;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.computeBuildOrder(LauncherUtils.getAffectedProjects(configuration));
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return LauncherUtils.getAffectedProjects(configuration);
    }
}

