/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.ApplicationSelectionDialog;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class RuntimeWorkbenchShortcut
implements ILaunchShortcut {
    private static final String CLASSPATH_PROVIDER = "org.eclipse.pde.ui.workbenchClasspathProvider";
    private static final String CONFIGURATION_TYPE = "org.eclipse.pde.ui.RuntimeWorkbench";
    private IPluginModelBase fModel = null;
    static /* synthetic */ Class class$0;

    public void run() {
        this.launch("run", null);
    }

    public void debug() {
        this.launch("debug", null);
    }

    public void run(IPluginModelBase model) {
        this.launch(model, "run");
    }

    public void debug(IPluginModelBase model) {
        this.launch(model, "debug");
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch(mode, null);
    }

    public void launch(ISelection selection, String mode) {
        this.launch(this.getSelectedModel(selection), mode);
    }

    private void launch(IPluginModelBase model, String mode) {
        this.fModel = model;
        if (this.fModel != null) {
            String[] applicationNames = this.getAvailableApplications();
            if (applicationNames.length == 0) {
                this.launch(mode, null);
            } else if (applicationNames.length == 1) {
                this.launch(mode, applicationNames[0]);
            } else {
                ApplicationSelectionDialog dialog = new ApplicationSelectionDialog(PDEPlugin.getActiveWorkbenchShell().getShell(), applicationNames, mode);
                if (dialog.open() == 0) {
                    this.launch(mode, dialog.getSelectedApplication());
                }
            }
        } else {
            this.launch(mode, null);
        }
    }

    private IPluginModelBase getSelectedModel(ISelection selection) {
        Object object;
        IStructuredSelection ssel;
        if (selection instanceof IStructuredSelection && !(ssel = (IStructuredSelection)selection).isEmpty() && (object = ssel.getFirstElement()) instanceof IAdaptable) {
            IProject project;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((project = (IProject)iAdaptable.getAdapter((Class)clazz)) != null && project.isOpen()) {
                return PDECore.getDefault().getWorkspaceModelManager().getWorkspacePluginModel(project);
            }
        }
        return null;
    }

    private String[] getAvailableApplications() {
        IPluginBase plugin = this.fModel.getPluginBase();
        String id = plugin.getId();
        if (id == null || id.trim().length() == 0) {
            return new String[0];
        }
        IPluginExtension[] extensions = plugin.getExtensions();
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < extensions.length) {
            String extensionID;
            IPluginExtension extension = extensions[i];
            if ("org.eclipse.core.runtime.applications".equals(extension.getPoint()) && (extensionID = extension.getId()) != null && extensionID.trim().length() > 0) {
                result.add(String.valueOf(id.trim()) + "." + extensionID.trim());
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    protected void launch(String mode, String applicationName) {
        ILaunchConfiguration config = this.findLaunchConfiguration(mode, applicationName);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(String mode, String applicationName) {
        ILaunchConfiguration[] configs = this.getLaunchConfigurations(this.getWorkbenchLaunchConfigType(), applicationName);
        if (configs.length == 0) {
            return this.createConfiguration(applicationName);
        }
        if (configs.length == 1) {
            return configs[0];
        }
        return this.chooseConfiguration(configs, mode);
    }

    private ILaunchConfiguration[] getLaunchConfigurations(ILaunchConfigurationType configType, String applicationName) {
        ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configType);
            int i = 0;
            while (i < configs.length) {
                if (!DebugUITools.isPrivate((ILaunchConfiguration)configs[i])) {
                    if (!configs[i].getAttribute("useProduct", false)) {
                        String configApp = configs[i].getAttribute("application", null);
                        if (configApp == null && applicationName == null || configApp != null && applicationName != null && configApp.equals(applicationName)) {
                            result.add(configs[i]);
                        }
                    } else {
                        String thisProduct = configs[i].getAttribute("product", null);
                        if (thisProduct != null && thisProduct.equals(this.getProduct(applicationName))) {
                            result.add(configs[i]);
                        }
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return result.toArray(new ILaunchConfiguration[result.size()]);
    }

    protected ILaunchConfiguration chooseConfiguration(ILaunchConfiguration[] configs, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements((Object[])configs);
        dialog.setTitle(PDEPlugin.getResourceString("RuntimeWorkbenchShortcut.title"));
        if (mode.equals("debug")) {
            dialog.setMessage(PDEPlugin.getResourceString("RuntimeWorkbenchShortcut.select.debug"));
        } else {
            dialog.setMessage(PDEPlugin.getResourceString("RuntimeWorkbenchShortcut.select.run"));
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(String applicationName) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getWorkbenchLaunchConfigType();
            String computedName = this.getComputedName(configType.getName());
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, computedName);
            wc.setAttribute("location0", this.getDefaultWorkspaceLocation(computedName));
            wc.setAttribute("vmargs", "");
            wc.setAttribute("progargs", "");
            wc.setAttribute("usefeatures", false);
            wc.setAttribute("clearws", false);
            wc.setAttribute("askclear", true);
            wc.setAttribute("default", applicationName == null);
            if (applicationName != null) {
                String product = this.getProduct(applicationName);
                if (product == null) {
                    wc.setAttribute("application", applicationName);
                } else {
                    wc.setAttribute("useProduct", true);
                    wc.setAttribute("product", product);
                }
                wc.setAttribute("automaticAdd", false);
                TreeMap map = new TreeMap();
                this.addPluginAndDependencies(this.fModel, map);
                Object[] models = map.values().toArray();
                StringBuffer wsplugins = new StringBuffer();
                StringBuffer explugins = new StringBuffer();
                int i = 0;
                while (i < models.length) {
                    IPluginModelBase model = (IPluginModelBase)models[i];
                    String id = model.getPluginBase().getId();
                    if (model.getUnderlyingResource() == null) {
                        explugins.append(String.valueOf(id) + File.pathSeparatorChar);
                    } else {
                        wsplugins.append(String.valueOf(id) + File.pathSeparatorChar);
                    }
                    ++i;
                }
                wc.setAttribute("wsproject", wsplugins.toString());
                wc.setAttribute("extplugins", explugins.toString());
            }
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, CLASSPATH_PROVIDER);
            config = wc.doSave();
        }
        catch (CoreException ce) {
            PDEPlugin.logException(ce);
        }
        return config;
    }

    private String getProduct(String appName) {
        if (this.fModel != null && appName != null) {
            IPluginExtension[] extensions = this.fModel.getPluginBase().getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IPluginAttribute attr;
                IPluginElement prod;
                IPluginExtension ext = extensions[i];
                String point = ext.getPoint();
                if ("org.eclipse.core.runtime.products".equals(point) && ext.getChildCount() == 1 && (prod = (IPluginElement)ext.getChildren()[0]).getName().equals("product") && (attr = prod.getAttribute("application")) != null && appName.equals(attr.getValue())) {
                    return String.valueOf(this.fModel.getPluginBase().getId()) + "." + ext.getId();
                }
                ++i;
            }
        }
        return null;
    }

    protected ILaunchConfigurationType getWorkbenchLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType(CONFIGURATION_TYPE);
    }

    private String getComputedName(String prefix) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.generateUniqueLaunchConfigurationNameFrom(prefix);
    }

    protected Shell getShell() {
        return PDEPlugin.getActiveWorkbenchShell();
    }

    private String getDefaultWorkspaceLocation(String uniqueName) {
        return LauncherUtils.getDefaultPath().append("runtime-" + uniqueName.replaceAll("\\s", "")).toOSString();
    }

    private void addPluginAndDependencies(IPluginModelBase model, TreeMap map) {
        if (model == null) {
            return;
        }
        String id = model.getPluginBase().getId();
        if (map.containsKey(id)) {
            return;
        }
        map.put(id, model);
        if (model instanceof IFragmentModel) {
            IPluginModelBase parent = this.findPlugin(((IFragmentModel)model).getFragment().getPluginId());
            this.addPluginAndDependencies(parent, map);
        } else {
            boolean addFragments = false;
            IPluginLibrary[] libs = model.getPluginBase().getLibraries();
            int i = 0;
            while (i < libs.length) {
                if (ClasspathUtilCore.containsVariables((String)libs[i].getName())) {
                    addFragments = true;
                    break;
                }
                ++i;
            }
            if (addFragments) {
                IFragmentModel[] fragments = this.findFragments(model.getPluginBase());
                int i2 = 0;
                while (i2 < fragments.length) {
                    this.addPluginAndDependencies((IPluginModelBase)fragments[i2], map);
                    ++i2;
                }
            }
        }
        IPluginImport[] imports = model.getPluginBase().getImports();
        int i = 0;
        while (i < imports.length) {
            this.addPluginAndDependencies(this.findPlugin(imports[i].getId()), map);
            ++i;
        }
    }

    private IPluginModelBase findPlugin(String id) {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        ModelEntry entry = manager.findEntry(id);
        return entry != null ? entry.getActiveModel() : null;
    }

    private IFragmentModel[] findFragments(IPluginBase plugin) {
        ModelEntry[] entries = PDECore.getDefault().getModelManager().getEntries();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < entries.length) {
            String id;
            ModelEntry entry = entries[i];
            IPluginModelBase model = entry.getActiveModel();
            if (model instanceof IFragmentModel && (id = ((IFragmentModel)model).getFragment().getPluginId()).equals(plugin.getId())) {
                result.add(model);
            }
            ++i;
        }
        return result.toArray(new IFragmentModel[result.size()]);
    }
}

