/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.build.ClasspathHelper;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

public class WorkbenchLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements ILauncherSettings {
    protected static final String KEY_BAD_FEATURE_SETUP = "WorkbenchLauncherConfigurationDelegate.badFeatureSetup";
    protected static final String KEY_NO_STARTUP = "WorkbenchLauncherConfigurationDelegate.noStartup";
    protected File fConfigDir = null;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.fConfigDir = null;
            monitor.beginTask("", 5);
            String workspace = configuration.getAttribute("location0", LauncherUtils.getDefaultPath().append("runtime-workbench-workspace").toOSString());
            if (!LauncherUtils.clearWorkspace(configuration, workspace, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                monitor.setCanceled(true);
                return;
            }
            if (configuration.getAttribute("clearConfig", false)) {
                LauncherUtils.clearConfigArea(this.getConfigDir(configuration), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            launch.setAttribute("configLocation", this.getConfigDir(configuration).toString());
            IVMInstall launcher = LauncherUtils.createLauncher(configuration);
            monitor.worked(1);
            VMRunnerConfiguration runnerConfig = this.createVMRunner(configuration);
            if (runnerConfig == null) {
                monitor.setCanceled(true);
                return;
            }
            monitor.worked(1);
            LauncherUtils.setDefaultSourceLocator(configuration, launch);
            LauncherUtils.synchronizeManifests(configuration, this.getConfigDir(configuration));
            PDEPlugin.getDefault().getLaunchListener().manage(launch);
            launcher.getVMRunner(mode).run(runnerConfig, launch, monitor);
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }

    protected VMRunnerConfiguration createVMRunner(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = LauncherUtils.constructClasspath(configuration);
        if (classpath == null) {
            String message = PDEPlugin.getResourceString(KEY_NO_STARTUP);
            throw new CoreException(LauncherUtils.createErrorStatus(message));
        }
        String[] programArgs = this.getProgramArguments(configuration);
        if (programArgs == null) {
            return null;
        }
        String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        VMRunnerConfiguration runnerConfig = new VMRunnerConfiguration("org.eclipse.core.launcher.Main", classpath);
        runnerConfig.setVMArguments(this.getVMArguments(configuration));
        runnerConfig.setProgramArguments(programArgs);
        runnerConfig.setEnvironment(envp);
        runnerConfig.setVMSpecificAttributesMap(LauncherUtils.getVMSpecificAttributes(configuration));
        return runnerConfig;
    }

    protected String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> programArgs = new ArrayList<String>();
        if (configuration.getAttribute("useProduct", false)) {
            programArgs.add("-product");
            programArgs.add(configuration.getAttribute("product", ""));
        } else {
            programArgs.add("-application");
            programArgs.add(configuration.getAttribute("application", LauncherUtils.getDefaultApplicationName()));
        }
        String targetWorkspace = configuration.getAttribute("location0", LauncherUtils.getDefaultPath().append("runtime-workbench-workspace").toOSString());
        programArgs.add("-data");
        programArgs.add(targetWorkspace);
        boolean isOSGI = PDECore.getDefault().getModelManager().isOSGiRuntime();
        boolean showSplash = true;
        if (configuration.getAttribute("usefeatures", false)) {
            this.validateFeatures();
            IPath installPath = PDEPlugin.getWorkspace().getRoot().getLocation();
            programArgs.add("-install");
            programArgs.add("file:" + installPath.removeLastSegments(1).addTrailingSeparator().toString());
            if (isOSGI && !configuration.getAttribute("useDefaultConfigArea", true)) {
                programArgs.add("-configuration");
                programArgs.add("file:" + new Path(this.getConfigDir(configuration).getPath()).addTrailingSeparator().toString());
            }
            programArgs.add("-update");
        } else {
            TreeMap pluginMap = LauncherUtils.getPluginsToRun(configuration);
            if (pluginMap == null) {
                return null;
            }
            String brandingPlugin = LauncherUtils.getBrandingPluginID(configuration);
            if (isOSGI) {
                Properties prop = LauncherUtils.createConfigIniFile(configuration, brandingPlugin, pluginMap, this.getConfigDir(configuration));
                showSplash = prop.containsKey("osgi.splashPath") || prop.containsKey("splashLocation");
            }
            TargetPlatform.createPlatformConfigurationArea((Map)pluginMap, (File)this.getConfigDir(configuration), (String)brandingPlugin);
            programArgs.add("-configuration");
            if (isOSGI) {
                programArgs.add("file:" + new Path(this.getConfigDir(configuration).getPath()).addTrailingSeparator().toString());
            } else {
                programArgs.add("file:" + new Path(this.getConfigDir(configuration).getPath()).append("platform.cfg").toString());
            }
            if (!isOSGI) {
                IPluginModelBase bootModel;
                String bootPath;
                if (brandingPlugin != null) {
                    programArgs.add("-feature");
                    programArgs.add(brandingPlugin);
                }
                if ((bootPath = LauncherUtils.getBootPath(bootModel = (IPluginModelBase)pluginMap.get("org.eclipse.core.boot"))) != null && !bootPath.endsWith(".jar")) {
                    programArgs.add("-boot");
                    programArgs.add("file:" + bootPath);
                }
            }
        }
        programArgs.add("-dev");
        if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            programArgs.add(ClasspathHelper.getDevEntriesProperties(String.valueOf(this.getConfigDir(configuration).toString()) + "/dev.properties", true));
        } else {
            programArgs.add(ClasspathHelper.getDevEntries(true));
        }
        programArgs.add("-pdelaunch");
        if (configuration.getAttribute("tracing", false) && !"[NONE]".equals(configuration.getAttribute("checked", null))) {
            programArgs.add("-debug");
            programArgs.add(LauncherUtils.getTracingFileArgument(configuration, String.valueOf(this.getConfigDir(configuration).toString()) + '/' + ".options"));
        }
        StringTokenizer tokenizer = new StringTokenizer(configuration.getAttribute("progargs", ""));
        while (tokenizer.hasMoreTokens()) {
            programArgs.add(tokenizer.nextToken());
        }
        if (!programArgs.contains("-nosplash") && showSplash) {
            programArgs.add(0, "-showsplash");
            programArgs.add(1, this.computeShowsplashArgument());
        }
        if (!programArgs.contains("-os")) {
            programArgs.add("-os");
            programArgs.add(TargetPlatform.getOS());
        }
        if (!programArgs.contains("-ws")) {
            programArgs.add("-ws");
            programArgs.add(TargetPlatform.getWS());
        }
        if (!programArgs.contains("-arch")) {
            programArgs.add("-arch");
            programArgs.add(TargetPlatform.getOSArch());
        }
        if (!programArgs.contains("-nl")) {
            programArgs.add("-nl");
            programArgs.add(TargetPlatform.getNL());
        }
        return programArgs.toArray(new String[programArgs.size()]);
    }

    protected String[] getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        return new ExecutionArguments(configuration.getAttribute("vmargs", ""), "").getVMArgumentsArray();
    }

    protected void validateFeatures() throws CoreException {
        boolean badStructure;
        IPath installPath = PDEPlugin.getWorkspace().getRoot().getLocation();
        String lastSegment = installPath.lastSegment();
        boolean bl = badStructure = lastSegment == null;
        if (!badStructure) {
            IPath featuresPath = installPath.removeLastSegments(1).append("features");
            boolean bl2 = badStructure = !lastSegment.equalsIgnoreCase("plugins") || !featuresPath.toFile().exists();
        }
        if (badStructure) {
            throw new CoreException(LauncherUtils.createErrorStatus(PDEPlugin.getResourceString(KEY_BAD_FEATURE_SETUP)));
        }
        this.ensureProductFilesExist(this.getProductPath());
    }

    protected IPath getInstallPath() {
        return PDEPlugin.getWorkspace().getRoot().getLocation();
    }

    protected IPath getProductPath() {
        return this.getInstallPath().removeLastSegments(1);
    }

    protected String computeShowsplashArgument() {
        IPath eclipseHome = ExternalModelManager.getEclipseHome();
        IPath fullPath = eclipseHome.append("eclipse");
        return String.valueOf(fullPath.toOSString()) + " -showsplash 600";
    }

    protected void ensureProductFilesExist(IPath productArea) {
        File productDir = productArea.toFile();
        File marker = new File(productDir, ".eclipseproduct");
        IPath eclipsePath = ExternalModelManager.getEclipseHome();
        if (!marker.exists()) {
            this.copyFile(eclipsePath, ".eclipseproduct", marker);
        }
        if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            File ini;
            File configDir = new File(productDir, "configuration");
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            if (!(ini = new File(configDir, "config.ini")).exists()) {
                this.copyFile(eclipsePath.append("configuration"), "config.ini", ini);
            }
        } else {
            File ini = new File(productDir, "install.ini");
            if (!ini.exists()) {
                this.copyFile(eclipsePath, "install.ini", ini);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void copyFile(IPath eclipsePath, String name, File target) {
        File source = new File(eclipsePath.toFile(), name);
        if (!source.exists()) {
            return;
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            try {
                is = new FileInputStream(source);
                os = new FileOutputStream(target);
                byte[] buf = new byte[1024];
                long currentLen = 0L;
                int len = is.read(buf);
                while (len != -1) {
                    currentLen += (long)len;
                    os.write(buf, 0, len);
                    len = is.read(buf);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (is != null) {
                    is.close();
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var11_12 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (is != null) {
            is.close();
        }
        if (os == null) return;
        os.close();
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.computeBuildOrder(LauncherUtils.getAffectedProjects(configuration));
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return LauncherUtils.getAffectedProjects(configuration);
    }

    protected File getConfigDir(ILaunchConfiguration config) {
        if (this.fConfigDir == null) {
            try {
                if (config.getAttribute("usefeatures", false) && config.getAttribute("useDefaultConfigArea", true)) {
                    String root = this.getProductPath().toString();
                    if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
                        root = String.valueOf(root) + "/configuration";
                    }
                    this.fConfigDir = new File(root);
                } else {
                    this.fConfigDir = LauncherUtils.createConfigArea(config);
                }
            }
            catch (CoreException coreException) {
                this.fConfigDir = LauncherUtils.createConfigArea(config);
            }
        }
        if (!this.fConfigDir.exists()) {
            this.fConfigDir.mkdirs();
        }
        return this.fConfigDir;
    }
}

