/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.internal.core.IEnvironmentVariables;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class EnvironmentBlock
implements IEnvironmentVariables {
    public static final String KEY_OS = "Preferences.TargetEnvironmentPage.os";
    public static final String KEY_WS = "Preferences.TargetEnvironmentPage.ws";
    public static final String KEY_NL = "Preferences.TargetEnvironmentPage.nl";
    public static final String KEY_ARCH = "Preferences.TargetEnvironmentPage.arch";
    private Combo fOSCombo;
    private Combo fWSCombo;
    private Combo fNLCombo;
    private Combo fArchCombo;
    private Preferences preferences = PDECore.getDefault().getPluginPreferences();
    private TreeSet fNLChoices;
    private TreeSet fOSChoices;
    private TreeSet fWSChoices;
    private TreeSet fArchChoices;
    private Button fDefaultJREButton;
    private Combo fJRECombo;
    private Button fThisJREButton;

    private void initializeChoices() {
        this.fOSChoices = new TreeSet();
        String[] os = Platform.knownOSValues();
        int i = 0;
        while (i < os.length) {
            this.fOSChoices.add(os[i]);
            ++i;
        }
        this.addExtraChoices(this.fOSChoices, this.preferences.getString("org.eclipse.pde.os.extra"));
        this.fWSChoices = new TreeSet();
        String[] ws = Platform.knownWSValues();
        int i2 = 0;
        while (i2 < ws.length) {
            this.fWSChoices.add(ws[i2]);
            ++i2;
        }
        this.addExtraChoices(this.fWSChoices, this.preferences.getString("org.eclipse.pde.ws.extra"));
        this.fArchChoices = new TreeSet();
        String[] arch = Platform.knownOSArchValues();
        int i3 = 0;
        while (i3 < arch.length) {
            this.fArchChoices.add(arch[i3]);
            ++i3;
        }
        this.addExtraChoices(this.fArchChoices, this.preferences.getString("org.eclipse.pde.arch.extra"));
        this.fNLChoices = new TreeSet();
        String[] nl = EnvironmentBlock.getLocales();
        int i4 = 0;
        while (i4 < nl.length) {
            this.fNLChoices.add(nl[i4]);
            ++i4;
        }
        this.addExtraChoices(this.fNLChoices, this.preferences.getString("org.eclipse.pde.nl.extra"));
    }

    private void addExtraChoices(Set set, String preference) {
        StringTokenizer tokenizer = new StringTokenizer(preference);
        while (tokenizer.hasMoreTokens()) {
            set.add(tokenizer.nextToken().trim());
        }
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 20;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createTargetEnvironmentGroup(container);
        this.createJREGroup(container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.target_environment_preference_page");
        return container;
    }

    private void createJREGroup(Composite container) {
        Group group = new Group(container, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(PDEPlugin.getResourceString("EnvironmentBlock.jreGroup"));
        this.fDefaultJREButton = new Button((Composite)group, 16);
        this.fDefaultJREButton.setText(String.valueOf(PDEPlugin.getResourceString("EnvironmentBlock.defaultJRE")) + LauncherUtils.getDefaultVMInstallName() + ".");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fDefaultJREButton.setLayoutData((Object)gd);
        boolean usedefault = this.preferences.getBoolean("useDefaultJRE");
        this.fDefaultJREButton.setSelection(usedefault);
        this.fThisJREButton = new Button((Composite)group, 16);
        this.fThisJREButton.setText(PDEPlugin.getResourceString("EnvironmentBlock.thisJRE"));
        this.fThisJREButton.setSelection(!usedefault);
        this.fJRECombo = new Combo((Composite)group, 12);
        this.fJRECombo.setLayoutData((Object)new GridData(768));
        this.fJRECombo.setItems(LauncherUtils.getVMInstallNames());
        String vm = this.preferences.getString("targetJRE");
        if (vm.length() == 0 || this.fJRECombo.indexOf(vm) == -1) {
            this.fJRECombo.setText(LauncherUtils.getDefaultVMInstallName());
        } else {
            this.fJRECombo.setText(vm);
        }
        this.fJRECombo.setEnabled(!usedefault);
        this.fThisJREButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentBlock.this.fJRECombo.setEnabled(EnvironmentBlock.this.fThisJREButton.getSelection());
            }
        });
        Label label = new Label((Composite)group, 64);
        label.setText(PDEPlugin.getResourceString("EnvironmentBlock.jreNote"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 25;
        gd.widthHint = 400;
        label.setLayoutData((Object)gd);
    }

    private void createTargetEnvironmentGroup(Composite container) {
        Group group = new Group(container, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(PDEPlugin.getResourceString("EnvironmentBlock.targetEnv"));
        this.initializeChoices();
        Label label = new Label((Composite)group, 0);
        label.setText(PDEPlugin.getResourceString(KEY_OS));
        this.fOSCombo = new Combo((Composite)group, 2052);
        this.fOSCombo.setLayoutData((Object)new GridData(768));
        this.fOSCombo.setItems(this.fOSChoices.toArray(new String[this.fOSChoices.size()]));
        label = new Label((Composite)group, 0);
        label.setText(PDEPlugin.getResourceString(KEY_WS));
        this.fWSCombo = new Combo((Composite)group, 2052);
        this.fWSCombo.setLayoutData((Object)new GridData(768));
        this.fWSCombo.setItems(this.fWSChoices.toArray(new String[this.fWSChoices.size()]));
        label = new Label((Composite)group, 0);
        label.setText(PDEPlugin.getResourceString(KEY_ARCH));
        this.fArchCombo = new Combo((Composite)group, 2052);
        this.fArchCombo.setLayoutData((Object)new GridData(768));
        this.fArchCombo.setItems(this.fArchChoices.toArray(new String[this.fArchChoices.size()]));
        label = new Label((Composite)group, 0);
        label.setText(PDEPlugin.getResourceString(KEY_NL));
        this.fNLCombo = new Combo((Composite)group, 2052);
        this.fNLCombo.setLayoutData((Object)new GridData(768));
        this.fNLCombo.setItems(this.fNLChoices.toArray(new String[this.fNLChoices.size()]));
        this.fOSCombo.setText(this.preferences.getString("org.eclipse.pde.ui.os"));
        this.fWSCombo.setText(this.preferences.getString("org.eclipse.pde.ui.ws"));
        this.fNLCombo.setText(this.expandLocaleName(this.preferences.getString("org.eclipse.pde.ui.nl")));
        this.fArchCombo.setText(this.preferences.getString("org.eclipse.pde.ui.arch"));
    }

    protected void performDefaults() {
        this.fOSCombo.setText(this.preferences.getDefaultString("org.eclipse.pde.ui.os"));
        this.fWSCombo.setText(this.preferences.getDefaultString("org.eclipse.pde.ui.ws"));
        this.fNLCombo.setText(this.expandLocaleName(this.preferences.getDefaultString("org.eclipse.pde.ui.nl")));
        this.fArchCombo.setText(this.preferences.getDefaultString("org.eclipse.pde.ui.arch"));
        this.fDefaultJREButton.setSelection(true);
        this.fThisJREButton.setSelection(false);
        this.fJRECombo.setEnabled(false);
        this.fJRECombo.setText(LauncherUtils.getDefaultVMInstallName());
    }

    public boolean performOk() {
        this.applyTargetEnvironmentGroup();
        this.applyJREGroup();
        return true;
    }

    private void applyJREGroup() {
        boolean useDefault = this.fDefaultJREButton.getSelection();
        this.preferences.setValue("useDefaultJRE", useDefault);
        if (useDefault) {
            this.preferences.setValue("targetJRE", LauncherUtils.getDefaultVMInstallName());
        } else {
            this.preferences.setValue("targetJRE", this.fJRECombo.getText());
            try {
                JavaRuntime.setDefaultVMInstall((IVMInstall)LauncherUtils.getVMInstall(this.fJRECombo.getText()), null);
            }
            catch (CoreException coreException) {}
        }
    }

    private void applyTargetEnvironmentGroup() {
        String locale;
        String arch;
        String ws;
        String os = this.fOSCombo.getText().trim();
        if (os.length() > 0) {
            if (!this.fOSChoices.contains(os)) {
                String value = this.preferences.getString("org.eclipse.pde.os.extra");
                value = value.length() > 0 ? String.valueOf(value) + "," + os : os;
                this.preferences.setValue("org.eclipse.pde.os.extra", value);
            }
            this.preferences.setValue("org.eclipse.pde.ui.os", os);
        }
        if ((ws = this.fWSCombo.getText().trim()).length() > 0) {
            if (!this.fWSChoices.contains(ws)) {
                String value = this.preferences.getString("org.eclipse.pde.ws.extra");
                value = value.length() > 0 ? String.valueOf(value) + "," + ws : ws;
                this.preferences.setValue("org.eclipse.pde.ws.extra", value);
            }
            this.preferences.setValue("org.eclipse.pde.ui.ws", ws);
        }
        if ((arch = this.fArchCombo.getText().trim()).length() > 0) {
            if (!this.fArchChoices.contains(arch)) {
                String value = this.preferences.getString("org.eclipse.pde.arch.extra");
                value = value.length() > 0 ? String.valueOf(value) + "," + arch : arch;
                this.preferences.setValue("org.eclipse.pde.arch.extra", value);
            }
            this.preferences.setValue("org.eclipse.pde.ui.arch", arch);
        }
        if ((locale = this.fNLCombo.getText().trim()).length() > 0) {
            int dash;
            if (!this.fNLChoices.contains(locale)) {
                String value = this.preferences.getString("org.eclipse.pde.nl.extra");
                value = value.length() > 0 ? String.valueOf(value) + "," + locale : locale;
                this.preferences.setValue("org.eclipse.pde.nl.extra", value);
            }
            if ((dash = locale.indexOf("-")) != -1) {
                locale = locale.substring(0, dash);
            }
            locale = locale.trim();
            this.preferences.setValue("org.eclipse.pde.ui.nl", locale);
        }
        PDECore.getDefault().savePluginPreferences();
    }

    private String expandLocaleName(String name) {
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = new StringTokenizer(name, "_");
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            variant = tokenizer.nextToken();
        }
        Locale locale = new Locale(language, country, variant);
        return String.valueOf(locale.toString()) + " - " + locale.getDisplayName();
    }

    private static String[] getLocales() {
        Locale[] locales = Locale.getAvailableLocales();
        String[] result = new String[locales.length];
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            result[i] = String.valueOf(locale.toString()) + " - " + locale.getDisplayName();
            ++i;
        }
        return result;
    }
}

