/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.properties;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SelfHostingPropertyPage
extends PropertyPage {
    private Image fImage = PDEPluginImages.DESC_OUTPUT_FOLDER_OBJ.createImage();
    private CheckboxTableViewer fViewer;

    private String[] getOutputFolders() {
        IProject project = (IProject)this.getElement();
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jProject = JavaCore.create((IProject)project);
                list.add(jProject.getOutputLocation().toString());
                IClasspathEntry[] entries = jProject.getRawClasspath();
                int i = 0;
                while (i < entries.length) {
                    IPath path;
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() == 3 && entry.getContentKind() == 1 && (path = entry.getOutputLocation()) != null) {
                        list.add(path.toString());
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        return list.toArray(new String[list.size()]);
    }

    public void dispose() {
        if (this.fImage != null) {
            this.fImage.dispose();
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 64);
        label.setText(PDEPlugin.getResourceString("SelfHostingPropertyPage.label"));
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        label.setLayoutData((Object)gd);
        new Label(composite, 0);
        label = new Label(composite, 64);
        label.setText(PDEPlugin.getResourceString("SelfHostingPropertyPage.viewerLabel"));
        this.fViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.fViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new FolderLabelProvider());
        this.fViewer.setInput((Object)this.getElement());
        this.fViewer.setSorter(new ViewerSorter());
        this.fViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.initialize();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.pde.doc.user.selfhosting_property_page");
    }

    private void initialize() {
        this.fViewer.setAllChecked(true);
        Preferences pref = this.getPreferences((IProject)this.getElement());
        if (pref != null) {
            String binExcludes = pref.get("selfhosting.binExcludes", "");
            StringTokenizer tokenizer = new StringTokenizer(binExcludes, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                this.fViewer.setChecked((Object)token, false);
            }
        }
    }

    private Preferences getPreferences(IProject project) {
        return new ProjectScope(project).getNode("org.eclipse.pde.core");
    }

    protected void performDefaults() {
        this.fViewer.setAllChecked(true);
    }

    public boolean performOk() {
        Preferences pref = this.getPreferences((IProject)this.getElement());
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.fViewer.getTable().getItemCount()) {
            Object object = this.fViewer.getElementAt(i);
            if (!this.fViewer.getChecked(object)) {
                if (buffer.length() > 0) {
                    buffer.append(",");
                }
                buffer.append(object.toString());
            }
            ++i;
        }
        if (pref != null) {
            if (buffer.length() > 0) {
                pref.put("selfhosting.binExcludes", buffer.toString());
            } else {
                pref.remove("selfhosting.binExcludes");
            }
        }
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            PDEPlugin.logException(e);
        }
        return super.performOk();
    }

    class ContentProvider
    extends DefaultTableProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object input) {
            return SelfHostingPropertyPage.this.getOutputFolders();
        }
    }

    class FolderLabelProvider
    extends LabelProvider {
        FolderLabelProvider() {
        }

        public Image getImage(Object element) {
            return SelfHostingPropertyPage.this.fImage;
        }
    }
}

