/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.search.PluginSearchInput;
import org.eclipse.pde.internal.core.search.PluginSearchScope;
import org.eclipse.pde.internal.ui.search.PluginSearchQuery;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class FindPluginReferencesAction
implements IObjectActionDelegate {
    private String fSearchString = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.fSearchString != null) {
            NewSearchUI.activateSearchResultView();
            NewSearchUI.runQueryInBackground((ISearchQuery)this.createSearchQuery());
        }
    }

    private ISearchQuery createSearchQuery() {
        PluginSearchInput input = new PluginSearchInput();
        input.setSearchElement(1);
        input.setSearchLimit(2);
        input.setSearchString(this.fSearchString);
        input.setSearchScope(new PluginSearchScope());
        return new PluginSearchQuery(input);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sSelection;
        this.fSearchString = null;
        if (selection instanceof IStructuredSelection && (sSelection = (IStructuredSelection)selection).size() == 1) {
            IPluginModelBase model;
            IFile file = (IFile)sSelection.getFirstElement();
            ModelEntry entry = PDECore.getDefault().getModelManager().findEntry(file.getProject());
            if (entry != null && (model = entry.getActiveModel()) != null) {
                this.fSearchString = model.getPluginBase().getId();
            }
        }
    }
}

