/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.builders.SchemaTransformer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.schema.SchemaDescriptor;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;

public class ShowDescriptionAction
extends Action {
    private String fPointID;
    private ISchema fSchema;
    private File fPreviewFile;

    public ShowDescriptionAction(IPluginExtensionPoint point) {
        this.setExtensionPoint(point);
    }

    public ShowDescriptionAction(ISchema schema) {
        this.setSchema(schema);
    }

    public void setSchema(ISchema schema) {
        this.fSchema = schema;
        this.fPointID = schema.getQualifiedPointId();
    }

    public void setExtensionPoint(IPluginExtensionPoint point) {
        this.fPointID = point.getFullId();
        this.setText(PDEPlugin.getResourceString("ShowDescriptionAction.label"));
        this.fSchema = null;
    }

    public void run() {
        if (this.fSchema == null) {
            IPluginExtensionPoint point = PDECore.getDefault().findExtensionPoint(this.fPointID);
            URL url = null;
            if (point != null && (url = SchemaRegistry.getSchemaURL((IPluginExtensionPoint)point)) != null) {
                SchemaDescriptor desc = new SchemaDescriptor(this.fPointID, url);
                this.fSchema = desc.getSchema(false);
            }
            if (point == null || url == null || this.fSchema == null) {
                this.showNoSchemaMessage();
                return;
            }
        }
        this.showSchemaDocument();
    }

    private void showNoSchemaMessage() {
        String title = PDEPlugin.getResourceString("ShowDescriptionAction.title");
        String message = PDEPlugin.getFormattedMessage("ShowDescriptionAction.noPoint.desc", this.fPointID);
        MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
    }

    private void showSchemaDocument() {
        try {
            this.fPreviewFile = this.getPreviewFile();
            if (this.fPreviewFile == null) {
                return;
            }
            SchemaTransformer transformer = new SchemaTransformer();
            FileOutputStream os = new FileOutputStream(this.fPreviewFile);
            PrintWriter printWriter = new PrintWriter(os, true);
            transformer.transform(this.fSchema, printWriter);
            os.flush();
            ((OutputStream)os).close();
            this.showURL(this.fPreviewFile.getPath());
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    private File getPreviewFile() {
        try {
            File file = File.createTempFile("pde", ".html");
            file.deleteOnExit();
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void showURL(String url) {
        if (SWT.getPlatform().equals("win32")) {
            Program.launch((String)url);
        } else {
            try {
                IBrowser browser = BrowserManager.getInstance().createBrowser();
                browser.displayURL("file://" + url);
            }
            catch (Exception exception) {}
        }
    }
}

