/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.action.Action;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.dependencies.PluginJavaSearchUtil;
import org.eclipse.pde.internal.ui.search.dependencies.ShowResultsAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IProgressConstants;

public class UnusedDependenciesJob
extends Job {
    private IPluginModelBase fModel;
    private boolean fReadOnly;

    public UnusedDependenciesJob(String name, IPluginModelBase model, boolean readOnly) {
        super(name);
        this.fModel = model;
        this.fReadOnly = readOnly;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        IPluginImport[] imports = this.fModel.getPluginBase().getImports();
        try {
            monitor.beginTask("", imports.length);
            ArrayList<IPluginImport> list = new ArrayList<IPluginImport>();
            int i = 0;
            while (i < imports.length && !monitor.isCanceled()) {
                if (this.isUnused(imports[i], new SubProgressMonitor(monitor, 1))) {
                    list.add(imports[i]);
                }
                monitor.setTaskName(String.valueOf(PDEPlugin.getResourceString("UnusedDependencies.analyze")) + list.size() + " " + PDEPlugin.getResourceString("UnusedDependencies.unused") + " " + (list.size() == 1 ? PDEPlugin.getResourceString("DependencyExtent.singular") : PDEPlugin.getResourceString("DependencyExtent.plural")) + " " + PDEPlugin.getResourceString("DependencyExtent.found"));
                ++i;
            }
            this.showResults(list.toArray(new IPluginImport[list.size()]));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
        return new Status(0, PDEPlugin.getPluginId(), 0, PDEPlugin.getResourceString("UnusedDependenciesJob.viewResults"), null);
    }

    protected boolean isModal() {
        Boolean isModal = (Boolean)this.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        return isModal == null ? false : isModal;
    }

    private boolean isUnused(IPluginImport plugin, SubProgressMonitor monitor) {
        IPlugin[] plugins = PluginJavaSearchUtil.getPluginImports(plugin);
        if (PluginJavaSearchUtil.provideExtensionPoint(this.fModel, plugins)) {
            return false;
        }
        return !this.provideJavaClasses(plugins, (IProgressMonitor)monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean provideJavaClasses(IPlugin[] plugins, IProgressMonitor monitor) {
        block12: {
            block11: {
                block10: {
                    try {
                        try {
                            IProject project = this.fModel.getUnderlyingResource().getProject();
                            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                                Object var10_4 = null;
                                break block10;
                            }
                            IJavaProject jProject = JavaCore.create((IProject)project);
                            IPackageFragment[] packageFragments = PluginJavaSearchUtil.collectPackageFragments((IPluginBase[])plugins, jProject);
                            SearchEngine engine = new SearchEngine();
                            monitor.beginTask("", packageFragments.length);
                            int i = 0;
                            while (i < packageFragments.length) {
                                IPackageFragment pkgFragment = packageFragments[i];
                                if (pkgFragment.hasChildren()) {
                                    Requestor requestor = new Requestor();
                                    engine.search(SearchPattern.createPattern((IJavaElement)pkgFragment, (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, PluginJavaSearchUtil.createSeachScope(jProject), (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    if (requestor.foundMatches()) {
                                        break block11;
                                    }
                                } else {
                                    monitor.worked(1);
                                }
                                ++i;
                            }
                            break block12;
                        }
                        catch (CoreException coreException) {
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_6 = null;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return false;
            }
            Object var10_5 = null;
            monitor.done();
            return true;
        }
        Object var10_7 = null;
        monitor.done();
        return false;
    }

    private Action getShowResultsAction(IPluginImport[] unused) {
        return new ShowResultsAction(unused, this.fReadOnly);
    }

    protected void showResults(final IPluginImport[] unused) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                UnusedDependenciesJob.this.getShowResultsAction(unused).run();
            }
        });
    }

    class Requestor
    extends SearchRequestor {
        boolean found = false;

        Requestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.found = true;
        }

        public boolean foundMatches() {
            return this.found;
        }
    }
}

