/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public class PluginWorkingSet
extends WizardPage
implements IWorkingSetPage {
    private IWorkingSet fWorkingSet;
    private Text fWorkingSetName;
    private CheckboxTableViewer fTable;
    private boolean fFirstCheck;

    public PluginWorkingSet() {
        super("page1", PDEPlugin.getResourceString("PluginWorkingSet.title"), PDEPluginImages.DESC_PLUGIN2BUNDLE_WIZ);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void finish() {
        Object[] checked = this.fTable.getCheckedElements();
        ArrayList<PersistablePluginObject> list = new ArrayList<PersistablePluginObject>();
        int i = 0;
        while (i < checked.length) {
            String id = ((IPluginModelBase)checked[i]).getPluginBase().getId();
            if (id != null && id.length() > 0) {
                list.add(new PersistablePluginObject(id));
            }
            ++i;
        }
        PersistablePluginObject[] objects = list.toArray(new PersistablePluginObject[list.size()]);
        String workingSetName = this.fWorkingSetName.getText().trim();
        if (this.fWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = workingSetManager.createWorkingSet(workingSetName, (IAdaptable[])objects);
        } else {
            this.fWorkingSet.setName(workingSetName);
            this.fWorkingSet.setElements((IAdaptable[])objects);
        }
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        this.fWorkingSet = workingSet;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(PDEPlugin.getResourceString("PluginWorkingSet.setName"));
        label.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName = new Text(composite, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PluginWorkingSet.this.validatePage();
            }
        });
        this.fWorkingSetName.setFocus();
        label = new Label(composite, 64);
        label.setText(PDEPlugin.getResourceString("PluginWorkingSet.setContent"));
        label.setLayoutData((Object)new GridData(768));
        this.fTable = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        this.fTable.getControl().setLayoutData((Object)gd);
        this.fTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fTable.setLabelProvider((IBaseLabelProvider)new WorkingSetLabelProvider());
        this.fTable.setUseHashlookup(true);
        this.fTable.setInput((Object)PDECore.getDefault().getModelManager());
        this.fTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PluginWorkingSet.this.validatePage();
            }
        });
        this.initialize();
        Dialog.applyDialogFont((Control)composite);
    }

    private void initialize() {
        if (this.fWorkingSet != null) {
            HashSet<String> set = new HashSet<String>();
            IAdaptable[] elements = this.fWorkingSet.getElements();
            int i = 0;
            while (i < elements.length) {
                set.add(((PersistablePluginObject)elements[i]).getPluginID());
                ++i;
            }
            i = 0;
            while (i < this.fTable.getTable().getItemCount()) {
                IPluginModelBase model = (IPluginModelBase)this.fTable.getElementAt(i);
                String id = model.getPluginBase().getId();
                if (id != null) {
                    if (set.contains(id)) {
                        this.fTable.setChecked((Object)model, true);
                        set.remove(id);
                    }
                    if (set.isEmpty()) break;
                }
                ++i;
            }
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    private void validatePage() {
        String errorMessage = null;
        String newText = this.fWorkingSetName.getText();
        if (newText.trim().length() == 0) {
            errorMessage = PDEPlugin.getResourceString("PluginWorkingSet.emptyName");
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
        }
        if (errorMessage == null && this.fTable.getCheckedElements().length == 0) {
            errorMessage = PDEPlugin.getResourceString("PluginWorkingSet.noPluginsChecked");
        }
        if (errorMessage == null && this.fWorkingSet == null) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = PDEPlugin.getResourceString("PluginWorkingSet.nameInUse");
                    break;
                }
                ++i;
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    class ContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return PDECore.getDefault().getModelManager().getAllPlugins();
        }
    }

    class WorkingSetLabelProvider
    extends LabelProvider {
        Preferences pref = PDEPlugin.getDefault().getPluginPreferences();

        public WorkingSetLabelProvider() {
            PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        }

        public String getText(Object element) {
            if (element instanceof IPluginModelBase) {
                IPluginBase plugin = ((IPluginModelBase)element).getPluginBase();
                String showType = this.pref.getString("Preferences.MainPage.showObjects");
                if (showType.equals("useIds")) {
                    return plugin.getId();
                }
                return plugin.getTranslatedName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return PDEPlugin.getDefault().getLabelProvider().getImage(element);
        }

        public void dispose() {
            super.dispose();
            PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        }
    }
}

