/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.util.ImageOverlayIcon;
import org.eclipse.pde.internal.ui.util.OverlayIcon;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class SharedLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final int F_ERROR = 1;
    public static final int F_WARNING = 2;
    public static final int F_EXPORT = 4;
    public static final int F_EDIT = 8;
    public static final int F_BINARY = 16;
    public static final int F_EXTERNAL = 32;
    public static final int F_JAVA = 64;
    public static final int F_JAR = 128;
    public static final int F_PROJECT = 256;
    Hashtable images = new Hashtable();
    ArrayList consumers = new ArrayList();
    private Image fBlankImage;

    public void connect(Object consumer) {
        if (!this.consumers.contains(consumer)) {
            this.consumers.add(consumer);
        }
    }

    public void disconnect(Object consumer) {
        this.consumers.remove(consumer);
        if (this.consumers.size() == 0) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.consumers.size() == 0) {
            Enumeration elements = this.images.elements();
            while (elements.hasMoreElements()) {
                ((Image)elements.nextElement()).dispose();
            }
            this.images.clear();
            if (this.fBlankImage != null) {
                this.fBlankImage.dispose();
                this.fBlankImage = null;
            }
        }
    }

    public Image get(ImageDescriptor desc) {
        return this.get(desc, 0);
    }

    public Image get(ImageDescriptor desc, int flags) {
        Image image;
        Object key = desc;
        if (flags != 0) {
            key = this.getKey(desc.hashCode(), flags);
        }
        if ((image = (Image)this.images.get(key)) == null) {
            image = this.createImage(desc, flags);
            this.images.put(key, image);
        }
        return image;
    }

    public Image get(Image image, int flags) {
        if (flags == 0) {
            return image;
        }
        String key = this.getKey(image.hashCode(), flags);
        Image resultImage = (Image)this.images.get(key);
        if (resultImage == null) {
            resultImage = this.createImage(image, flags);
            this.images.put(key, resultImage);
        }
        return resultImage;
    }

    private String getKey(long hashCode, int flags) {
        return hashCode + ":" + flags;
    }

    private Image createImage(ImageDescriptor baseDesc, int flags) {
        if (flags == 0) {
            return baseDesc.createImage();
        }
        ImageDescriptor[] lowerLeft = this.getLowerLeftOverlays(flags);
        ImageDescriptor[] upperRight = this.getUpperRightOverlays(flags);
        ImageDescriptor[] lowerRight = this.getLowerRightOverlays(flags);
        ImageDescriptor[] upperLeft = this.getUpperLeftOverlays(flags);
        OverlayIcon compDesc = new OverlayIcon(baseDesc, new ImageDescriptor[][]{upperRight, lowerRight, lowerLeft, upperLeft});
        return compDesc.createImage();
    }

    private Image createImage(Image baseImage, int flags) {
        if (flags == 0) {
            return baseImage;
        }
        ImageDescriptor[] lowerLeft = this.getLowerLeftOverlays(flags);
        ImageDescriptor[] upperRight = this.getUpperRightOverlays(flags);
        ImageDescriptor[] lowerRight = this.getLowerRightOverlays(flags);
        ImageDescriptor[] upperLeft = this.getUpperLeftOverlays(flags);
        ImageOverlayIcon compDesc = new ImageOverlayIcon(baseImage, new ImageDescriptor[][]{upperRight, lowerRight, lowerLeft, upperLeft});
        return compDesc.createImage();
    }

    private ImageDescriptor[] getLowerLeftOverlays(int flags) {
        if ((flags & 1) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_ERROR_CO};
        }
        if ((flags & 2) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_WARNING_CO};
        }
        return null;
    }

    private ImageDescriptor[] getUpperRightOverlays(int flags) {
        if ((flags & 4) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_EXPORT_CO};
        }
        if ((flags & 8) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_DOC_CO};
        }
        if ((flags & 0x40) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_JAVA_CO};
        }
        return null;
    }

    private ImageDescriptor[] getLowerRightOverlays(int flags) {
        if ((flags & 0x80) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_JAR_CO};
        }
        if ((flags & 0x100) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_PROJECT_CO};
        }
        return null;
    }

    private ImageDescriptor[] getUpperLeftOverlays(int flags) {
        if ((flags & 0x20) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_EXTERNAL_CO};
        }
        if ((flags & 0x10) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_BINARY_CO};
        }
        return null;
    }

    public String getColumnText(Object obj, int index) {
        return this.getText(obj);
    }

    public Image getColumnImage(Object obj, int index) {
        return this.getImage(obj);
    }

    public Image getImageFromPlugin(String bundleID, String subdirectoryAndFilename) {
        try {
            Bundle bundle = Platform.getBundle((String)bundleID);
            return this.getImageFromURL(Platform.resolve((URL)bundle.getEntry(subdirectoryAndFilename)));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Image getImageFromURL(URL url) {
        if (url == null) {
            return this.getBlankImage();
        }
        Image image = null;
        try {
            InputStream stream = null;
            try {
                stream = url.openStream();
                stream.close();
            }
            catch (IOException iOException) {
                return this.getBlankImage();
            }
            String key = url.toString();
            image = (Image)this.images.get(key);
            if (image == null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                image = desc.createImage();
                this.images.put(key, image);
            }
        }
        catch (SWTException sWTException) {}
        return image;
    }

    public Image getBlankImage() {
        if (this.fBlankImage == null) {
            this.fBlankImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.fBlankImage;
    }
}

