/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.EntryFileAdapter;
import org.eclipse.pde.internal.core.FileAdapter;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.view.CopyToClipboardAction;
import org.eclipse.pde.internal.ui.view.OpenDependenciesAction;
import org.eclipse.pde.internal.ui.view.PluginsContentProvider;
import org.eclipse.pde.internal.ui.view.PluginsDragAdapter;
import org.eclipse.pde.internal.ui.view.PluginsLabelProvider;
import org.eclipse.pde.internal.ui.view.ShowInWorkspaceAction;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class PluginsView
extends ViewPart {
    private static final String DEFAULT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private TreeViewer treeViewer;
    private DrillDownAdapter drillDownAdapter;
    private IPropertyChangeListener propertyListener;
    private Action openAction;
    private Action importBinaryAction;
    private Action importSourceAction;
    private Action disabledFilterAction;
    private Action workspaceFilterAction;
    private Action openManifestAction;
    private Action openSchemaAction;
    private Action openSystemEditorAction;
    private Action openClassFileAction;
    private Action openDependenciesAdapter;
    private OpenDependenciesAction openDependenciesAction;
    private Action openTextEditorAction;
    private Action selectDependentAction;
    private Action selectInJavaSearchAction;
    private Action addToJavaSearchAction;
    private Action removeFromJavaSearchAction;
    private ShowInWorkspaceAction showInNavigatorAction;
    private ShowInWorkspaceAction showInPackagesAction;
    private DisabledFilter disabledFilter = new DisabledFilter();
    private WorkspaceFilter workspaceFilter = new WorkspaceFilter();
    private JavaFilter javaFilter = new JavaFilter();
    private CopyToClipboardAction copyAction;
    private Clipboard clipboard;

    public PluginsView() {
        this.propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("Preferences.MainPage.showObjects")) {
                    PluginsView.this.treeViewer.refresh();
                }
            }
        };
    }

    public void dispose() {
        PDEPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyListener);
        this.openDependenciesAction.dispose();
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.treeViewer);
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        this.treeViewer.setContentProvider((IContentProvider)new PluginsContentProvider(this, manager));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new PluginsLabelProvider());
        this.treeViewer.setSorter(ListUtil.PLUGIN_SORTER);
        this.initDragAndDrop();
        this.makeActions();
        this.initFilters();
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.contributeToActionBars(actionBars);
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                PluginsView.this.handleSelectionChanged(e.getSelection());
            }
        });
        this.treeViewer.setInput((Object)manager);
        PDEPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyListener);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        WorkbenchHelp.setHelp((Control)this.treeViewer.getControl(), (String)"org.eclipse.pde.doc.user.plugins_view");
    }

    private void contributeToActionBars(IActionBars actionBars) {
        this.contributeToLocalToolBar(actionBars.getToolBarManager());
        this.contributeToDropDownMenu(actionBars.getMenuManager());
    }

    private void contributeToDropDownMenu(IMenuManager manager) {
        manager.add((IAction)this.workspaceFilterAction);
        manager.add((IAction)this.disabledFilterAction);
    }

    private void contributeToLocalToolBar(IToolBarManager manager) {
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.clipboard = new Clipboard(this.treeViewer.getTree().getDisplay());
        this.openAction = new Action(){

            public void run() {
                PluginsView.this.handleDoubleClick();
            }
        };
        this.openAction.setText(PDEPlugin.getResourceString("PluginsView.open"));
        this.openDependenciesAction = new OpenDependenciesAction();
        this.openDependenciesAction.init(PDEPlugin.getActiveWorkbenchWindow());
        this.openDependenciesAdapter = new Action(){

            public void run() {
                ModelEntry entry = PluginsView.this.getEnclosingEntry();
                IPluginModelBase model = entry.getActiveModel();
                PluginsView.this.openDependenciesAction.selectionChanged((IAction)this, (ISelection)new StructuredSelection((Object)model));
                PluginsView.this.openDependenciesAction.run((IAction)this);
            }
        };
        this.openDependenciesAdapter.setText(PDEPlugin.getResourceString("PluginsView.openDependencies"));
        this.importBinaryAction = new Action(){

            public void run() {
                PluginsView.this.handleImport(false);
            }
        };
        this.importBinaryAction.setText(PDEPlugin.getResourceString("PluginsView.asBinaryProject"));
        this.importSourceAction = new Action(){

            public void run() {
                PluginsView.this.handleImport(true);
            }
        };
        this.importSourceAction.setText(PDEPlugin.getResourceString("PluginsView.asSourceProject"));
        this.disabledFilterAction = new Action(){

            public void run() {
                boolean checked = PluginsView.this.disabledFilterAction.isChecked();
                if (checked) {
                    PluginsView.this.treeViewer.removeFilter((ViewerFilter)PluginsView.this.disabledFilter);
                } else {
                    PluginsView.this.treeViewer.addFilter((ViewerFilter)PluginsView.this.disabledFilter);
                }
                PluginsView.this.getSettings().put("disabledFilter", !checked);
            }
        };
        this.disabledFilterAction.setText(PDEPlugin.getResourceString("PluginsView.showDisabled"));
        this.disabledFilterAction.setChecked(false);
        this.workspaceFilterAction = new Action(){

            public void run() {
                boolean checked = PluginsView.this.workspaceFilterAction.isChecked();
                if (checked) {
                    PluginsView.this.treeViewer.removeFilter((ViewerFilter)PluginsView.this.workspaceFilter);
                } else {
                    PluginsView.this.treeViewer.addFilter((ViewerFilter)PluginsView.this.workspaceFilter);
                }
                PluginsView.this.getSettings().put("workspaceFilter", !checked);
            }
        };
        this.workspaceFilterAction.setText(PDEPlugin.getResourceString("PluginsView.showWorkspace"));
        this.workspaceFilterAction.setChecked(true);
        this.openTextEditorAction = new Action(){

            public void run() {
                PluginsView.this.handleOpenTextEditor(PluginsView.this.getSelectedFile(), null);
            }
        };
        this.openTextEditorAction.setText(PDEPlugin.getResourceString("PluginsView.textEditor"));
        this.openTextEditorAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.openSystemEditorAction = new Action(){

            public void run() {
                PluginsView.this.handleOpenSystemEditor(PluginsView.this.getSelectedFile());
            }
        };
        this.openSystemEditorAction.setText(PDEPlugin.getResourceString("PluginsView.systemEditor"));
        this.openManifestAction = new Action(){

            public void run() {
                PluginsView.this.handleOpenManifestEditor(PluginsView.this.getSelectedFile());
            }
        };
        this.openManifestAction.setText(PDEPlugin.getResourceString("PluginsView.manifestEditor"));
        this.openSchemaAction = new Action(){

            public void run() {
                PluginsView.this.handleOpenSchemaEditor(PluginsView.this.getSelectedFile());
            }
        };
        this.openSchemaAction.setText(PDEPlugin.getResourceString("PluginsView.schemaEditor"));
        this.copyAction = new CopyToClipboardAction(this.clipboard);
        this.copyAction.setText(PDEPlugin.getResourceString("PluginsView.copy"));
        this.selectDependentAction = new Action(){

            public void run() {
                PluginsView.this.handleSelectDependent();
            }
        };
        this.selectDependentAction.setText(PDEPlugin.getResourceString("PluginsView.dependentPlugins"));
        this.selectInJavaSearchAction = new Action(){

            public void run() {
                PluginsView.this.handleSelectInJavaSearch();
            }
        };
        this.selectInJavaSearchAction.setText(PDEPlugin.getResourceString("PluginsView.pluginsInJavaSearch"));
        this.addToJavaSearchAction = new Action(){

            public void run() {
                PluginsView.this.handleJavaSearch(true);
            }
        };
        this.addToJavaSearchAction.setText(PDEPlugin.getResourceString("PluginsView.addToJavaSearch"));
        this.removeFromJavaSearchAction = new Action(){

            public void run() {
                PluginsView.this.handleJavaSearch(false);
            }
        };
        this.removeFromJavaSearchAction.setText(PDEPlugin.getResourceString("PluginsView.removeFromJavaSearch"));
        this.showInNavigatorAction = new ShowInWorkspaceAction("org.eclipse.ui.views.ResourceNavigator", (ISelectionProvider)this.treeViewer);
        this.showInNavigatorAction.setText(PDEPlugin.getResourceString("PluginsView.showInNavigator"));
        this.showInPackagesAction = new ShowInWorkspaceAction("org.eclipse.jdt.ui.PackageExplorer", (ISelectionProvider)this.treeViewer);
        this.showInPackagesAction.setText(PDEPlugin.getResourceString("PluginsView.showInPackageExplorer"));
        this.openClassFileAction = new OpenAction((IWorkbenchSite)this.getViewSite());
    }

    private FileAdapter getSelectedFile() {
        Object obj = this.getSelectedObject();
        if (obj instanceof FileAdapter) {
            return (FileAdapter)obj;
        }
        return null;
    }

    private ModelEntry getEnclosingEntry() {
        FileAdapter parent;
        FileAdapter file;
        Object obj = this.getSelectedObject();
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelEntry) {
            return (ModelEntry)obj;
        }
        if (obj instanceof FileAdapter && (file = (FileAdapter)obj).isManifest() && (parent = file.getParent()) instanceof EntryFileAdapter) {
            return ((EntryFileAdapter)parent).getEntry();
        }
        return null;
    }

    private Object getSelectedObject() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        return selection.getFirstElement();
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.size() == 1) {
            ModelEntry entry;
            Object sobj = selection.getFirstElement();
            boolean addSeparator = false;
            if (sobj instanceof FileAdapter && !((FileAdapter)sobj).isDirectory()) {
                manager.add((IAction)this.openAction);
                MenuManager openWithMenu = new MenuManager(PDEPlugin.getResourceString("PluginsView.openWith"));
                this.fillOpenWithMenu((IMenuManager)openWithMenu, sobj);
                manager.add((IContributionItem)openWithMenu);
                addSeparator = true;
            }
            if (sobj instanceof IStorage) {
                manager.add((IAction)this.openAction);
                addSeparator = true;
            }
            if (sobj instanceof IClassFile) {
                manager.add((IAction)this.openClassFileAction);
                addSeparator = true;
            }
            if ((entry = this.getEnclosingEntry()) != null) {
                manager.add((IAction)this.openDependenciesAdapter);
                manager.add((IContributionItem)new Separator());
                PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
                actionGroup.setContext(new ActionContext((ISelection)selection));
                actionGroup.fillContextMenu(manager);
                addSeparator = true;
            }
            if (addSeparator) {
                manager.add((IContributionItem)new Separator());
            }
        }
        if (selection.size() > 0) {
            boolean addSeparator = false;
            if (this.showInNavigatorAction.isApplicable()) {
                manager.add((IAction)this.showInNavigatorAction);
                addSeparator = true;
            }
            if (this.showInPackagesAction.isApplicable()) {
                manager.add((IAction)this.showInPackagesAction);
                addSeparator = true;
            }
            if (addSeparator) {
                manager.add((IContributionItem)new Separator());
            }
            if (this.canImport(selection)) {
                MenuManager importMenu = new MenuManager(PDEPlugin.getResourceString("PluginsView.import"));
                importMenu.add((IAction)this.importBinaryAction);
                importMenu.add((IAction)this.importSourceAction);
                manager.add((IContributionItem)importMenu);
                manager.add((IContributionItem)new Separator());
            }
            addSeparator = false;
            if (this.canDoJavaSearchOperation(selection, true)) {
                manager.add((IAction)this.addToJavaSearchAction);
                addSeparator = true;
            }
            if (this.canDoJavaSearchOperation(selection, false)) {
                manager.add((IAction)this.removeFromJavaSearchAction);
                addSeparator = true;
            }
            if (addSeparator) {
                manager.add((IContributionItem)new Separator());
            }
        }
        this.copyAction.setSelection(selection);
        manager.add((IAction)this.copyAction);
        MenuManager selectionMenu = new MenuManager(PDEPlugin.getResourceString("PluginsView.select"));
        manager.add((IContributionItem)selectionMenu);
        if (selection.size() > 0) {
            selectionMenu.add((IAction)this.selectDependentAction);
        }
        selectionMenu.add((IAction)this.selectInJavaSearchAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillOpenWithMenu(IMenuManager manager, Object obj) {
        FileAdapter adapter = (FileAdapter)obj;
        String editorId = adapter.getEditorId();
        String fileName = adapter.getFile().getName();
        String lcFileName = fileName.toLowerCase();
        ImageDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileName);
        if (lcFileName.equals("plugin.xml") || lcFileName.equals("fragment.xml") || lcFileName.equals("manifest.mf")) {
            this.openManifestAction.setImageDescriptor(desc);
            manager.add((IAction)this.openManifestAction);
            manager.add((IContributionItem)new Separator());
            this.openManifestAction.setChecked(editorId != null && editorId.equals("org.eclipse.pde.ui.manifestEditor"));
        }
        if (lcFileName.endsWith(".mxsd") || lcFileName.endsWith(".exsd")) {
            this.openSchemaAction.setImageDescriptor(desc);
            manager.add((IAction)this.openSchemaAction);
            manager.add((IContributionItem)new Separator());
            this.openSchemaAction.setChecked(editorId != null && editorId.equals("org.eclipse.pde.ui.schemaEditor"));
        }
        manager.add((IAction)this.openTextEditorAction);
        this.openTextEditorAction.setChecked(editorId == null || editorId.equals(DEFAULT_EDITOR_ID));
        this.openSystemEditorAction.setImageDescriptor(desc);
        this.openSystemEditorAction.setChecked(editorId != null && editorId.equals("@system"));
        manager.add((IAction)this.openSystemEditorAction);
    }

    private boolean canImport(IStructuredSelection selection) {
        int nexternal = 0;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof ModelEntry) {
                ModelEntry entry = (ModelEntry)obj;
                if (entry.getWorkspaceModel() != null) continue;
                ++nexternal;
                continue;
            }
            return false;
        }
        return nexternal > 0;
    }

    private boolean canDoJavaSearchOperation(IStructuredSelection selection, boolean add) {
        int nhits = 0;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            ModelEntry entry;
            Object obj = iter.next();
            if (!(obj instanceof ModelEntry) || (entry = (ModelEntry)obj).getWorkspaceModel() != null) continue;
            if (add && !entry.isInJavaSearch()) {
                ++nhits;
            }
            if (add || !entry.isInJavaSearch()) continue;
            ++nhits;
        }
        return nhits > 0;
    }

    protected void initDragAndDrop() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        this.treeViewer.addDragSupport(ops, transfers, (DragSourceListener)new PluginsDragAdapter((ISelectionProvider)this.treeViewer));
    }

    private IDialogSettings getSettings() {
        IDialogSettings master = PDEPlugin.getDefault().getDialogSettings();
        IDialogSettings section = master.getSection("pluginsView");
        if (section == null) {
            section = master.addNewSection("pluginsView");
        }
        return section;
    }

    private void initFilters() {
        boolean workspace = false;
        boolean disabled = true;
        IDialogSettings settings = this.getSettings();
        workspace = settings.getBoolean("workspaceFilter");
        boolean bl = disabled = !settings.getBoolean("disabledFilter");
        if (workspace) {
            this.treeViewer.addFilter((ViewerFilter)this.workspaceFilter);
        }
        if (disabled) {
            this.treeViewer.addFilter((ViewerFilter)this.disabledFilter);
        }
        this.treeViewer.addFilter((ViewerFilter)this.javaFilter);
        this.workspaceFilterAction.setChecked(!workspace);
        this.disabledFilterAction.setChecked(!disabled);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PluginsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void handleDoubleClick() {
        Object obj = this.getSelectedObject();
        if (obj instanceof ModelEntry) {
            this.treeViewer.setExpandedState(obj, !this.treeViewer.getExpandedState(obj));
        }
        if (obj instanceof FileAdapter) {
            FileAdapter adapter = (FileAdapter)obj;
            if (adapter.isDirectory()) {
                this.treeViewer.setExpandedState((Object)adapter, !this.treeViewer.getExpandedState((Object)adapter));
                return;
            }
            String editorId = adapter.getEditorId();
            if (editorId != null && editorId.equals("@system")) {
                this.handleOpenSystemEditor(adapter);
            } else {
                this.handleOpenTextEditor(adapter, editorId);
            }
        }
        if (obj instanceof IClassFile) {
            this.openClassFileAction.run();
        }
        if (obj instanceof IStorage) {
            this.handleOpenStorage((IStorage)obj);
        }
    }

    private void handleOpenStorage(IStorage obj) {
        IWorkbenchPage page = PDEPlugin.getActivePage();
        JarEntryEditorInput input = new JarEntryEditorInput(obj);
        try {
            page.openEditor((IEditorInput)input, DEFAULT_EDITOR_ID);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleImport(boolean extractSource) {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        ArrayList<IPluginModelBase> externalModels = new ArrayList<IPluginModelBase>();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            ModelEntry entry = (ModelEntry)iter.next();
            if (entry.getWorkspaceModel() != null) continue;
            externalModels.add(entry.getExternalModel());
        }
        IPluginModelBase[] models = externalModels.toArray(new IPluginModelBase[externalModels.size()]);
        try {
            Shell shell = this.treeViewer.getTree().getShell();
            int importType = extractSource ? 3 : 1;
            IRunnableWithProgress op = PluginImportWizard.getImportOperation(shell, importType, models);
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
        catch (Exception exception) {}
    }

    private void handleJavaSearch(final boolean add) {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        ArrayList<ModelEntry> result = new ArrayList<ModelEntry>();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            ModelEntry entry = (ModelEntry)iter.next();
            if (entry.getWorkspaceModel() != null || entry.isInJavaSearch() != !add) continue;
            result.add(entry);
        }
        if (result.size() == 0) {
            return;
        }
        final ModelEntry[] array = result.toArray(new ModelEntry[result.size()]);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                PluginModelManager manager = PDECore.getDefault().getModelManager();
                try {
                    try {
                        manager.setInJavaSearch(array, add, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                monitor.done();
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleSelectDependent() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        HashSet<ModelEntry> set = new HashSet<ModelEntry>();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            ModelEntry entry = (ModelEntry)iter.next();
            set.add(entry);
            this.addDependentEntries(entry, set);
        }
        this.treeViewer.setSelection((ISelection)new StructuredSelection(set.toArray()));
    }

    private void handleSelectInJavaSearch() {
        PluginsContentProvider provider = (PluginsContentProvider)this.treeViewer.getContentProvider();
        Object[] elements = provider.getElements(this.treeViewer.getInput());
        ArrayList<ModelEntry> result = new ArrayList<ModelEntry>();
        int i = 0;
        while (i < elements.length) {
            ModelEntry entry;
            Object element = elements[i];
            if (element instanceof ModelEntry && (entry = (ModelEntry)element).isInJavaSearch()) {
                result.add(entry);
            }
            ++i;
        }
        this.treeViewer.setSelection((ISelection)new StructuredSelection(result.toArray()));
    }

    private void addDependentEntries(ModelEntry entry, Set set) {
        if (entry.isEmpty() || entry.getActiveModel() instanceof WorkspacePluginModelBase) {
            return;
        }
        IPluginModelBase model = entry.getExternalModel();
        if (model == null) {
            return;
        }
        IPluginBase plugin = model.getPluginBase();
        if (plugin == null) {
            return;
        }
        IPluginImport[] iimports = plugin.getImports();
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        int i = 0;
        while (i < iimports.length) {
            IPluginImport iimport = iimports[i];
            ModelEntry ientry = manager.findEntry(iimport.getId());
            if (ientry != null) {
                set.add(ientry);
                this.addDependentEntries(ientry, set);
            }
            ++i;
        }
    }

    private void handleOpenTextEditor(FileAdapter adapter, String editorId) {
        if (adapter == null) {
            return;
        }
        IWorkbenchPage page = PDEPlugin.getActivePage();
        if (editorId == null) {
            if (adapter.isManifest()) {
                editorId = "org.eclipse.pde.ui.manifestEditor";
            } else if (adapter.isSchema()) {
                editorId = "org.eclipse.pde.ui.schemaEditor";
            }
        }
        try {
            if (editorId == null || editorId.equals("@system")) {
                editorId = DEFAULT_EDITOR_ID;
            }
            page.openEditor((IEditorInput)new SystemFileEditorInput(adapter.getFile()), editorId);
            adapter.setEditorId(editorId);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleOpenManifestEditor(FileAdapter adapter) {
        this.handleOpenTextEditor(adapter, "org.eclipse.pde.ui.manifestEditor");
    }

    private void handleOpenSchemaEditor(FileAdapter adapter) {
        this.handleOpenTextEditor(adapter, "org.eclipse.pde.ui.schemaEditor");
    }

    private void handleOpenSystemEditor(FileAdapter adapter) {
        if (adapter == null) {
            return;
        }
        File localFile = null;
        try {
            localFile = this.getLocalCopy(adapter.getFile());
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
            return;
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        final File file = localFile;
        final boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)this.treeViewer.getTree().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                String path = file.getAbsolutePath();
                result[0] = Program.launch((String)path);
            }
        });
        if (!result[0]) {
            PDEPlugin.logException(new PartInitException(PDEPlugin.getFormattedMessage("PluginsView.unableToOpen", file.getName())));
        } else {
            adapter.setEditorId("@system");
        }
    }

    private File getLocalCopy(File file) throws IOException, CoreException {
        String prefix;
        String fileName = file.getName();
        String suffix = null;
        int dotLoc = fileName.indexOf(46);
        if (dotLoc != -1) {
            prefix = fileName.substring(0, dotLoc);
            suffix = fileName.substring(dotLoc);
        } else {
            prefix = fileName;
        }
        File tmpFile = File.createTempFile(prefix, suffix);
        tmpFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tmpFile);
        FileInputStream fis = new FileInputStream(file);
        byte[] cbuffer = new byte[1024];
        int read = 0;
        while (read != -1) {
            read = fis.read(cbuffer);
            if (read == -1) continue;
            fos.write(cbuffer, 0, read);
        }
        fos.flush();
        fos.close();
        fis.close();
        tmpFile.setReadOnly();
        return tmpFile;
    }

    private void handleSelectionChanged(ISelection selection) {
        String text = "";
        Object obj = this.getSelectedObject();
        if (obj instanceof ModelEntry) {
            IPluginModelBase model = ((ModelEntry)obj).getActiveModel();
            text = model.getInstallLocation();
        }
        if (obj instanceof FileAdapter) {
            text = ((FileAdapter)obj).getFile().getAbsolutePath();
        }
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(text);
    }

    private void hookDoubleClickAction() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PluginsView.this.handleDoubleClick();
            }
        });
    }

    public void setFocus() {
    }

    void updateTitle(Object newInput) {
        IConfigurationElement config = this.getConfigurationElement();
        if (config == null) {
            return;
        }
        String viewName = config.getAttribute("name");
        if (newInput == null || newInput.equals(PDECore.getDefault().getModelManager())) {
            this.setContentDescription(viewName);
            this.setTitleToolTip(this.getTitle());
        } else {
            String name = ((LabelProvider)this.treeViewer.getLabelProvider()).getText(newInput);
            this.setContentDescription(String.valueOf(viewName) + ": " + name);
            this.setTitleToolTip(this.getInputPath(newInput));
        }
    }

    private String getInputPath(Object input) {
        if (input instanceof FileAdapter) {
            return "file: " + ((FileAdapter)input).getFile().getAbsolutePath();
        }
        if (input instanceof ModelEntry) {
            IPluginModelBase model = ((ModelEntry)input).getActiveModel();
            return "plugin: " + model.getInstallLocation();
        }
        return "";
    }

    class DisabledFilter
    extends ViewerFilter {
        DisabledFilter() {
        }

        public boolean select(Viewer v, Object parent, Object element) {
            IPluginModelBase externalModel;
            ModelEntry entry;
            if (element instanceof ModelEntry && (entry = (ModelEntry)element).getWorkspaceModel() == null && (externalModel = entry.getExternalModel()) != null) {
                return externalModel.isEnabled();
            }
            return true;
        }
    }

    class WorkspaceFilter
    extends ViewerFilter {
        WorkspaceFilter() {
        }

        public boolean select(Viewer v, Object parent, Object element) {
            if (element instanceof ModelEntry) {
                ModelEntry entry = (ModelEntry)element;
                return entry.getWorkspaceModel() == null;
            }
            return true;
        }
    }

    class JavaFilter
    extends ViewerFilter {
        JavaFilter() {
        }

        public boolean select(Viewer v, Object parent, Object element) {
            if (element instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)element;
                try {
                    return packageFragment.hasChildren();
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            return true;
        }
    }
}

