/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.feature.FeatureImport;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureInstallHandler;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;
import org.eclipse.pde.internal.ui.wizards.feature.PatchPluginListPage;
import org.eclipse.pde.internal.ui.wizards.feature.PatchSpecPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewFeaturePatchWizard
extends NewWizard
implements IExecutableExtension {
    public static final String KEY_WTITLE = "FeaturePatch.wtitle";
    public static final String MAIN_PAGE_TITLE = "FeaturePatch.MainPage.title";
    public static final String MAIN_PAGE_DESC = "FeaturePatch.MainPage.desc";
    public static final String DEF_PROJECT_NAME = "project-name";
    public static final String DEF_FEATURE_ID = "feature-id";
    public static final String DEF_FEATURE_NAME = "feature-name";
    public static final String CREATING_PROJECT = "NewFeatureWizard.creatingProject";
    public static final String OVERWRITE_FEATURE = "NewFeatureWizard.overwriteFeature";
    public static final String CREATING_FOLDERS = "NewFeatureWizard.creatingFolders";
    public static final String CREATING_MANIFEST = "NewFeatureWizard.creatingManifest";
    private WizardNewProjectCreationPage mainPage;
    private PatchSpecPage specPage;
    private PatchPluginListPage pluginListPage;
    private IConfigurationElement config;
    private FeaturePatchProvider provider;

    public NewFeaturePatchWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWFTRPTCH_WIZ);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
    }

    public void addPages() {
        this.mainPage = new WizardNewProjectCreationPage("main"){

            public void createControl(Composite parent) {
                super.createControl(parent);
                WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.pde.doc.user.new_patch_main");
            }
        };
        this.mainPage.setTitle(PDEPlugin.getResourceString(MAIN_PAGE_TITLE));
        this.mainPage.setDescription(PDEPlugin.getResourceString(MAIN_PAGE_DESC));
        String pname = this.getDefaultValue(DEF_PROJECT_NAME);
        if (pname != null) {
            this.mainPage.setInitialProjectName(pname);
        }
        this.addPage((IWizardPage)this.mainPage);
        this.provider = new FeaturePatchProvider();
        this.specPage = new PatchSpecPage(this.mainPage);
        this.specPage.setInitialId(this.getDefaultValue(DEF_FEATURE_ID));
        this.specPage.setInitialName(this.getDefaultValue(DEF_FEATURE_NAME));
        this.addPage((IWizardPage)this.specPage);
        this.pluginListPage = new PatchPluginListPage(this.provider);
        this.addPage((IWizardPage)this.pluginListPage);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return page == this.specPage && page.isPageComplete() || page == this.pluginListPage && page.isPageComplete();
    }

    public boolean performFinish() {
        final IProject project = this.provider.getProject();
        final IPath location = this.provider.getLocationPath();
        final IFeaturePlugin[] plugins = this.pluginListPage.getSelectedPlugins() != null ? this.pluginListPage.getSelectedPlugins() : new IFeaturePlugin[]{};
        final IFeatureModel featureModel = this.provider.getFeatureToPatch();
        final FeatureData data = this.provider.getFeatureData();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        NewFeaturePatchWizard.this.createFeatureProject(project, location, plugins, featureModel, data, monitor);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String property, Object data) throws CoreException {
        this.config = config;
    }

    private void createFeatureProject(IProject project, IPath location, IFeaturePlugin[] plugins, IFeatureModel featureModel, FeatureData data, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEPlugin.getResourceString(CREATING_PROJECT), 3);
        boolean overwrite = true;
        if (location.append(project.getName()).toFile().exists()) {
            overwrite = MessageDialog.openQuestion((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(KEY_WTITLE), (String)PDEPlugin.getResourceString(OVERWRITE_FEATURE));
        }
        if (overwrite) {
            CoreUtility.createProject((IProject)project, (IPath)location, (IProgressMonitor)monitor);
            project.open(monitor);
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            desc.setLocation(this.provider.getLocationPath());
            if (!project.hasNature("org.eclipse.pde.FeatureBuilder")) {
                CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.FeatureNature", (IProgressMonitor)monitor);
            }
            if (!project.hasNature("org.eclipse.jdt.core.javanature") && data.hasCustomHandler()) {
                CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
                JavaCore.create((IProject)project).setOutputLocation(project.getFullPath().append(data.getJavaBuildFolderName()), monitor);
                JavaCore.create((IProject)project).setRawClasspath(new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER)), JavaCore.newSourceEntry((IPath)project.getFullPath().append(data.getSourceFolderName()))}, monitor);
                NewFeaturePatchWizard.addSourceFolder(data.getSourceFolderName(), project, monitor);
            }
            monitor.subTask(PDEPlugin.getResourceString(CREATING_MANIFEST));
            monitor.worked(1);
            this.createBuildProperties(project, data);
            monitor.worked(1);
            IFile file = this.createFeatureManifest(project, plugins, featureModel, data);
            monitor.worked(1);
            this.openFeatureManifest(file);
        } else {
            project.create(monitor);
            project.open(monitor);
            IFile featureFile = project.getFile("feature.xml");
            if (featureFile.exists()) {
                this.openFeatureManifest(featureFile);
            }
            monitor.worked(3);
        }
    }

    protected static void addSourceFolder(String name, IProject project, IProgressMonitor monitor) throws CoreException {
        IPath path = project.getFullPath().append(name);
        NewFeaturePatchWizard.ensureFolderExists(project, path, monitor);
        monitor.worked(1);
    }

    private void createBuildProperties(IProject project, FeatureData data) throws CoreException {
        String fileName = "build.properties";
        IPath path = project.getFullPath().append(fileName);
        IFile file = project.getWorkspace().getRoot().getFile(path);
        if (!file.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(file);
            IBuildEntry ientry = model.getFactory().createEntry("bin.includes");
            ientry.addToken("feature.xml");
            String library = this.specPage.getInstallHandlerLibrary();
            if (library != null) {
                String output;
                String source = data.getSourceFolderName();
                if (source != null) {
                    IBuildEntry entry = model.getFactory().createEntry("source." + library);
                    if (!source.endsWith("/")) {
                        source = String.valueOf(source) + "/";
                    }
                    entry.addToken(source);
                    ientry.addToken(library);
                    model.getBuild().add(entry);
                }
                if ((output = data.getJavaBuildFolderName()) != null) {
                    IBuildEntry entry = model.getFactory().createEntry("output." + library);
                    if (!output.endsWith("/")) {
                        output = String.valueOf(output) + "/";
                    }
                    entry.addToken(output);
                    model.getBuild().add(entry);
                }
            }
            model.getBuild().add(ientry);
            model.save();
        }
        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.pde.ui.buildEditor");
    }

    private IFile createFeatureManifest(IProject project, IFeaturePlugin[] plugins, IFeatureModel featureModel, FeatureData data) throws CoreException {
        IFile file = project.getFile("feature.xml");
        WorkspaceFeatureModel model = new WorkspaceFeatureModel();
        model.setFile(file);
        IFeature feature = model.getFeature();
        feature.setLabel(data.name);
        feature.setId(data.id);
        feature.setVersion("1.0.0");
        feature.setProviderName(data.provider);
        if (data.hasCustomHandler) {
            feature.setInstallHandler(model.getFactory().createInstallHandler());
        }
        IFeaturePlugin[] added = new IFeaturePlugin[plugins.length];
        int i = 0;
        while (i < plugins.length) {
            added[i] = model.getFactory().createPlugin();
            String name = feature.getId();
            int loc = name.lastIndexOf(".");
            if (loc != -1 && loc != name.length()) {
                name = name.substring(loc + 1, name.length());
            }
            String[] versionSegments = plugins[i].getVersion().split("\\.");
            StringBuffer version = new StringBuffer();
            int j = 0;
            while (j < versionSegments.length) {
                if (j < 3) {
                    version.append(versionSegments[j]);
                    version.append(".");
                }
                ++j;
            }
            version.append(name);
            IStatus status = PluginVersionIdentifier.validateVersion((String)version.toString());
            if (status.isOK()) {
                added[i].setVersion(version.toString());
            } else {
                added[i].setVersion(plugins[i].getVersion());
            }
            added[i].setId(plugins[i].getId());
            added[i].setDownloadSize(plugins[i].getDownloadSize());
            added[i].setArch(plugins[i].getArch());
            added[i].setInstallSize(plugins[i].getInstallSize());
            added[i].setLabel(plugins[i].getLabel());
            added[i].setNL(plugins[i].getNL());
            added[i].setOS(plugins[i].getOS());
            added[i].setWS(plugins[i].getWS());
            ++i;
        }
        feature.addPlugins(added);
        FeatureImport featureImport = (FeatureImport)model.getFactory().createImport();
        if (featureModel != null) {
            featureImport.loadFrom(featureModel.getFeature());
            featureImport.setPatch(true);
            featureImport.setVersion(featureModel.getFeature().getVersion());
            featureImport.setId(featureModel.getFeature().getId());
        } else if (data.isPatch()) {
            featureImport.setPatch(true);
            featureImport.setVersion(data.featureToPatchVersion);
            featureImport.setId(data.featureToPatchId);
        }
        feature.addImports(new IFeatureImport[]{featureImport});
        IFeatureInstallHandler handler = feature.getInstallHandler();
        if (handler != null) {
            handler.setLibrary(this.specPage.getInstallHandlerLibrary());
        }
        IFeatureInfo info = model.getFactory().createInfo(1);
        feature.setFeatureInfo(info, 1);
        info.setURL("http://www.yourdomain.com/copyright");
        info.setDescription(PDEPlugin.getResourceString("NewFeatureWizard.sampleCopyrightDesc"));
        info = model.getFactory().createInfo(2);
        feature.setFeatureInfo(info, 2);
        info.setURL("http://www.yourdomain.com/license");
        info.setDescription(PDEPlugin.getResourceString("NewFeatureWizard.sampleLicenseDesc"));
        info = model.getFactory().createInfo(0);
        feature.setFeatureInfo(info, 0);
        info.setURL("http://www.yourdomain.com/description");
        info.setDescription(PDEPlugin.getResourceString("NewFeatureWizard.sampleDescriptionDesc"));
        model.save();
        model.dispose();
        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.pde.ui.featureEditor");
        return file;
    }

    private void openFeatureManifest(IFile manifestFile) {
        IWorkbenchPage page = PDEPlugin.getActivePage();
        StructuredSelection selection = new StructuredSelection((Object)manifestFile);
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$selection);
                }
            });
        }
        FileEditorInput input = new FileEditorInput(manifestFile);
        String id = "org.eclipse.pde.ui.featureEditor";
        try {
            page.openEditor((IEditorInput)input, id);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    private static void ensureFolderExists(IProject project, IPath folderPath, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = project.getWorkspace();
        int i = 1;
        while (i <= folderPath.segmentCount()) {
            IPath partialPath = folderPath.uptoSegment(i);
            if (!workspace.getRoot().exists(partialPath)) {
                IFolder folder = workspace.getRoot().getFolder(partialPath);
                folder.create(true, true, null);
            }
            monitor.worked(1);
            ++i;
        }
    }

    public class FeaturePatchProvider
    implements IProjectProvider {
        public String getProjectName() {
            return NewFeaturePatchWizard.this.mainPage.getProjectName();
        }

        public IProject getProject() {
            return NewFeaturePatchWizard.this.mainPage.getProjectHandle();
        }

        public IPath getLocationPath() {
            return NewFeaturePatchWizard.this.mainPage.getLocationPath();
        }

        public IFeatureModel getFeatureToPatch() {
            if (NewFeaturePatchWizard.this.specPage != null) {
                return NewFeaturePatchWizard.this.specPage.getFeatureToPatch();
            }
            return null;
        }

        public FeatureData getFeatureData() {
            return NewFeaturePatchWizard.this.specPage.getFeatureData();
        }
    }
}

