/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.ui.IPluginFieldData;

public class ApplicationClassCodeGenerator {
    private IPluginFieldData fPluginData;
    private IProject fProject;

    public ApplicationClassCodeGenerator(IProject project, IPluginFieldData data) {
        this.fProject = project;
        this.fPluginData = data;
    }

    public IFile generate(IProgressMonitor monitor) throws CoreException {
        String qualifiedName = this.fPluginData.getApplicationClassname();
        int nameloc = qualifiedName.lastIndexOf(46);
        String packageName = nameloc == -1 ? "" : qualifiedName.substring(0, nameloc);
        String className = qualifiedName.substring(nameloc + 1);
        Path path = new Path(packageName.replace('.', '/'));
        if (this.fPluginData.getSourceFolderName().trim().length() > 0) {
            path = new Path(this.fPluginData.getSourceFolderName()).append((IPath)path);
        }
        CoreUtility.createFolder((IFolder)this.fProject.getFolder((IPath)path), (boolean)true, (boolean)true, null);
        IFile file = this.fProject.getFile(path.append(String.valueOf(className) + ".java"));
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.generateApplicationClass(packageName, className, writer);
        writer.flush();
        try {
            swriter.close();
            ByteArrayInputStream stream = new ByteArrayInputStream(swriter.toString().getBytes(this.fProject.getDefaultCharset()));
            if (file.exists()) {
                file.setContents((InputStream)stream, false, true, monitor);
            } else {
                file.create((InputStream)stream, false, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        this.generateWorkbenchAdvisor((IPath)path, packageName);
        this.generatePerspectiveClass((IPath)path, packageName);
        return file;
    }

    private void generateWorkbenchAdvisor(IPath path, String packageName) throws CoreException {
        IFile file = this.fProject.getFile(path.append("SampleWorkbenchAdvisor.java"));
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        if (!packageName.equals("")) {
            writer.println("package " + packageName + ";");
            writer.println();
        }
        writer.println("import org.eclipse.swt.graphics.Point;");
        writer.println("import org.eclipse.ui.application.IWorkbenchWindowConfigurer;");
        writer.println("import org.eclipse.ui.application.WorkbenchAdvisor;");
        writer.println();
        writer.println("public class SampleWorkbenchAdvisor extends WorkbenchAdvisor {");
        writer.println();
        writer.println("\tpublic String getInitialWindowPerspectiveId() {");
        writer.println("\t\treturn \"" + this.fPluginData.getId() + ".samplePerspective\";");
        writer.println("\t}");
        writer.println();
        writer.println("\tpublic void preWindowOpen(IWorkbenchWindowConfigurer configurer) {");
        writer.println("\t\tsuper.preWindowOpen(configurer);");
        writer.println("\t\tconfigurer.setInitialSize(new Point(400, 300));");
        writer.println("\t\tconfigurer.setShowCoolBar(false);");
        writer.println("\t\tconfigurer.setShowStatusLine(false);");
        writer.println("\t\tconfigurer.setTitle(\"Hello RCP\");");
        writer.println("\t}");
        writer.println("}");
        writer.flush();
        try {
            swriter.close();
            ByteArrayInputStream stream = new ByteArrayInputStream(swriter.toString().getBytes(this.fProject.getDefaultCharset()));
            if (file.exists()) {
                file.setContents((InputStream)stream, false, true, null);
            } else {
                file.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (IOException iOException) {}
    }

    private void generatePerspectiveClass(IPath path, String packageName) throws CoreException {
        IFile file = this.fProject.getFile(path.append("SamplePerspective.java"));
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        if (!packageName.equals("")) {
            writer.println("package " + packageName + ";");
            writer.println();
        }
        writer.println("import org.eclipse.ui.IPageLayout;");
        writer.println("import org.eclipse.ui.IPerspectiveFactory;");
        writer.println();
        writer.println("public class SamplePerspective implements IPerspectiveFactory {");
        writer.println();
        writer.println("\tpublic void createInitialLayout(IPageLayout layout) {");
        writer.println("\t}");
        writer.println("}");
        writer.flush();
        try {
            swriter.close();
            ByteArrayInputStream stream = new ByteArrayInputStream(swriter.toString().getBytes(this.fProject.getDefaultCharset()));
            if (file.exists()) {
                file.setContents((InputStream)stream, false, true, null);
            } else {
                file.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (IOException iOException) {}
    }

    private void generateApplicationClass(String packageName, String className, PrintWriter writer) {
        if (!packageName.equals("")) {
            writer.println("package " + packageName + ";");
            writer.println();
        }
        writer.println("import org.eclipse.core.runtime.IPlatformRunnable;");
        writer.println("import org.eclipse.swt.widgets.Display;");
        writer.println("import org.eclipse.ui.PlatformUI;");
        writer.println();
        writer.println("/**");
        writer.println(" * This class controls all aspects of the application's execution");
        writer.println(" */");
        writer.println("public class " + className + " implements IPlatformRunnable {");
        writer.println();
        writer.println("\t/* (non-Javadoc)");
        writer.println("\t * @see org.eclipse.core.runtime.IPlatformRunnable#run(java.lang.Object)");
        writer.println("\t */");
        writer.println("\tpublic Object run(Object args) throws Exception {");
        writer.println("\t\tDisplay display = PlatformUI.createDisplay();");
        writer.println("\t\ttry {");
        writer.println("\t\t\tint returnCode = PlatformUI.createAndRunWorkbench(display, new SampleWorkbenchAdvisor());");
        writer.println("\t\t\tif (returnCode == PlatformUI.RETURN_RESTART) {");
        writer.println("\t\t\t\treturn IPlatformRunnable.EXIT_RESTART;");
        writer.println("\t\t\t}");
        writer.println("\t\t\treturn IPlatformRunnable.EXIT_OK;");
        writer.println("\t\t} finally {");
        writer.println("\t\t\tdisplay.dispose();");
        writer.println("\t\t}");
        writer.println("\t}");
        writer.println("}");
    }
}

