/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.PDETemplateSection;
import org.eclipse.pde.internal.ui.wizards.templates.PluginReference;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.templates.BooleanOption;
import org.eclipse.pde.ui.templates.TemplateOption;

public class BuilderTemplate
extends PDETemplateSection {
    private static final String KEY_BUILDER_CLASS_NAME = "builderClassName";
    private static final String KEY_BUILDER_ID = "builderId";
    private static final String KEY_BUILDER_NAME = "builderName";
    private static final String KEY_NATURE_CLASS_NAME = "natureClassName";
    private static final String KEY_NATURE_ID = "natureId";
    private static final String KEY_NATURE_NAME = "natureName";
    private static final String KEY_GEN_ACTION = "genAction";
    private static final String NL_TITLE = "BuilderTemplate.title";
    private static final String NL_DESC = "BuilderTemplate.desc";
    private static final String NL_BUILDER_CLASS_NAME = "BuilderTemplate.builderClass";
    private static final String NL_BUILDER_ID = "BuilderTemplate.builderId";
    private static final String NL_BUILDER_NAME = "BuilderTemplate.builderName";
    private static final String NL_NATURE_CLASS_NAME = "BuilderTemplate.natureClass";
    private static final String NL_NATURE_ID = "BuilderTemplate.natureId";
    private static final String NL_NATURE_NAME = "BuilderTemplate.natureName";
    private static final String NL_PACKAGE_LABEL = "BuilderTemplate.packageLabel";
    private static final String NL_ACTION_LABEL = "BuilderTemplate.actionLabel";
    private static final String NL_DEFAULT_BUILDER_NAME = "BuilderTemplate.defaultBuilderName";
    private static final String NL_DEFAULT_NATURE_NAME = "BuilderTemplate.defaultNatureName";
    private static final String NL_MARKER_NAME = "BuilderTemplate.markerName";
    private static final String NL_GEN_ACTION = "BuilderTemplate.generateAction";
    private BooleanOption actionOption;

    public BuilderTemplate() {
        this.setPageCount(1);
        this.createOptions();
    }

    public String getSectionId() {
        return "builder";
    }

    public int getNumberOfWorkUnits() {
        return super.getNumberOfWorkUnits() + 1;
    }

    private void createOptions() {
        this.addOption("packageName", PDEPlugin.getResourceString(NL_PACKAGE_LABEL), null, 0);
        this.addOption(KEY_BUILDER_CLASS_NAME, PDEPlugin.getResourceString(NL_BUILDER_CLASS_NAME), "SampleBuilder", 0);
        this.addOption(KEY_BUILDER_ID, PDEPlugin.getResourceString(NL_BUILDER_ID), "sampleBuilder", 0);
        this.addOption(KEY_BUILDER_NAME, PDEPlugin.getResourceString(NL_BUILDER_NAME), PDEPlugin.getResourceString(NL_DEFAULT_BUILDER_NAME), 0);
        this.addOption(KEY_NATURE_CLASS_NAME, PDEPlugin.getResourceString(NL_NATURE_CLASS_NAME), "SampleNature", 0);
        this.addOption(KEY_NATURE_ID, PDEPlugin.getResourceString(NL_NATURE_ID), "sampleNature", 0);
        this.addOption(KEY_NATURE_NAME, PDEPlugin.getResourceString(NL_NATURE_NAME), PDEPlugin.getResourceString(NL_DEFAULT_NATURE_NAME), 0);
        this.actionOption = (BooleanOption)this.addOption(KEY_GEN_ACTION, PDEPlugin.getResourceString(NL_GEN_ACTION), true, 0);
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.pde.doc.user.template_builder");
        page.setTitle(PDEPlugin.getResourceString(NL_TITLE));
        page.setDescription(PDEPlugin.getResourceString(NL_DESC));
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    public void validateOptions(TemplateOption source) {
        if (source.isRequired() && source.isEmpty()) {
            this.flagMissingRequiredOption(source);
        } else {
            this.validateContainerPage(source);
        }
    }

    private void validateContainerPage(TemplateOption source) {
        TemplateOption[] allPageOptions = this.getOptions(0);
        int i = 0;
        while (i < allPageOptions.length) {
            TemplateOption nextOption = allPageOptions[i];
            if (nextOption.isRequired() && nextOption.isEmpty()) {
                this.flagMissingRequiredOption(nextOption);
                return;
            }
            ++i;
        }
        this.resetPageState();
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    protected void initializeFields(IFieldData data) {
        String id = data.getId();
        this.initializeOption("packageName", this.getFormattedPackageName(id));
    }

    public void initializeFields(IPluginModelBase model) {
        String pluginId = model.getPluginBase().getId();
        this.initializeOption("packageName", this.getFormattedPackageName(pluginId));
    }

    public String getUsedExtensionPoint() {
        return null;
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginModelFactory factory = this.model.getPluginFactory();
        IPluginExtension extension1 = this.createExtension("org.eclipse.core.resources.builders", true);
        extension1.setId(this.getStringOption(KEY_BUILDER_ID));
        extension1.setName(this.getStringOption(KEY_BUILDER_NAME));
        IPluginElement builder = factory.createElement((IPluginObject)extension1);
        builder.setName("builder");
        builder.setAttribute("hasNature", "true");
        extension1.add((IPluginObject)builder);
        IPluginElement run = factory.createElement((IPluginObject)builder);
        run.setName("run");
        run.setAttribute("class", String.valueOf(this.getStringOption("packageName")) + "." + this.getStringOption(KEY_BUILDER_CLASS_NAME));
        builder.add((IPluginObject)run);
        if (!extension1.isInTheModel()) {
            plugin.add(extension1);
        }
        IPluginExtension extension2 = this.createExtension("org.eclipse.core.resources.natures", true);
        extension2.setId(this.getStringOption(KEY_NATURE_ID));
        extension2.setName(this.getStringOption(KEY_NATURE_NAME));
        IPluginElement runtime = factory.createElement((IPluginObject)extension2);
        runtime.setName("runtime");
        extension2.add((IPluginObject)runtime);
        IPluginElement run2 = factory.createElement((IPluginObject)runtime);
        run2.setName("run");
        run2.setAttribute("class", String.valueOf(this.getStringOption("packageName")) + "." + this.getStringOption(KEY_NATURE_CLASS_NAME));
        runtime.add((IPluginObject)run2);
        IPluginElement builder2 = factory.createElement((IPluginObject)extension2);
        builder2.setName("builder");
        builder2.setAttribute("id", String.valueOf(this.model.getPluginBase().getId()) + "." + this.getStringOption(KEY_BUILDER_ID));
        extension2.add((IPluginObject)builder2);
        if (!extension2.isInTheModel()) {
            plugin.add(extension2);
        }
        if (this.actionOption.isSelected()) {
            IPluginExtension extension3 = this.createExtension("org.eclipse.ui.popupMenus", true);
            IPluginElement objectContribution = factory.createElement((IPluginObject)extension3);
            objectContribution.setName("objectContribution");
            objectContribution.setAttribute("objectClass", "org.eclipse.core.resources.IProject");
            objectContribution.setAttribute("adaptable", "true");
            objectContribution.setAttribute("nameFilter", "*");
            objectContribution.setAttribute("id", String.valueOf(this.model.getPluginBase().getId()) + ".contribution1");
            extension3.add((IPluginObject)objectContribution);
            IPluginElement action = factory.createElement((IPluginObject)objectContribution);
            action.setName("action");
            action.setAttribute("label", PDEPlugin.getResourceString(NL_ACTION_LABEL));
            action.setAttribute("class", String.valueOf(this.getStringOption("packageName")) + ".ToggleNatureAction");
            action.setAttribute("menubarPath", "additions");
            action.setAttribute("enablesFor", "+");
            action.setAttribute("id", String.valueOf(this.model.getPluginBase().getId()) + ".addRemoveNatureAction");
            objectContribution.add((IPluginObject)action);
            if (!extension3.isInTheModel()) {
                plugin.add(extension3);
            }
        }
        IPluginExtension extension4 = this.createExtension("org.eclipse.core.resources.markers", true);
        extension4.setId("xmlProblem");
        extension4.setName(PDEPlugin.getResourceString(NL_MARKER_NAME));
        IPluginElement superElement = factory.createElement((IPluginObject)extension4);
        superElement.setName("super");
        superElement.setAttribute("type", "org.eclipse.core.resources.problemmarker");
        extension4.add((IPluginObject)superElement);
        IPluginElement persistent = factory.createElement((IPluginObject)extension4);
        persistent.setName("persistent");
        persistent.setAttribute("value", "true");
        extension4.add((IPluginObject)persistent);
        if (!extension4.isInTheModel()) {
            plugin.add(extension4);
        }
    }

    public IPluginReference[] getDependencies(String schemaVersion) {
        ArrayList<PluginReference> result = new ArrayList<PluginReference>();
        result.add(new PluginReference("org.eclipse.core.resources", null, 0));
        if (schemaVersion != null) {
            result.add(new PluginReference("org.eclipse.core.runtime", null, 0));
        }
        if (this.actionOption.isSelected()) {
            result.add(new PluginReference("org.eclipse.ui", null, 0));
        }
        return result.toArray(new IPluginReference[result.size()]);
    }

    protected String getFormattedPackageName(String id) {
        String packageName = super.getFormattedPackageName(id);
        if (packageName.length() != 0) {
            return String.valueOf(packageName) + ".builder";
        }
        return "builder";
    }

    protected boolean isOkToCreateFile(File sourceFile) {
        String fileName = sourceFile.getName();
        if (fileName.equals("ToggleNatureAction.java")) {
            return this.actionOption.isSelected();
        }
        return true;
    }
}

