/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.PDETemplateSection;
import org.eclipse.pde.internal.ui.wizards.templates.PluginReference;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.templates.TemplateOption;

public class MailTemplate
extends PDETemplateSection {
    public static final String KEY_PRODUCT_NAME = "productName";
    public static final String KEY_PRODUCT_ID = "productID";
    public static final String KEY_CLOSEABLE = "closeable";
    public static final String KEY_NON_CLOSEABLE = "noncloseable";
    public static final String KEY_PERSPECTIVE_NAME = "perspectiveName";
    public static final String KEY_WORKBENCH_ADVISOR = "advisor";
    public static final String KEY_APPLICATION_CLASS = "applicationClass";

    public MailTemplate() {
        this.setPageCount(1);
        this.createOptions();
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.pde.doc.user.rcp_mail");
        page.setTitle(PDEPlugin.getResourceString("MailTemplate.title"));
        page.setDescription(PDEPlugin.getResourceString("MailTemplate.desc"));
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    private void createOptions() {
        this.addOption(KEY_PRODUCT_NAME, PDEPlugin.getResourceString("MailTemplate.productName"), "RCP Product", 0);
        this.addOption(KEY_PRODUCT_ID, PDEPlugin.getResourceString("MailTemplate.productID"), "product", 0);
        this.addOption(KEY_PERSPECTIVE_NAME, PDEPlugin.getResourceString("MailTemplate.perspectiveName"), "Sample Perspective", 0);
        this.addOption("packageName", PDEPlugin.getResourceString("MailTemplate.packageName"), null, 0);
        this.addOption(KEY_CLOSEABLE, PDEPlugin.getResourceString("MailTemplate.closeable"), "SampleView", 0);
        this.addOption(KEY_NON_CLOSEABLE, PDEPlugin.getResourceString("MailTemplate.non-closeable"), "NoncloseableView", 0);
        this.addOption(KEY_WORKBENCH_ADVISOR, PDEPlugin.getResourceString("MailTemplate.advisor"), "SampleWorkbenchAdvisor", 0);
    }

    protected void initializeFields(IFieldData data) {
        String id = data.getId();
        this.initializeOption("packageName", String.valueOf(this.getFormattedPackageName(id)) + ".rcp");
    }

    public void initializeFields(IPluginModelBase model) {
        String pluginId = model.getPluginBase().getId();
        this.initializeOption("packageName", String.valueOf(this.getFormattedPackageName(pluginId)) + ".rcp");
    }

    public String getReplacementString(String fileName, String key) {
        IPluginElement element;
        String name;
        int dot;
        if (key.equals(KEY_APPLICATION_CLASS) && (dot = (name = (element = this.getAppRunElement()).getAttribute("class").getValue()).lastIndexOf(46)) != -1) {
            return name.substring(dot + 1);
        }
        return super.getReplacementString(fileName, key);
    }

    public String getSectionId() {
        return "mail";
    }

    public void validateOptions(TemplateOption source) {
        if (source.isRequired() && source.isEmpty()) {
            this.flagMissingRequiredOption(source);
        } else {
            this.validateContainerPage(source);
        }
    }

    private void validateContainerPage(TemplateOption source) {
        TemplateOption[] allPageOptions = this.getOptions(0);
        int i = 0;
        while (i < allPageOptions.length) {
            TemplateOption nextOption = allPageOptions[i];
            if (nextOption.isRequired() && nextOption.isEmpty()) {
                this.flagMissingRequiredOption(nextOption);
                return;
            }
            ++i;
        }
        this.resetPageState();
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        this.updateApplicationClass();
        this.createPerspectiveExtension();
        this.createViewExtension();
        this.createCommandExtension();
        this.createProductExtension();
    }

    private void updateApplicationClass() throws CoreException {
        IPluginElement element = this.getAppRunElement();
        String name = element.getAttribute("class").getValue();
        int dot = name.lastIndexOf(46);
        name = dot != -1 ? String.valueOf(this.getStringOption("packageName")) + name.substring(dot) : String.valueOf(this.getStringOption("packageName")) + "." + name;
        element.setAttribute("class", name);
    }

    private IPluginElement getAppRunElement() {
        IPluginExtension ext = this.getAppExtension();
        IPluginElement app = (IPluginElement)ext.getChildren()[0];
        return (IPluginElement)app.getChildren()[0];
    }

    private IPluginExtension getAppExtension() {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension[] extensions = plugin.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IPluginExtension ext = extensions[i];
            if ("org.eclipse.core.runtime.applications".equals(ext.getPoint())) {
                return ext;
            }
            ++i;
        }
        return null;
    }

    private void createPerspectiveExtension() throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension("org.eclipse.ui.perspectives", true);
        IPluginElement element = this.model.getPluginFactory().createElement((IPluginObject)extension);
        element.setName("perspective");
        element.setAttribute("class", String.valueOf(this.getStringOption("packageName")) + ".Perspective");
        element.setAttribute("name", this.getStringOption(KEY_PERSPECTIVE_NAME));
        element.setAttribute("id", String.valueOf(plugin.getId()) + ".perspective");
        extension.add((IPluginObject)element);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
    }

    private void createViewExtension() throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        String id = plugin.getId();
        IPluginExtension extension = this.createExtension("org.eclipse.ui.views", true);
        IPluginElement view = this.model.getPluginFactory().createElement((IPluginObject)extension);
        view.setName("view");
        view.setAttribute("allowMultiple", "true");
        view.setAttribute("icon", "icons/sample2.gif");
        view.setAttribute("class", String.valueOf(this.getStringOption("packageName")) + "." + this.getStringOption(KEY_CLOSEABLE));
        view.setAttribute("name", "Message");
        view.setAttribute("id", String.valueOf(id) + "." + this.getStringOption(KEY_CLOSEABLE));
        extension.add((IPluginObject)view);
        view = this.model.getPluginFactory().createElement((IPluginObject)extension);
        view.setName("view");
        view.setAttribute("allowMultiple", "true");
        view.setAttribute("icon", "icons/sample3.gif");
        view.setAttribute("class", String.valueOf(this.getStringOption("packageName")) + "." + this.getStringOption(KEY_NON_CLOSEABLE));
        view.setAttribute("name", "Mailboxes");
        view.setAttribute("id", String.valueOf(id) + "." + this.getStringOption(KEY_NON_CLOSEABLE));
        extension.add((IPluginObject)view);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
    }

    private void createCommandExtension() throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        String id = plugin.getId();
        IPluginExtension extension = this.createExtension("org.eclipse.ui.commands", true);
        IPluginElement element = this.model.getPluginFactory().createElement((IPluginObject)extension);
        element.setName("command");
        element.setAttribute("description", "Opens a mailbox");
        element.setAttribute("name", "Open Mailbox");
        element.setAttribute("id", String.valueOf(id) + ".open");
        extension.add((IPluginObject)element);
        element = this.model.getPluginFactory().createElement((IPluginObject)extension);
        element.setName("command");
        element.setAttribute("description", "Open a message dialog");
        element.setAttribute("name", "Open Message Dialog");
        element.setAttribute("id", String.valueOf(id) + ".openMessage");
        extension.add((IPluginObject)element);
        element = this.model.getPluginFactory().createElement((IPluginObject)extension);
        element.setName("keyConfiguration");
        element.setAttribute("description", "The key configuration for this sample");
        element.setAttribute("name", String.valueOf(id) + ".keyConfiguration");
        element.setAttribute("id", String.valueOf(id) + ".keyConfiguration");
        extension.add((IPluginObject)element);
        element = this.model.getPluginFactory().createElement((IPluginObject)extension);
        element.setName("keyBinding");
        element.setAttribute("commandId", String.valueOf(id) + ".open");
        element.setAttribute("keySequence", "CTRL+2");
        element.setAttribute("keyConfigurationId", "org.eclipse.ui.defaultAcceleratorConfiguration");
        extension.add((IPluginObject)element);
        element = this.model.getPluginFactory().createElement((IPluginObject)extension);
        element.setName("keyBinding");
        element.setAttribute("commandId", String.valueOf(id) + ".openMessage");
        element.setAttribute("keySequence", "CTRL+3");
        element.setAttribute("keyConfigurationId", "org.eclipse.ui.defaultAcceleratorConfiguration");
        extension.add((IPluginObject)element);
        element = this.model.getPluginFactory().createElement((IPluginObject)extension);
        element.setName("keyBinding");
        element.setAttribute("commandId", "org.eclipse.ui.file.exit");
        element.setAttribute("keySequence", "CTRL+X");
        element.setAttribute("keyConfigurationId", "org.eclipse.ui.defaultAcceleratorConfiguration");
        extension.add((IPluginObject)element);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
    }

    private void createProductExtension() throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension("org.eclipse.core.runtime.products", true);
        extension.setId(this.getStringOption(KEY_PRODUCT_ID));
        IPluginElement element = this.model.getFactory().createElement((IPluginObject)extension);
        element.setName("product");
        element.setAttribute("name", this.getStringOption(KEY_PRODUCT_NAME));
        element.setAttribute("application", String.valueOf(plugin.getId()) + "." + this.getAppExtension().getId());
        IPluginElement property = this.model.getFactory().createElement((IPluginObject)element);
        property.setName("property");
        property.setAttribute("name", "aboutText");
        property.setAttribute("value", "%aboutText");
        element.add((IPluginObject)property);
        property = this.model.getFactory().createElement((IPluginObject)element);
        property.setName("property");
        property.setAttribute("name", "windowImage");
        property.setAttribute("value", "icons/sample2.gif");
        element.add((IPluginObject)property);
        property = this.model.getFactory().createElement((IPluginObject)element);
        property.setName("property");
        property.setAttribute("name", "aboutImage");
        property.setAttribute("value", "product_lg.gif");
        element.add((IPluginObject)property);
        extension.add((IPluginObject)element);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
    }

    public String getUsedExtensionPoint() {
        return null;
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    public int getNumberOfWorkUnits() {
        return super.getNumberOfWorkUnits() + 1;
    }

    public IPluginReference[] getDependencies(String schemaVersion) {
        IPluginReference[] dep = new IPluginReference[]{new PluginReference("org.eclipse.core.runtime", null, 0), new PluginReference("org.eclipse.ui", null, 0)};
        return dep;
    }

    public String[] getNewFiles() {
        return new String[]{"icons/", "plugin.properties", "product_lg.gif", "splash.bmp"};
    }
}

