/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.PDETemplateSection;
import org.eclipse.pde.internal.ui.wizards.templates.PluginReference;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.templates.TemplateOption;

public class PropertyPageTemplate
extends PDETemplateSection {
    public static final String KEY_CLASSNAME = "className";
    public static final String KEY_PAGE_NAME = "pageName";
    public static final String KEY_TARGET_CLASS = "targetClass";
    public static final String KEY_NAME_FILTER = "nameFilter";
    private static final String NL_TITLE = "PropertyPageTemplate.title";
    private static final String NL_DESC = "PropertyPageTemplate.desc";
    private static final String NL_PACKAGE_NAME = "PropertyPageTemplate.packageName";
    private static final String NL_PAGE_CLASS = "PropertyPageTemplate.pageClass";
    private static final String NL_PAGE_NAME = "PropertyPageTemplate.pageName";
    private static final String NL_DEFAULT_PAGE_NAME = "PropertyPageTemplate.defaultPageName";
    private static final String NL_TARGET_CLASS = "PropertyPageTemplate.targetClass";
    private static final String NL_NAME_FILTER = "PropertyPageTemplate.nameFilter";

    public PropertyPageTemplate() {
        this.setPageCount(1);
        this.createOptions();
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.pde.doc.user.template_property_page");
        page.setTitle(PDEPlugin.getResourceString(NL_TITLE));
        page.setDescription(PDEPlugin.getResourceString(NL_DESC));
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    private void createOptions() {
        this.addOption("packageName", PDEPlugin.getResourceString(NL_PACKAGE_NAME), null, 0);
        this.addOption(KEY_CLASSNAME, PDEPlugin.getResourceString(NL_PAGE_CLASS), "SamplePropertyPage", 0);
        this.addOption(KEY_PAGE_NAME, PDEPlugin.getResourceString(NL_PAGE_NAME), PDEPlugin.getResourceString(NL_DEFAULT_PAGE_NAME), 0);
        this.addOption(KEY_TARGET_CLASS, PDEPlugin.getResourceString(NL_TARGET_CLASS), "org.eclipse.core.resources.IFile", 0);
        this.addOption(KEY_NAME_FILTER, PDEPlugin.getResourceString(NL_NAME_FILTER), "*.*", 0);
    }

    public String getSectionId() {
        return "propertyPages";
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    protected void initializeFields(IFieldData data) {
        String id = data.getId();
        this.initializeOption("packageName", this.getFormattedPackageName(id));
    }

    public void initializeFields(IPluginModelBase model) {
        String pluginId = model.getPluginBase().getId();
        this.initializeOption("packageName", this.getFormattedPackageName(pluginId));
    }

    public void validateOptions(TemplateOption source) {
        if (source.isRequired() && source.isEmpty()) {
            this.flagMissingRequiredOption(source);
        } else {
            this.validateContainerPage(source);
        }
    }

    private void validateContainerPage(TemplateOption source) {
        TemplateOption[] allPageOptions = this.getOptions(0);
        int i = 0;
        while (i < allPageOptions.length) {
            TemplateOption nextOption = allPageOptions[i];
            if (nextOption.isRequired() && nextOption.isEmpty()) {
                this.flagMissingRequiredOption(nextOption);
                return;
            }
            ++i;
        }
        this.resetPageState();
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension(this.getUsedExtensionPoint(), true);
        IPluginModelFactory factory = this.model.getPluginFactory();
        IPluginElement pageElement = factory.createElement((IPluginObject)extension);
        pageElement.setName("page");
        pageElement.setAttribute("id", String.valueOf(this.getStringOption("packageName")) + ".samplePropertyPage");
        pageElement.setAttribute("name", this.getStringOption(KEY_PAGE_NAME));
        pageElement.setAttribute("objectClass", this.getStringOption(KEY_TARGET_CLASS));
        pageElement.setAttribute("class", String.valueOf(this.getStringOption("packageName")) + "." + this.getStringOption(KEY_CLASSNAME));
        pageElement.setAttribute(KEY_NAME_FILTER, this.getStringOption(KEY_NAME_FILTER));
        extension.add((IPluginObject)pageElement);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
    }

    public String getUsedExtensionPoint() {
        return "org.eclipse.ui.propertyPages";
    }

    public IPluginReference[] getDependencies(String schemaVersion) {
        ArrayList<PluginReference> result = new ArrayList<PluginReference>();
        result.add(new PluginReference("org.eclipse.core.resources", null, 0));
        if (schemaVersion != null) {
            result.add(new PluginReference("org.eclipse.core.runtime", null, 0));
        }
        result.add(new PluginReference("org.eclipse.ui", null, 0));
        return result.toArray(new IPluginReference[result.size()]);
    }

    protected String getFormattedPackageName(String id) {
        String packageName = super.getFormattedPackageName(id);
        if (packageName.length() != 0) {
            return String.valueOf(packageName) + ".properties";
        }
        return "properties";
    }
}

