/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CHyperLink
extends Canvas {
    protected Label fWidget;
    private boolean fArmed;
    private boolean fHasMouseFocus;
    private Set fListeners = new HashSet();

    public CHyperLink(Composite parent, int style) {
        super(parent, 0x400000);
        this.fWidget = new Label((Composite)this, 0);
        this.markUnarmed();
        this.setLayout((Layout)new FillLayout());
        this.fWidget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CHyperLink.this.forceFocus();
                if (e.button == 1) {
                    if (CHyperLink.this.fHasMouseFocus) {
                        CHyperLink.this.markArmed();
                    }
                    CHyperLink.this.fArmed = true;
                    CHyperLink.this.fWidget.redraw();
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    if (CHyperLink.this.fHasMouseFocus && CHyperLink.this.fArmed) {
                        CHyperLink.this.fireSelected();
                    }
                    if (CHyperLink.this.fHasMouseFocus) {
                        CHyperLink.this.markMouseFocus();
                    }
                    CHyperLink.this.fArmed = false;
                    CHyperLink.this.fWidget.redraw();
                }
            }
        });
        this.fWidget.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (CHyperLink.this.fArmed) {
                    CHyperLink.this.markArmed();
                } else {
                    CHyperLink.this.markMouseFocus();
                }
                CHyperLink.this.fHasMouseFocus = true;
                CHyperLink.this.fWidget.setCursor(CHyperLink.this.fWidget.getDisplay().getSystemCursor(21));
                CHyperLink.this.fWidget.redraw();
            }

            public void mouseExit(MouseEvent e) {
                if (CHyperLink.this.fArmed) {
                    CHyperLink.this.markUnarmed();
                } else {
                    CHyperLink.this.markNoMouseFocus();
                }
                CHyperLink.this.fHasMouseFocus = false;
                CHyperLink.this.fWidget.setCursor(null);
                CHyperLink.this.fWidget.redraw();
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 32 && e.stateMask == 0) {
                    CHyperLink.this.fireSelected();
                }
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 8: 
                    case 16: {
                        if (CHyperLink.this.fArmed) break;
                        e.doit = true;
                    }
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CHyperLink.this.fWidget.redraw();
            }

            public void focusLost(FocusEvent e) {
                CHyperLink.this.fWidget.redraw();
            }
        });
        this.fWidget.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                boolean hasInputFocus = CHyperLink.this.isFocusControl();
                Color foreground = this.getForeground(hasInputFocus);
                CHyperLink.this.fWidget.setForeground(foreground);
                GC gc = e.gc;
                Rectangle bounds = CHyperLink.this.fWidget.getBounds();
                gc.setLineStyle(1);
                gc.setLineWidth(1);
                gc.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width, bounds.y + bounds.height - 1);
                if (hasInputFocus) {
                    gc.drawFocus(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }

            private Color getForeground(boolean hasInputFocus) {
                if (CHyperLink.this.fHasMouseFocus) {
                    if (CHyperLink.this.fArmed) {
                        return CHyperLink.this.fWidget.getDisplay().getSystemColor(12);
                    }
                    return CHyperLink.this.fWidget.getDisplay().getSystemColor(9);
                }
                return CHyperLink.this.fWidget.getDisplay().getSystemColor(10);
            }
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.fListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.fListeners.remove(listener);
    }

    public String getText() {
        return this.fWidget.getText();
    }

    public void setText(String string) {
        this.fWidget.setText(string);
    }

    private void markUnarmed() {
    }

    private void markArmed() {
    }

    private void markMouseFocus() {
    }

    private void markNoMouseFocus() {
    }

    private void fireSelected() {
        SelectionListener[] listeners = this.fListeners.toArray(new SelectionListener[this.fListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            final SelectionListener listener = listeners[i];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    Event baseEvent = new Event();
                    baseEvent.widget = CHyperLink.this.fWidget;
                    SelectionEvent event = new SelectionEvent(baseEvent);
                    listener.widgetSelected(event);
                }
            });
            ++i;
        }
    }

    public void dispose() {
        this.fListeners.clear();
        super.dispose();
    }
}

