/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.Assert;
import org.eclipse.ltk.internal.core.refactoring.NotCancelableProgressMonitor;

public class PerformChangeOperation
implements IWorkspaceRunnable {
    private Change fChange;
    private CreateChangeOperation fCreateChangeOperation;
    private RefactoringStatus fValidationStatus;
    private Change fUndoChange;
    private String fUndoName;
    private IUndoManager fUndoManager;
    private boolean fChangeExecuted;
    private boolean fChangeExecutionFailed;

    public PerformChangeOperation(Change change) {
        Assert.isNotNull(change);
        this.fChange = change;
    }

    public PerformChangeOperation(CreateChangeOperation op) {
        Assert.isNotNull(op);
        this.fCreateChangeOperation = op;
    }

    public boolean changeExecutionFailed() {
        return this.fChangeExecutionFailed;
    }

    public boolean changeExecuted() {
        return this.fChangeExecuted;
    }

    public RefactoringStatus getConditionCheckingStatus() {
        if (this.fCreateChangeOperation != null) {
            return this.fCreateChangeOperation.getConditionCheckingStatus();
        }
        return null;
    }

    public Change getChange() {
        return this.fChange;
    }

    public Change getUndoChange() {
        return this.fUndoChange;
    }

    public RefactoringStatus getValidationStatus() {
        return this.fValidationStatus;
    }

    public void setUndoManager(IUndoManager manager, String undoName) {
        if (manager != null) {
            Assert.isNotNull(undoName);
        }
        this.fUndoManager = manager;
        this.fUndoName = undoName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        try {
            this.fChangeExecuted = false;
            if (this.createChange()) {
                pm.beginTask("", 2);
                pm.subTask("");
                this.fCreateChangeOperation.run((IProgressMonitor)new SubProgressMonitor(pm, 1));
                this.fChange = this.fCreateChangeOperation.getChange();
                if (this.fChange != null) {
                    this.executeChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
                } else {
                    pm.worked(1);
                }
            } else {
                this.executeChange(pm);
            }
            Object var2_4 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
    }

    protected void executeChange(IProgressMonitor pm) throws CoreException {
        this.fChangeExecuted = false;
        if (!this.fChange.isEnabled()) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                block21: {
                    block20: {
                        boolean undoInitialized = false;
                        try {
                            try {
                                monitor.beginTask("", 10);
                                PerformChangeOperation.this.fValidationStatus = PerformChangeOperation.this.fChange.isValid((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                if (PerformChangeOperation.this.fValidationStatus.hasFatalError()) {
                                    Object var6_3 = null;
                                    break block20;
                                }
                                boolean aboutToPerformChangeCalled = false;
                                try {
                                    if (PerformChangeOperation.this.fUndoManager != null) {
                                        ResourcesPlugin.getWorkspace().checkpoint(false);
                                        PerformChangeOperation.this.fUndoManager.aboutToPerformChange(PerformChangeOperation.this.fChange);
                                        aboutToPerformChangeCalled = true;
                                    }
                                    PerformChangeOperation.this.fChangeExecutionFailed = true;
                                    PerformChangeOperation.this.fUndoChange = PerformChangeOperation.this.fChange.perform((IProgressMonitor)new SubProgressMonitor(monitor, 9));
                                    PerformChangeOperation.this.fChangeExecutionFailed = false;
                                    PerformChangeOperation.this.fChangeExecuted = true;
                                }
                                catch (Throwable throwable) {
                                    Object var4_10 = null;
                                    if (PerformChangeOperation.this.fUndoManager == null) throw throwable;
                                    ResourcesPlugin.getWorkspace().checkpoint(false);
                                    if (!aboutToPerformChangeCalled) throw throwable;
                                    PerformChangeOperation.this.fUndoManager.changePerformed(PerformChangeOperation.this.fChange);
                                    throw throwable;
                                }
                                {
                                    Object var4_11 = null;
                                }
                                if (PerformChangeOperation.this.fUndoManager != null) {
                                    ResourcesPlugin.getWorkspace().checkpoint(false);
                                    if (aboutToPerformChangeCalled) {
                                        PerformChangeOperation.this.fUndoManager.changePerformed(PerformChangeOperation.this.fChange);
                                    }
                                }
                                PerformChangeOperation.this.fChange.dispose();
                                if (PerformChangeOperation.this.fUndoChange != null) {
                                    PerformChangeOperation.this.fUndoChange.initializeValidationData((IProgressMonitor)new NotCancelableProgressMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                                    undoInitialized = true;
                                }
                                if (PerformChangeOperation.this.fUndoManager == null) break block21;
                                if (PerformChangeOperation.this.fUndoChange != null) {
                                    PerformChangeOperation.this.fUndoManager.addUndo(PerformChangeOperation.this.fUndoName, PerformChangeOperation.this.fUndoChange);
                                    break block21;
                                } else {
                                    PerformChangeOperation.this.fUndoManager.flush();
                                }
                                break block21;
                            }
                            catch (CoreException e) {
                                if (PerformChangeOperation.this.fUndoManager != null) {
                                    PerformChangeOperation.this.fUndoManager.flush();
                                }
                                if (PerformChangeOperation.this.fUndoChange != null && undoInitialized) {
                                    Change ch = PerformChangeOperation.this.fUndoChange;
                                    PerformChangeOperation.this.fUndoChange = null;
                                    ch.dispose();
                                }
                                PerformChangeOperation.this.fUndoChange = null;
                                throw e;
                            }
                            catch (RuntimeException e) {
                                if (PerformChangeOperation.this.fUndoManager != null) {
                                    PerformChangeOperation.this.fUndoManager.flush();
                                }
                                if (PerformChangeOperation.this.fUndoChange != null && undoInitialized) {
                                    Change ch = PerformChangeOperation.this.fUndoChange;
                                    PerformChangeOperation.this.fUndoChange = null;
                                    ch.dispose();
                                }
                                PerformChangeOperation.this.fUndoChange = null;
                                throw e;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_4 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return;
                }
                Object var6_5 = null;
                monitor.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, pm);
    }

    private boolean createChange() {
        return this.fCreateChangeOperation != null;
    }
}

