/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.debug.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.internal.ui.debug.model.AntDebugElement;
import org.eclipse.ant.internal.ui.debug.model.AntDebugTarget;
import org.eclipse.ant.internal.ui.debug.model.AntProperty;
import org.eclipse.ant.internal.ui.debug.model.AntStackFrame;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class AntThread
extends AntDebugElement
implements IThread {
    private IBreakpoint[] fBreakpoints;
    private List fFrames = new ArrayList(1);
    private boolean fStepping = false;
    private List fProperties;
    private boolean fRefreshProperties = true;

    public AntThread(AntDebugTarget target) {
        super(target);
    }

    public synchronized IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended() && this.fFrames.size() == 0) {
            this.getStackFrames0();
        }
        return this.fFrames.toArray(new IStackFrame[this.fFrames.size()]);
    }

    private void getStackFrames0() {
        this.fTarget.getStackFrames();
        if (this.fFrames.size() > 0) {
            return;
        }
        try {
            ((Object)((Object)this)).wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames != null && frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public String getName() {
        return "Thread [Ant Build]";
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.fBreakpoints;
    }

    protected void setBreakpoints(IBreakpoint[] breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public synchronized void resume() throws DebugException {
        this.aboutToResume(32, false);
        this.getDebugTarget().resume();
    }

    public synchronized void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public synchronized void stepInto() throws DebugException {
        this.aboutToResume(1, true);
        ((AntDebugTarget)this.getDebugTarget()).stepInto();
    }

    private void aboutToResume(int detail, boolean stepping) {
        this.fRefreshProperties = true;
        this.fFrames.clear();
        this.setStepping(stepping);
        this.setBreakpoints(null);
        this.fireResumeEvent(detail);
    }

    public synchronized void stepOver() throws DebugException {
        this.aboutToResume(2, true);
        ((AntDebugTarget)this.getDebugTarget()).stepOver();
    }

    public synchronized void stepReturn() throws DebugException {
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.fFrames.clear();
        this.getDebugTarget().terminate();
    }

    protected void setStepping(boolean stepping) {
        this.fStepping = stepping;
    }

    public synchronized void buildStack(String data) {
        String[] strings = data.split(",");
        this.fFrames.clear();
        int stackFrameId = 0;
        int i = 1;
        while (i < strings.length) {
            String name = String.valueOf(strings[i]) + ": " + strings[++i];
            String filePath = strings[++i];
            int lineNumber = Integer.parseInt(strings[++i]);
            AntStackFrame frame = new AntStackFrame(this, stackFrameId++, name, filePath, lineNumber);
            this.fFrames.add(frame);
            ++i;
        }
        ((Object)((Object)this)).notifyAll();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void newProperties(String data) {
        try {
            String[] datum = data.split(",");
            if (this.fProperties == null) {
                this.fProperties = new ArrayList(datum.length);
            }
            if (datum.length > 1) {
                int i = 1;
                block3: while (i < datum.length) {
                    String propertyValue;
                    int propertyValueLength;
                    int propertyNameLength = Integer.parseInt(datum[i]);
                    String propertyName = datum[++i];
                    while (true) {
                        if (propertyName.length() == propertyNameLength) {
                            propertyValue = (propertyValueLength = Integer.parseInt(datum[++i])) == 0 && i + 1 == datum.length ? "" : datum[++i];
                        }
                        propertyName = String.valueOf(propertyName) + "," + datum[++i];
                    }
                    while (true) {
                        if (propertyValue.length() == propertyValueLength) {
                            AntProperty property = new AntProperty((AntDebugTarget)this.getDebugTarget(), propertyName, propertyValue);
                            this.fProperties.add(property);
                            ++i;
                            continue block3;
                        }
                        propertyValue = String.valueOf(propertyValue) + "," + datum[++i];
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.fRefreshProperties = false;
            ((Object)((Object)this)).notifyAll();
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.fRefreshProperties = false;
            ((Object)((Object)this)).notifyAll();
            return;
        }
    }

    protected synchronized IVariable[] getVariables() {
        if (this.fRefreshProperties) {
            this.fTarget.getProperties();
            if (this.fRefreshProperties) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.fProperties.toArray(new IVariable[this.fProperties.size()]);
    }
}

