/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.formatter;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.formatter.FormattingPreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class XmlDocumentFormatter {
    private int depth = -1;
    private StringBuffer formattedXml;
    private boolean lastNodeWasText;

    private void copyNode(Reader reader, StringBuffer out, FormattingPreferences prefs) throws IOException {
        TagReader tag = TagReaderFactory.createTagReaderFor(reader);
        this.depth += tag.getPreTagDepthModifier();
        if (!this.lastNodeWasText) {
            if (tag.startsOnNewline() && !this.hasNewlineAlready(out)) {
                out.append("\n");
            }
            if (tag.requiresInitialIndent()) {
                out.append(this.indent(prefs.getCanonicalIndent()));
            }
        }
        out.append(tag.getTagText());
        this.depth += tag.getPostTagDepthModifier();
        this.lastNodeWasText = tag.isTextNode();
    }

    public static int computeIndent(String line, int tabWidth) {
        int result = 0;
        int blanks = 0;
        int size = line.length();
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (c == '\t') {
                ++result;
                blanks = 0;
            } else if (XmlDocumentFormatter.isIndentChar(c)) {
                if (++blanks == tabWidth) {
                    ++result;
                    blanks = 0;
                }
            } else {
                return result;
            }
            ++i;
        }
        return result;
    }

    public static boolean isIndentChar(char ch) {
        return Character.isWhitespace(ch) && !XmlDocumentFormatter.isLineDelimiterChar(ch);
    }

    public static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public String format(String documentText, FormattingPreferences prefs) {
        Assert.isNotNull((Object)documentText);
        Assert.isNotNull((Object)prefs);
        StringReader reader = new StringReader(documentText);
        this.formattedXml = new StringBuffer();
        if (this.depth == -1) {
            this.depth = 0;
        }
        this.lastNodeWasText = false;
        try {
            while (true) {
                ((Reader)reader).mark(1);
                int intChar = ((Reader)reader).read();
                ((Reader)reader).reset();
                if (intChar == -1) break;
                this.copyNode(reader, this.formattedXml, prefs);
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            AntUIPlugin.log(e);
        }
        return this.formattedXml.toString();
    }

    private boolean hasNewlineAlready(StringBuffer out) {
        return out.lastIndexOf("\n") == this.formattedXml.length() - 1 || out.lastIndexOf("\r") == this.formattedXml.length() - 1;
    }

    private String indent(String canonicalIndent) {
        StringBuffer indent = new StringBuffer(30);
        int i = 0;
        while (i < this.depth) {
            indent.append(canonicalIndent);
            ++i;
        }
        return indent.toString();
    }

    public void setInitialIndent(int indent) {
        this.depth = indent;
    }

    public static StringBuffer getLeadingWhitespace(int offset, IDocument document) {
        StringBuffer indent = new StringBuffer();
        try {
            IRegion line = document.getLineInformationOfOffset(offset);
            int lineOffset = line.getOffset();
            int nonWS = XmlDocumentFormatter.findEndOfWhiteSpace(document, lineOffset, lineOffset + line.getLength());
            indent.append(document.get(lineOffset, nonWS - lineOffset));
            return indent;
        }
        catch (BadLocationException badLocationException) {
            return indent;
        }
    }

    public static int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    public static StringBuffer createIndent() {
        StringBuffer oneIndent = new StringBuffer();
        IPreferenceStore pluginPrefs = AntUIPlugin.getDefault().getPreferenceStore();
        pluginPrefs.getBoolean("formatter_tab_char");
        if (!pluginPrefs.getBoolean("formatter_tab_char")) {
            int tabLen = pluginPrefs.getInt("formatter_tab_size");
            int i = 0;
            while (i < tabLen) {
                oneIndent.append(' ');
                ++i;
            }
        } else {
            oneIndent.append('\t');
        }
        return oneIndent;
    }

    private static class CommentReader
    extends TagReader {
        private boolean complete = false;

        CommentReader() {
        }

        protected void clear() {
            this.complete = false;
        }

        public String getStartOfTag() {
            return "<!--";
        }

        protected String readTag() throws IOException {
            int intChar;
            StringBuffer node = new StringBuffer();
            while (!this.complete && (intChar = this.reader.read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c != '>' || !node.toString().endsWith("-->")) continue;
                this.complete = true;
            }
            return node.toString();
        }
    }

    private static class DoctypeDeclarationReader
    extends TagReader {
        private boolean complete = false;

        DoctypeDeclarationReader() {
        }

        protected void clear() {
            this.complete = false;
        }

        public String getStartOfTag() {
            return "<!";
        }

        protected String readTag() throws IOException {
            int intChar;
            StringBuffer node = new StringBuffer();
            while (!this.complete && (intChar = this.reader.read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c != '>') continue;
                this.complete = true;
            }
            return node.toString();
        }
    }

    private static class ProcessingInstructionReader
    extends TagReader {
        private boolean complete = false;

        ProcessingInstructionReader() {
        }

        protected void clear() {
            this.complete = false;
        }

        public String getStartOfTag() {
            return "<?";
        }

        protected String readTag() throws IOException {
            int intChar;
            StringBuffer node = new StringBuffer();
            while (!this.complete && (intChar = this.reader.read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c != '>' || !node.toString().endsWith("?>")) continue;
                this.complete = true;
            }
            return node.toString();
        }
    }

    private static abstract class TagReader {
        protected Reader reader;
        private String tagText;

        TagReader() {
        }

        protected abstract void clear();

        public int getPostTagDepthModifier() {
            return 0;
        }

        public int getPreTagDepthModifier() {
            return 0;
        }

        public abstract String getStartOfTag();

        public String getTagText() {
            return this.tagText;
        }

        public boolean isTextNode() {
            return false;
        }

        protected abstract String readTag() throws IOException;

        public boolean requiresInitialIndent() {
            return true;
        }

        public void setReader(Reader reader) throws IOException {
            this.reader = reader;
            this.clear();
            this.tagText = this.readTag();
        }

        public boolean startsOnNewline() {
            return true;
        }
    }

    private static class TagReaderFactory {
        private static TagReader[] tagReaders = new TagReader[]{new CommentReader(), new DoctypeDeclarationReader(), new ProcessingInstructionReader(), new XmlElementReader()};
        private static TagReader textNodeReader = new TextReader();

        TagReaderFactory() {
        }

        public static TagReader createTagReaderFor(Reader reader) throws IOException {
            char[] buf = new char[10];
            reader.mark(10);
            reader.read(buf, 0, 10);
            reader.reset();
            String startOfTag = String.valueOf(buf);
            int i = 0;
            while (i < tagReaders.length) {
                if (startOfTag.startsWith(tagReaders[i].getStartOfTag())) {
                    tagReaders[i].setReader(reader);
                    return tagReaders[i];
                }
                ++i;
            }
            textNodeReader.setReader(reader);
            return textNodeReader;
        }
    }

    private static class TextReader
    extends TagReader {
        private boolean complete;
        private boolean isTextNode;

        TextReader() {
        }

        protected void clear() {
            this.complete = false;
        }

        public String getStartOfTag() {
            return "";
        }

        public boolean isTextNode() {
            return this.isTextNode;
        }

        protected String readTag() throws IOException {
            StringBuffer node = new StringBuffer();
            while (!this.complete) {
                this.reader.mark(1);
                int intChar = this.reader.read();
                if (intChar == -1) break;
                char c = (char)intChar;
                if (c == '<') {
                    this.reader.reset();
                    this.complete = true;
                    continue;
                }
                node.append(c);
            }
            if (node.length() < 1) {
                this.isTextNode = false;
            } else if (node.toString().trim().length() == 0) {
                String whitespace = node.toString();
                node = new StringBuffer();
                int i = 0;
                while (i < whitespace.length()) {
                    char whitespaceCharacter = whitespace.charAt(i);
                    if (whitespaceCharacter == '\n') {
                        node.append(whitespaceCharacter);
                    }
                    ++i;
                }
                this.isTextNode = false;
            } else {
                this.isTextNode = true;
            }
            return node.toString();
        }

        public boolean requiresInitialIndent() {
            return false;
        }

        public boolean startsOnNewline() {
            return false;
        }
    }

    private static class XmlElementReader
    extends TagReader {
        private boolean complete = false;

        XmlElementReader() {
        }

        protected void clear() {
            this.complete = false;
        }

        public int getPostTagDepthModifier() {
            if (this.getTagText().endsWith("/>") || this.getTagText().endsWith("/ >")) {
                return 0;
            }
            if (this.getTagText().startsWith("</")) {
                return 0;
            }
            return 1;
        }

        public int getPreTagDepthModifier() {
            if (this.getTagText().startsWith("</")) {
                return -1;
            }
            return 0;
        }

        public String getStartOfTag() {
            return "<";
        }

        protected String readTag() throws IOException {
            int intChar;
            StringBuffer node = new StringBuffer();
            boolean insideQuote = false;
            while (!this.complete && (intChar = this.reader.read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c == '\"') {
                    boolean bl = insideQuote = !insideQuote;
                }
                if (c != '>' || insideQuote) continue;
                this.complete = true;
            }
            return node.toString();
        }
    }
}

