/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.model.AntModelContentProvider;
import org.eclipse.ant.internal.ui.model.AntModelLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.help.WorkbenchHelp;

public class TargetOrderDialog
extends Dialog
implements ISelectionChangedListener {
    private Button fUp;
    private Button fDown;
    private TableViewer fViewer;
    private Object[] fTargets;

    public TargetOrderDialog(Shell parentShell, Object[] targets) {
        super(parentShell);
        this.fTargets = targets;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(AntLaunchConfigurationMessages.getString("TargetOrderDialog.Order_Targets_1"));
        Composite comp = (Composite)super.createDialogArea(parent);
        ((GridLayout)comp.getLayout()).numColumns = 2;
        Label label = new Label(comp, 0);
        label.setText(AntLaunchConfigurationMessages.getString("TargetOrderDialog.&Specify_target_execution_order__2"));
        label.setFont(comp.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.createTargetList(comp);
        this.createButtons(comp);
        this.updateButtons();
        return comp;
    }

    private void createButtons(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData gd = new GridData(256);
        gd.verticalAlignment = 1;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)gd);
        this.fUp = new Button(comp, 8);
        this.fUp.setFont(parent.getFont());
        this.fUp.setText(AntLaunchConfigurationMessages.getString("TargetOrderDialog.&Up_3"));
        this.setButtonLayoutData(this.fUp);
        this.fUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetOrderDialog.this.handleUpPressed();
            }
        });
        this.fDown = new Button(comp, 8);
        this.fDown.setFont(parent.getFont());
        this.fDown.setText(AntLaunchConfigurationMessages.getString("TargetOrderDialog.&Down_4"));
        this.setButtonLayoutData(this.fDown);
        this.fDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetOrderDialog.this.handleDownPressed();
            }
        });
    }

    private void handleDownPressed() {
        List targets = this.getOrderedSelection();
        if (targets.isEmpty()) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(this.fTargets));
        int bottom = list.size() - 1;
        int index = 0;
        int i = targets.size() - 1;
        while (i >= 0) {
            Object target = targets.get(i);
            index = list.indexOf(target);
            if (index < bottom) {
                bottom = index + 1;
                Object temp = list.get(bottom);
                list.set(bottom, target);
                list.set(index, temp);
            }
            bottom = index;
            --i;
        }
        this.setEntries(list);
    }

    private void handleUpPressed() {
        List targets = this.getOrderedSelection();
        if (targets.isEmpty()) {
            return;
        }
        int top = 0;
        int index = 0;
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(this.fTargets));
        Iterator entries = targets.iterator();
        while (entries.hasNext()) {
            Object target = entries.next();
            index = list.indexOf(target);
            if (index > top) {
                top = index - 1;
                Object temp = list.get(top);
                list.set(top, target);
                list.set(index, temp);
            }
            top = index;
        }
        this.setEntries(list);
    }

    private void setEntries(List list) {
        this.fTargets = list.toArray();
        this.fViewer.setInput((Object)this.fTargets);
        this.fViewer.setSelection(this.fViewer.getSelection());
    }

    private List getOrderedSelection() {
        ArrayList<Object> targets = new ArrayList<Object>();
        List selection = ((IStructuredSelection)this.fViewer.getSelection()).toList();
        Object[] entries = this.fTargets;
        int i = 0;
        while (i < entries.length) {
            Object target = entries[i];
            if (selection.contains(target)) {
                targets.add(target);
            }
            ++i;
        }
        return targets;
    }

    private void createTargetList(Composite comp) {
        this.fViewer = new TableViewer(comp, 67586);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new AntModelLabelProvider());
        this.fViewer.setContentProvider((IContentProvider)new AntModelContentProvider());
        this.fViewer.setInput((Object)this.fTargets);
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Table table = this.fViewer.getTable();
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 250;
        table.setLayoutData((Object)gd);
        table.setFont(comp.getFont());
    }

    public Object[] getTargets() {
        return this.fTargets;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        int[] selections = this.fViewer.getTable().getSelectionIndices();
        int last = this.fTargets.length - 1;
        boolean up = selections.length > 0;
        boolean down = selections.length > 0;
        int i = 0;
        while (i < selections.length) {
            if (selections[i] == 0) {
                up = false;
            }
            if (selections[i] == last) {
                down = false;
            }
            ++i;
        }
        this.fUp.setEnabled(up);
        this.fDown.setEnabled(down);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.ant.ui.target_order_dialog_context");
    }
}

