/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.types.Path;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;

public class AntDefiningTaskNode
extends AntTaskNode {
    public AntDefiningTaskNode(Task task, String label) {
        super(task, label);
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        String taskName = this.getTask().getTaskName();
        if ("taskdef".equalsIgnoreCase(taskName) || "typedef".equalsIgnoreCase(taskName)) {
            return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antTaskdef");
        }
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antMacrodef");
    }

    public boolean configure(boolean validateFully) {
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        boolean enabled = store.getBoolean("content_assist_userDefinedTasks");
        if (enabled) {
            try {
                this.getTask().maybeConfigure();
                this.getTask().execute();
                return false;
            }
            catch (BuildException be) {
                this.handleBuildException(be, "problem_classpath");
            }
        }
        return false;
    }

    public Object getRealTask() {
        Task task = this.getTask();
        if (task instanceof UnknownElement) {
            task.maybeConfigure();
            return ((UnknownElement)task).getRealThing();
        }
        return task;
    }

    public static void setJavaClassPath() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        URL[] antClasspath = prefs.getURLs();
        AntDefiningTaskNode.setJavaClassPath(antClasspath);
    }

    public static void setJavaClassPath(URL[] antClasspath) {
        Path systemClasspath;
        StringBuffer buff = new StringBuffer();
        File file = null;
        int i = 0;
        while (i < antClasspath.length) {
            block3: {
                try {
                    file = new File(Platform.asLocalURL((URL)antClasspath[i]).getPath());
                }
                catch (IOException iOException) {
                    break block3;
                }
                buff.append(file.getAbsolutePath());
                buff.append("; ");
            }
            ++i;
        }
        Path.systemClasspath = systemClasspath = new Path(null, buff.substring(0, buff.length() - 2));
    }

    protected void setParent(AntElementNode node) {
        super.setParent(node);
        this.getProjectNode().addDefiningTaskNode(this);
    }

    public boolean collapseProjection() {
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("editor_folding_defining");
    }
}

