/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntDefiningTaskNode;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntModelProject;
import org.eclipse.ant.internal.ui.model.AntPropertyNode;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.ant.internal.ui.model.LocationProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;

public class AntProjectNode
extends AntElementNode {
    protected AntModelProject fProject;
    protected IAntModel fModel;
    private Map fNameToDefiningNodeMap;
    private String fLabel;

    public AntProjectNode(AntModelProject project, IAntModel antModel) {
        super("project");
        this.fProject = project;
        this.fModel = antModel;
    }

    public String getLabel() {
        if (this.fLabel == null) {
            this.fLabel = this.fProject != null ? this.fProject.getName() : AntModelMessages.getString("AntProjectNode.0");
            if (this.fLabel == null || this.fLabel.length() == 0) {
                this.fLabel = "project";
            }
        }
        return this.fLabel;
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antProject");
    }

    public Project getProject() {
        return this.fProject;
    }

    protected IAntModel getAntModel() {
        return this.fModel;
    }

    public void reset() {
        super.reset();
        this.fProject.reset();
        if (this.fNameToDefiningNodeMap != null && this.getAntModel() instanceof AntModel) {
            ((AntModel)this.getAntModel()).setNamesOfOldDefiningNodes(this.fNameToDefiningNodeMap.keySet());
        }
        this.fNameToDefiningNodeMap = null;
        this.setProblemSeverity(-1);
        this.setProblemMessage(null);
        this.fOffset = -1;
        this.fLength = -1;
    }

    public void addDefiningTaskNode(AntDefiningTaskNode node) {
        String label;
        if (this.fNameToDefiningNodeMap == null) {
            this.fNameToDefiningNodeMap = new HashMap();
        }
        if ((label = node.getLabel()).equalsIgnoreCase("macrodef") || label.equalsIgnoreCase("presetdef") || label.equalsIgnoreCase("typedef") || label.equalsIgnoreCase("taskdef")) {
            return;
        }
        this.fNameToDefiningNodeMap.put(node.getLabel(), node);
    }

    public AntDefiningTaskNode getDefininingTaskNode(String nodeName) {
        if (this.fNameToDefiningNodeMap != null) {
            return (AntDefiningTaskNode)this.fNameToDefiningNodeMap.get(nodeName);
        }
        return null;
    }

    public String getDescription() {
        return this.fProject.getDescription();
    }

    public String getBuildFileName() {
        IFile file;
        LocationProvider locationProvider = this.getAntModel().getLocationProvider();
        if (locationProvider != null && (file = locationProvider.getFile()) != null) {
            return file.getFullPath().toOSString();
        }
        return null;
    }

    public String getDefaultTargetName() {
        return this.fProject.getDefaultTarget();
    }

    public void setCurrentConfiguringProperty(AntPropertyNode node) {
        AntModelProject project = (AntModelProject)this.getProject();
        project.setCurrentConfiguringProperty(node);
    }

    public AntProjectNode getProjectNode() {
        return this;
    }
}

