/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.editor.AntEditorCompletionProcessor;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.xml.sax.Attributes;

public class AntPropertyNode
extends AntTaskNode {
    private String fValue = null;
    private String fReferencedName;
    private Map fProperties = null;

    public AntPropertyNode(Task task, Attributes attributes) {
        super(task);
        String label = attributes.getValue("name");
        if (label == null) {
            label = attributes.getValue("file");
            if (label != null) {
                this.fReferencedName = label;
                label = "file=" + label;
            } else {
                label = attributes.getValue("resource");
                if (label != null) {
                    this.fReferencedName = label;
                    label = "resource=" + label;
                } else {
                    label = attributes.getValue("environment");
                    if (label != null) {
                        label = "environment=" + label;
                    }
                }
            }
        } else {
            this.fValue = attributes.getValue("value");
        }
        this.setBaseLabel(label);
    }

    public String getValue() {
        return this.fValue;
    }

    public String getProperty(String propertyName) {
        if (this.fProperties != null) {
            return (String)this.fProperties.get(propertyName);
        }
        return null;
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.IMG_PROPERTY");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean configure(boolean validateFully) {
        if (this.fConfigured) {
            return false;
        }
        try {
            try {
                this.getProjectNode().setCurrentConfiguringProperty(this);
                this.getTask().maybeConfigure();
                this.getTask().execute();
                this.fConfigured = true;
            }
            catch (BuildException be) {
                this.handleBuildException(be, "problem_properties");
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.getProjectNode().setCurrentConfiguringProperty(null);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.getProjectNode().setCurrentConfiguringProperty(null);
            return false;
        }
    }

    public void addProperty(String propertyName, String value) {
        if (this.fProperties == null) {
            this.fProperties = new HashMap(1);
        }
        this.fProperties.put(propertyName, value);
    }

    public String getReferencedElement(int offset) {
        String attributeString;
        String textToSearch;
        if (this.fReferencedName != null && (textToSearch = this.getAntModel().getText(this.getOffset(), offset - this.getOffset())) != null && textToSearch.length() != 0 && ("file".equals(attributeString = AntEditorCompletionProcessor.getAttributeStringFromDocumentStringToPrefix(textToSearch)) || "resource".equals(attributeString))) {
            return this.fReferencedName;
        }
        return null;
    }
}

