/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.core.Type;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.AntClasspathPage;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.AntPropertiesPage;
import org.eclipse.ant.internal.ui.preferences.AntTasksPage;
import org.eclipse.ant.internal.ui.preferences.AntTypesPage;
import org.eclipse.ant.internal.ui.preferences.TabFolderLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntRuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private AntClasspathPage classpathPage;
    private AntTasksPage tasksPage;
    private AntTypesPage typesPage;
    private AntPropertiesPage propertiesPage;

    public AntRuntimePreferencePage() {
        this.setDescription(AntPreferencesMessages.getString("AntPreferencePage.description"));
        this.setPreferenceStore(AntUIPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ant.ui.ant_runtime_preference_page_context");
        this.initializeDialogUnits((Control)parent);
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        folder.setFont(parent.getFont());
        this.classpathPage = new AntClasspathPage(this);
        this.classpathPage.createTabItem(folder);
        this.tasksPage = new AntTasksPage(this);
        this.tasksPage.createTabItem(folder);
        this.typesPage = new AntTypesPage(this);
        this.typesPage.createTabItem(folder);
        this.propertiesPage = new AntPropertiesPage(this);
        this.propertiesPage.createTabItem(folder);
        this.tasksPage.initialize();
        this.typesPage.initialize();
        this.classpathPage.initialize();
        this.propertiesPage.initialize();
        return folder;
    }

    protected void performDefaults() {
        super.performDefaults();
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.tasksPage.setInput(prefs.getDefaultTasks());
        this.typesPage.setInput(prefs.getDefaultTypes());
        this.classpathPage.performDefaults();
        this.propertiesPage.performDefaults();
    }

    public boolean performOk() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        prefs.setAntHomeClasspathEntries(this.classpathPage.getAntHomeEntries());
        prefs.setAdditionalClasspathEntries(this.classpathPage.getAdditionalEntries());
        String antHome = this.classpathPage.getAntHome();
        prefs.setAntHome(antHome);
        List contents = this.tasksPage.getContents(false);
        if (contents != null) {
            Task[] tasks = contents.toArray(new Task[contents.size()]);
            prefs.setCustomTasks(tasks);
        }
        if ((contents = this.typesPage.getContents(false)) != null) {
            Type[] types = contents.toArray(new Type[contents.size()]);
            prefs.setCustomTypes(types);
        }
        if ((contents = this.propertiesPage.getProperties()) != null) {
            Property[] properties = contents.toArray(new Property[contents.size()]);
            prefs.setCustomProperties(properties);
        }
        String[] files = this.propertiesPage.getPropertyFiles();
        prefs.setCustomPropertyFiles(files);
        prefs.updatePluginPreferences();
        return super.performOk();
    }

    protected GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    protected List getLibraryEntries() {
        ArrayList<IAntClasspathEntry> urls = new ArrayList<IAntClasspathEntry>();
        urls.addAll(Arrays.asList(this.classpathPage.getAntHomeEntries()));
        urls.addAll(Arrays.asList(this.classpathPage.getAdditionalEntries()));
        return urls;
    }
}

